-- [author]
-- Richard Nelson @ Mondo Media
-- copyright (C) Mondo Media, 1999

-- [description]
-- Labels a set of time ranges, for easy selection, saving and loading.

-- [instructions]
-- Press <View Ranges> to create the Range Namer floater.
-- Either enter the starting and ending times, or press Get Current
-- Time Range to use MAX's existing animation range.
-- Type in a name for the current range, and press Add/Change
-- to add it, if it doesn't exist, or change an existing time range
-- with the given name.
-- You can delete a time range by selecting it and pressing Delete.
-- Save and Load saves and loads the range names, of course.

-- 's are used for comments don't delete them.

utility rangenamerlaunch "Q2Ranger"
(
	rollout defloat "Dock"
	(
		button dock "Dock"
		on dock pressed do (
			removerollout rangenamer gw
			addrollout rangenamer
			closerolloutfloater gw
		)
	)
	button makefloater "View Ranges"
	--on rangenamerlaunch open do (addrollout rangenamer)
	--on rangenamerlaunch close do (removerollout rangenamer)
	on makefloater pressed do
	(
			gw = newRolloutFloater "Q2 Ranger" 180 426
			--removerollout rangenamer
			--addrollout defloat gw
			addRollout rangenamer gw
	)
)

	global sequences = #()
	global sequencenames = #()
	rollout rangenamer "Q2 Ranger"
	(
		label l0 "Sequences"
		listbox sequenceList
		edittext sequenceName
		spinner startframe "Start" type:#integer range:[-1000,1000,0]
		spinner endframe "End" type:#integer range:[-1000,1000,1]
		button fromcurrent "Get Current Time Range"
		button addit "Add/Change" pos:[18,257]
		button deleteit "Delete" pos:[98,257]
		button saveit "Save" pos:[38,282]
		button loadit "Load" pos:[82, 282]
		function reinit = 
		(
			sequenceList.items = #()
			i = 1
			for mytext in sequencenames do
			(
				sequenceList.items = append sequenceList.items (mytext + " [" + (sequences[i][1] as string) + "," + (sequences[i][2] as string) + "]")
				i = i + 1
			)
		)
		on fromcurrent pressed do
		(
			startframe.value = animationrange.start
			endframe.value = animationrange.end
		)
		on saveit pressed do
		(
			filename = getsavefilename caption:"Save Time Ranges" types:"Time Ranges(*.tim)|*.tim|All Files(*.*)|*.*"
			if (filename != undefined) then
			(
				fileptr = openfile filename mode:"w"
				for i = 1 to sequencenames.count do
				(
					format "\"%\" % %\n" sequencenames[i] sequences[i][1] sequences[i][2] to:fileptr
				)
				close fileptr
			)
		)
		on loadit pressed do
		(
			filename = getopenfilename caption:"Load Time Ranges" types:"Time Ranges(*.tim)|*.tim|All Files(*.*)|*.*"
			if (filename != undefined) then
			(
				fileptr = openfile filename mode:"r"
				sequences = #()
				sequencenames = #()
				while (not eof fileptr) do
				(
					sequencenames = append sequencenames (readvalue fileptr)
					sequences = append sequences #((readvalue fileptr), (readvalue fileptr))
				)
				reinit ()
				close fileptr
			)
		)
		on startframe changed val do
		(
			if val >= endframe.value then endframe.value = val + 1
		)
		on endframe changed val do
		(
			if val <= startframe.value then startframe.value = val - 1
		)
		on rangenamer open do
		(
			reinit ()
		)
		on sequenceList doubleclicked sel do
		(
			animationrange = interval sequences[sel][1] sequences[sel][2]
		)
		on sequenceList selected sel do
		(
			startframe.value = sequences[sel][1]
			endframe.value = sequences[sel][2]
			sequencename.text = sequencenames[sel]
		)
		on addit pressed do
		(
			mytext = sequenceName.text
			index = (finditem sequencenames mytext)
			if index == 0 then
			(
				sequenceList.items = append sequenceList.items (mytext + " [" + (startframe.value as string) + "," + (endframe.value as string) + "]")
				append sequences #(startframe.value, endframe.value)
				append sequencenames mytext
				sequenceList.selection = sequenceList.items.count
			) else
			(
				sequenceList.selection = index
				sequences[index] = #(startframe.value, endframe.value)
				reinit ()
			)
		)
		on deleteit pressed do
		(
			if sequencelist.selection <= sequenceList.items.count then
			(
				whichdelete = sequencelist.selection
				sequencelist.items = deleteitem sequencelist.items whichdelete
				sequencenames = deleteitem sequencenames whichdelete
				sequences = deleteitem sequences whichdelete
			)
		)
	)
