
// This module defines a bunch of operations on Models.

#ifndef __MODEL_OPS_H__
#define __MODEL_OPS_H__


	void model_BuildFlatNodeList(Model *pModel);
	void model_BuildDNodeList(Model *pModel);
	void model_BuildAnimDNodeList(Model *pModel, ModelAnim *pAnim);
	void model_BuildTransformList(Model *pModel);

	ModelAnim* model_FindAnim(Model *pModel, char *pName);
	void model_SetAnimTrans(Model *pModel, ModelAnim *pAnim, DVector *pNewTrans);
	

	// Create the transforms for the model.
	void model_CreateTransforms(Model *pModel, 
		ModelAnim *pAnim1,	ModelAnim *pAnim2, 
		unsigned long iKey1, unsigned long iKey2, float percent,
		DMatrix *pTransformList);

	// Create the transforms, but start with a transform you specify.
	void model_CreateTransforms2(Model *pModel, 
		ModelAnim *pAnim1, ModelAnim *pAnim2, 
		unsigned long iKey1, unsigned long iKey2, float percent,
		DMatrix *pStartMat, DMatrix *pTransformList);

	void model_GetNodeTransform(Model *pModel, ModelAnim *pAnim1, ModelAnim *pAnim2, 
		unsigned long iKey1, unsigned long iKey2, float percent, DWORD dwNodeIndex,
		DMatrix *pStartTransform, DMatrix *pTransform);

	void model_GetAnimBox(Model *pModel, ModelAnim *pAnim, DVector *pMin, DVector *pMax);
	
	// Interpolates the deformation vertices the specified amount.
	void model_InterpolateDVertices(Model *pModel, ModelAnim *pAnim1, ModelAnim *pAnim2,
		DWORD iKey1, DWORD iKey2, float percent);

	// Update the bounding box for the vertices on the specified keyframe.
	void model_UpdateBoundingBox(Model *pModel, ModelAnim *pAnim, DWORD iKey1, DWORD iKey2, float percent,
		DVector *pMin, DVector *pMax);

	char* model_AddToStringList(Model *pModel, char *pString);

	// Get rid of the given keyframe from the model.
	void model_RemoveKeyFrame(Model *pModel, unsigned long iAnim, unsigned long iKeyFrame);

	AnimKeyFrame* model_AllocKeyFrames(int nKeyFrames);
	ModelNode* model_AllocNodes(int nNodes);
	ModelAnim* model_AllocAnims(int nAnims);
	void model_DestroyAnim(ModelAnim *pAnim);

	// Copies uv coordinates from a model with the same geometry.
	short model_CopyUVCoords( Model *pDest, Model *pSrc );
	
	// Copies uv coordinates from a model with different geometry, but (hopefully) the same
	// vertex positions on the (first frame of) the given animations.
	int model_CopyUVCoords2(Model *pDest, Model *pSrc, ModelAnim *pDestAnim, ModelAnim *pSrcAnim);


	// Set the animation framerate.
	void model_SetAnimFramerate(Model *pModel, unsigned long iAnim, float framerate);

	// Flip between left-handed and right-handed coordinate systems.
	void model_Flip(Model *pModel);

	void model_ParseCommandString( Model *pModel );

	// Remove all LOD info from the model.
	void model_ClearLODInfo(Model *pModel);

	// Copy an animation (doesn't copy pointers.. just makes its own copy of everything).
	// Assumes pDest is empty and that the model geometry matches.  Returns FALSE if 
	// it detects different geometry (but it can still mess up if the geometry is different).
	BOOL model_CopyAnim(Model *pDestModel, ModelAnim *pDest, ModelAnim *pSrc);

	// Sets m_pAnim in the AnimNodes.
	void model_SetAnimNodeAnimPointers(ModelAnim *pAnim, AnimNode *pRoot);

	// Removes all LODs leading up to iLOD.
	void model_SquashLODs(Model *pModel, DWORD iLOD);


#endif  // __MODEL_OPS_H__


