//------------------------------------------------------------------ //
// The model_load module implements all of the model
// creating and loading.  It's in its own module so things like
// render DLLs don't have to care about the extra stuff involved
// with loading the models.
//------------------------------------------------------------------ //

#ifndef __MODEL_LOAD_H__
#define __MODEL_LOAD_H__


	#include "model.h"


	// Returns NULL if the file is an invalid version.
	Model* model_Load(struct DStream_t *pStream);

	// Load the model file just to get the dimensions.
	// Returns 0 for false, 1 for true...
	short model_LoadDimensions(struct DStream_t *pStream, DVector *pvDims );

	void model_GetDimsFromBounding( DVector *pvBoundMax, DVector *pvBoundMin, DVector *pvDims );

	// Create a blank model.
	Model* model_Create();

	// Deletes the model stuff.
	void model_Destroy(Model *pModel);


#endif  // __MODEL_LOAD_H__



