/*
Filename:     CVec3.h
Date:         February 12, 1998
Author:       Peter Hogan aka PeteDog
Author Email: hoganpet@pilot.msu.edu
Description : header file for the CVec3 class intended to replaces id's typedef
              array of 3 floats: vec3_t.  Many functions that used to require
			  verbose statements, are now supported with operator funciont like +,-, and *.  
			  This class can be defined independantly of the vec3_t type, infact, don't even
			  dirty this file with vec3_t at all!
Required Headers: none
*/
#ifndef PTH_CVEC3_H
#define PTH_CVEC3_H

/////////////////////////////////////////////////////////////////
// CLASS CVEC3 CLASS CVEC3 CLASS CVEC3 CLASS CVEC3 CLASS CVEC3 //
/////////////////////////////////////////////////////////////////
class CVec3
{
public:
    double x;			// The actual data members we want to use
    double y;
    double z;

	// OPERATOR FUNCS
	operator float*();	// this func is called when returning a pseudo vec3_t to the
						// game engine so the type must be to an array of floats
	operator double*(); // equivilent where a double type is needed

	double& operator[](int n);	// simulate array ability for use in game code
								// not needed but provided for compatibility with old code
								// we don't want to rewrite
	CVec3& operator= (const CVec3& v1);	// easy assignment for CVec3 assignment
	CVec3  operator+ (const CVec3& v1);	// Vector addition
	CVec3  operator- (const CVec3& v1);	// Vector subtraction
	CVec3& operator+=(const CVec3& v1);	// Vector addition/assignment
	CVec3& operator-=(const CVec3& v1);	// Vector subtraction/assignment
	bool   operator==(const CVec3& v1);	// compare
	bool   operator!=(const CVec3& v1); // contrast
	CVec3  operator* (double scale);	// scale it by value of scalar
	double operator* (const CVec3& v1);	// Dot Product 

	// UNARY OPERATORS
	CVec3  operator-();					// Inverse/oposite direction of vector
	
	// CONSTRUCTORS
	CVec3();							// default
	CVec3(const CVec3& v1);				// copy constructor
	CVec3(double dx, double dy, double dz);	// member by memeber

	// VECTOR FUNCS
	CVec3 Normalized();							// returns a vector whose length is one
	CVec3 MA(double scale, const CVec3& v1);	// Returns a vector that = *this + v1*scale (this line don't work though:( ...)
	CVec3 CrossProduct(const CVec3& v1);		// returns cross product against this, but don't alter this
	double Length();							// return length of it
private:
	float m_fv3[3];		// private because we want to use the double  members in our code
						// Note: float[3] is the same thing as vec3_t
	double m_dv3[3];	// for use with operator double*()
};


#endif // PTH_CVEC3_H