/*
Filename:     CVec3.cpp
Date:         February 12, 1998
Author:       Peter Hogan aka PeteDog
Author Email: hoganpet@pilot.msu.edu
Description : implementation file for the CVec3 class intended to replaces id's typedef
              array of 3 floats: vec3_t.  Many functions that used to require
			  verbose statements, are now supported with operator funciont like +,-, and *.  
			  This class can be defined independantly of the vec3_t type, infact, don't even
			  dirty this file with vec3_t at all!
Required Headers: <math.h> ,"CVec3.h"
*/
#ifndef PTH_CVEC3_CPP
#define PTH_CVEC3_CPP

#include <math.h>	// only need for the sqrt() function
#include "CVec3.h"


double& CVec3::operator[](int n)
{
	if (n == 0) return x;
	if (n == 1) return y;
	if (n == 2) return z;
	return x;
}

CVec3::operator float*()
{
	m_fv3[0] = (float)x;
    m_fv3[1] = (float)y;
    m_fv3[2] = (float)z;
	return m_fv3;
}
CVec3::operator double*()
{
	m_dv3[0] = x;
    m_dv3[1] = y;
    m_dv3[2] = z;
	return m_dv3;
}

CVec3& CVec3::operator=(const CVec3& v1)
{
	x = v1.x;
	y = v1.y;
	z = v1.z;
	return *this;
}

CVec3 CVec3::operator+(const CVec3& v1)
{
	CVec3 tv;
	tv.x = x + v1.x;
	tv.y = y + v1.y;
	tv.z = z + v1.z;
	return tv;
}
CVec3 CVec3::Normalized()
{// returns a vector whose length is one
	double dL = this->Length();
	CVec3 tv;

	if(dL)
	{
		dL = 1/dL;
		tv.x = x * dL;
		tv.y = y * dL;
		tv.z = z * dL;
	}
	else
	{
		tv.x = 0;
		tv.y = 0;
		tv.z = 0;
	}
	return tv;
}
CVec3 CVec3::MA(double scale, const CVec3& v1)
{// a bs func made by id?
	CVec3 tv;
	tv.x = x + scale * v1.x;
	tv.y = y + scale * v1.y;
	tv.z = z + scale * v1.z;
	return tv;
}
CVec3 CVec3::CrossProduct(const CVec3& v1)
{// returns cross product against this, but doen't alter data this instance
	CVec3 tv;

	tv.x = y * v1.z - z * v1.y;
	tv.y = z * v1.x - x * v1.z;
	tv.z = x * v1.y - y * v1.x;

	return tv;
}
double CVec3::Length()
{// return length of it
	return sqrt((x*x) + (y*y) + (z*z));
}
CVec3 CVec3::operator-()
{// return a vector of the opposite direction
	CVec3 tv;
	tv.x = -x;
	tv.y = -y;
	tv.z = -z;
	return tv;
}
CVec3 CVec3::operator-(const CVec3& v1)
{
	CVec3 tv;
	tv.x = x - v1.x;
	tv.y = y - v1.y;
	tv.z = z - v1.z;
	return tv;
}

CVec3 CVec3::operator* (double scale)
{// scale it by value of scalar
	CVec3 tv;
	tv.x = x * scale;
	tv.y = y * scale;
	tv.z = z * scale;
	return tv;
}
double CVec3::operator* (const CVec3& v1)
{// Dot Product 
	return ((x * v1.x) + (y * v1.y) + (z * v1.z));
}
CVec3& CVec3::operator+=(const CVec3& v1)
{
	x = x + v1.x;
	y = y + v1.y;
	z = z + v1.z;
	return *this;
}
CVec3& CVec3::operator-=(const CVec3& v1)
{
	x = x - v1.x;
	y = y - v1.y;
	z = z - v1.z;
	return *this;
}

bool CVec3::operator==(const CVec3& v1)
{// compare
	if(x==v1.x && y==v1.y && z==v1.z) return true;
	return false;
}
bool CVec3::operator!=(const CVec3& v1)
{// contrast
	if(x!=v1.x || y!=v1.y || z!=v1.z) return true;
	return false;
}
// CONSTRUCTORS
CVec3::CVec3()
{// default - set everything to zero
	x=y=z=0;
	m_dv3[0] = m_dv3[1] = m_dv3[2] = 0;
	m_fv3[0] = m_fv3[1] = m_fv3[2] = 0;
}
CVec3::CVec3(const CVec3& v1)
{// copy constructor
	x = v1.x;
	y = v1.y;
	z = v1.z;
}
CVec3::CVec3(double dx, double dy, double dz)
{// member by memeber
	x = dx;
	y = dy;
	z = dz;
}

#endif // PTH_CVEC3_CPP