#ifndef PTH_PLUGGIN_MAINDLL_CPP
#define PTH_PLUGGIN_MAINDLL_CPP

/*
=======================================
Load Plugs - PeteDog

For now, load an explicit dll name. But then loop through spawns
looking for a classname of "".  "" indicates a place where we can
fill in a new spawn.
=======================================
*/

#include "string.h"
#include "plugin.h"
#include "../objects/CSpawn.h"

//CSpawn* spawns;


HINSTANCE PlugArray[MAX_PLUGS]={0};
int PlugCount =0;


void LoadPlugs(void)
{
	/*
	STEP 1:
		Find the full path and file name of the current gamedll,
		get its full dir only, not including the file name;
	*/
	HMODULE hmGameDll = GetModuleHandle( "gamex86.dll" ); 

	DWORD dwFileNameLength; // Length of bytes returned

	// MAX_PATH is not a constant we define
	char szGameDllFileName [MAX_PATH]; // Buffer to hold filename returned by GetModuleFileName
	char szGameDllPath     [MAX_PATH]; // Buffer to hold the path only


	dwFileNameLength = GetModuleFileName( hmGameDll, szGameDllFileName, (DWORD)MAX_PATH );

	if(dwFileNameLength) // did we get a string back? ie. file name not NULL
	{
		strcpy( szGameDllPath, szGameDllFileName ); // copy to path string
		// now just set szGameDllPath to the path
		for (int i=((int)(dwFileNameLength)+1) ; i>0 ; i--)
		{
			if (szGameDllPath[i] == '\\')
			{
				szGameDllPath[i+1] = NULL; // Keep the path slash and add a zero after
				break;
			}
			else if (szGameDllPath[i] == '/')
			{
				szGameDllPath[i+1] =NULL; // Keep the path slash and add a zero after
				break;
			}
		}
		gi.dprintf("\n==== GameDll Plugin Loader Started ====\n\n");
		gi.dprintf("GameDll FileName: \n    %s\n", szGameDllFileName);
		gi.dprintf("GameDll Path:     \n    %s\n", szGameDllPath);
	}

	/*
	STEP 2:
		Find all the files in the dir with the dll extension.
		check for the dll having an InitPlugin func
		Build a list of all dlls that have an InitPlugin func
	*/

	char sztmpFileName [MAX_PATH] = {0}; // temp var to hold the path + "*.dll"
	strcpy(sztmpFileName,szGameDllPath);
	strcat(sztmpFileName,"*.dll");
	
	gi.dprintf("==== Searching for plugin dlls ====");
	gi.dprintf("Search string:\n    %s\n\n", sztmpFileName);

	WIN32_FIND_DATA wfdSearchResults;

	HANDLE hDllFile = FindFirstFile(sztmpFileName,&wfdSearchResults);

	if (hDllFile != INVALID_HANDLE_VALUE )
	{
		int nNoMoreDlls;
		
		char sztmpName [MAX_PATH];

		do 
		{
			gi.dprintf("    Found: %s\n", wfdSearchResults.cFileName);

			strcpy(sztmpName,szGameDllPath);
			strcat(sztmpName,wfdSearchResults.cFileName);

			gi.dprintf ("    Loading: %s\n",sztmpName);

			PlugArray[PlugCount] = 0;
			PlugArray[PlugCount] = LoadLibrary(	sztmpName );
			
			if( PlugArray[PlugCount] )
			{
				gi.dprintf ("    Loaded: %s\n", sztmpName );
				GETNUMSPAWNS ProcAddr = (GETNUMSPAWNS)GetProcAddress(PlugArray[PlugCount],"GetNumSpawns");
				int NumSpawns =0;
				if (ProcAddr) NumSpawns = (*ProcAddr)();

				if (NumSpawns)
				{
					CSpawn* NewSpawns = 0;
					GETSPAWNARRAY ProcAddr2 = (GETSPAWNARRAY)GetProcAddress(PlugArray[PlugCount],"GetSpawnArray");
					if(ProcAddr2) NewSpawns = (*ProcAddr2)();

					if(NewSpawns)
					{
						gi.dprintf ("    - Valid Plugin Found.\n");

						
						//int y = 0; // don't go all the way through list again

						for (int x = 0 ; x<NumSpawns ; x++)
						{
							// loop through game spawns looking for empty array element
							
							spawns.AddSpawn(&NewSpawns[x]);

							// found a free spot for new spawns
							gi.dprintf ("Spawn for: %s\n",NewSpawns[x].name);
		
						}//for NumSpawn loop
						PlugCount++;
					}// if NeWSpawns
				}
				else //if NumSpawns
				{
					gi.dprintf ("    - No Valid Plugin Found.\n");
					FreeLibrary(PlugArray[PlugCount]);
				}
			} 
			else // PlugArray[PlugCount] = handle to dll, a dll that didn't load = 0
			{
				gi.dprintf ("    - Dll couldn't be loaded.\n");
			}

			// we found a dll so continue searching
			nNoMoreDlls = FindNextFile(hDllFile,&wfdSearchResults);
		}
		while (nNoMoreDlls != NULL );

		nNoMoreDlls = FindClose(hDllFile);
	}	// original find loop

	gi.dprintf ("Valid Plugins: %i\n\n",PlugCount);
}

////////////////////////////
// RELEASEPLUGINS //////////
////////////////////////////

void ReleasePlugins(void)
{
	gi.dprintf ("===Releasing Plugins===\n");
	for(int i = 0 ; i<MAX_PLUGS;i++) 
	{
		if(PlugArray[i]) FreeLibrary(PlugArray[i]);
	}
	PlugCount=0;
}


#endif // PTH_PLUGGIN_MAINDLL_CPP