// Filename         : .\objects\CSpawn.h
// Author           : NA
// Author Email     : NA
// Description      : NA
// Required Headers : NA

// ZeroDiVide - Encapsulate the header
#ifndef _objects_cspawn_h_
#define _objects_cspawn_h_

#include <string.h>

// ZeroDiVide - reformated
class CSpawn
{
public:

	char	*name;
	void	(*spawn)(CEdict *ent);
///////////////
	CSpawn(){name=0;spawn=0;}
	CSpawn(char* name,void (*SpawnFunc)(CEdict* ent) )
	{SetElement(name,SpawnFunc);}
	~CSpawn()
	{
		if(name) delete [] name;
	}
	void SetElement(char* NewName, void (*SpawnFunc)(CEdict* ent) )
	{
		if( name) delete [] name;
		name = new char[ strlen(NewName)+1];
		strcpy(name,NewName);
		spawn = SpawnFunc;
	}
};

class CSpawnList
{
	// minimal list type class to hold our
	// pseudo dynamic array of pluggin spawns
private:
	enum {MAX_SPAWNS = 30};
	enum {NO_FREE_SPAWNS = -1};
	CSpawn** m_Spawns;

	int FindEmptySpawn()
	{
		for (int i = 0 ; i < MAX_SPAWNS-1 ; i ++)
		{ if(m_Spawns[i] == 0) return i; }
		return NO_FREE_SPAWNS;
	}
public:
	void AddSpawn(CSpawn* NewSpawn)
	{
		int n = FindEmptySpawn();
		if(n!= NO_FREE_SPAWNS)
		{
			m_Spawns[n] = NewSpawn;
		}
	}
	CSpawn* FindSpawn(char* SpawnName)
	{
		for (int i = 0 ; i < MAX_SPAWNS ; i ++)
		{ 
			if(m_Spawns[i])
				if(!(strcmp(m_Spawns[i]->name, SpawnName))) return m_Spawns[i]; 
		}
		return 0;
	}
	CSpawnList()
	{
		m_Spawns =0;
		m_Spawns = new CSpawn*[MAX_SPAWNS];
		for (int i =0 ; i < MAX_SPAWNS ; i ++) m_Spawns[i] =0;
	}
	~CSpawnList()
	{
		if(m_Spawns) delete [] m_Spawns;
	}
};


extern CSpawnList spawns;

#endif
