// Filename         : .\objects\CPlayerState.h
// Author           : NA
// Author Email     : NA
// Description      : NA
// Required Headers : NA

// ZeroDiVide - Encapsulate the header
#ifndef _objects_cplayerstate_h_
#define _objects_cplayerstate_h_


// player_state->stats[] indexes
#define STAT_HEALTH_ICON		0
#define	STAT_HEALTH				1
#define	STAT_AMMO_ICON			2
#define	STAT_AMMO				3
#define	STAT_ARMOR_ICON			4
#define	STAT_ARMOR				5
#define	STAT_SELECTED_ICON		6
#define	STAT_PICKUP_ICON		7
#define	STAT_PICKUP_STRING		8
#define	STAT_TIMER_ICON			9
#define	STAT_TIMER				10
#define	STAT_HELPICON			11
#define	STAT_SELECTED_ITEM		12
#define	STAT_LAYOUTS			13
#define	STAT_FRAGS				14
#define	STAT_FLASHES			15		// cleared each frame, 1 = health, 2 = armor

#define	MAX_STATS				32


// player_state_t is the information needed in addition to pmove_state_t
// to rendered a view.  There will only be 10 player_state_t sent each second,
// but the number of pmove_state_t changes will be reletive to client
// frame rates

class CPlayerState
{

	public:

		CPerdictionMoveState	pmove;			// for prediction
		// these fields do not need to be communicated bit-precise
		vec3_t					viewangles;		// for fixed views
		vec3_t					viewoffset;		// add to pmovestate->origin
		vec3_t					kick_angles;	// add to view direction to get render angles
												// set by weapon kicks, pain effects, etc
		vec3_t					gunangles;
		vec3_t					gunoffset;
		int						gunindex;
		int						gunframe;
		float					blend[4];		// rgba full screen effect
		float					fov;			// horizontal field of view
		int						rdflags;		// refdef flags
		short					stats[MAX_STATS];	// fast status bar updates

	private:

		// NONE
};

#endif
