// Filename         : .\objects\CGameExport.h
// Author           : NA
// Author Email     : NA
// Description      : NA
// Required Headers : NA

// ZeroDiVide - Encapsulate the header
#ifndef _objects_cgameexport_h_
#define _objects_cgameexport_h_

class CGameExport
{
	public:

		int		apiversion;
		// the init function will only be called when a game starts,
		// not each time a level is loaded.  Persistant data for clients
		// and the server can be allocated in init
		void		(*Init) (void);
		void		(*Shutdown) (void);
		// each new level entered will cause a call to SpawnEntities
		void		(*SpawnEntities) (char *mapname, char *entstring, char *spawnpoint);
		// Read/Write Game is for storing persistant cross level information
		// about the world state and the clients.
		// WriteGame is called every time a level is exited.
		// ReadGame is called on a loadgame.
		void		(*WriteGame) (char *filename, qboolean autosave);
		void		(*ReadGame) (char *filename);
		// ReadLevel is called after the default map information has been
		// loaded with SpawnEntities
		void		(*WriteLevel) (char *filename);
		void		(*ReadLevel) (char *filename);
		qboolean	(*ClientConnect) (CEdict *ent, char *userinfo);
		void		(*ClientBegin) (CEdict *ent);
		void		(*ClientUserinfoChanged) (CEdict *ent, char *userinfo);
		void		(*ClientDisconnect) (CEdict *ent);
		void		(*ClientCommand) (CEdict *ent);
		void		(*ClientThink) (CEdict *ent, CUserCommand *cmd);
		void		(*RunFrame) (void);
		// ServerCommand will be called when an "sv <command>" command is issued on the
		// server console.
		// The game can issue gi.argc() / gi.argv() commands to get the rest
		// of the parameters
		void		(*ServerCommand) (void);
		//
		// global variables shared between game and server
		//
		// The edict array is allocated in the game dll so it
		// can vary in size from one game to another.
		// 
		// The size will be fixed when ge->Init() is called
		CEdict		*edicts;
		int			edict_size;
		int			num_edicts;		// current number, <= max_edicts
		int			max_edicts;

	private:

		// NONE
};

#endif
