// Filename         : .\objects\CGameClient.h
// Author           : NA
// Author Email     : NA
// Description      : NA
// Required Headers : NA

// ZeroDiVide - Encapsulate the header
#ifndef _objects_cgameclient_h_
#define _objects_cgameclient_h_

#include "CGameClientPersistant.h"
#include "CGameClientRespawn.h"
#include "CPerdictionMoveState.h"
#include "CGameItem.h"
#include "CPlayerState.h"

// Only used by CGameClient --- ????
typedef enum 
{
	WEAPON_READY, 
	WEAPON_ACTIVATING,
	WEAPON_DROPPING,
	WEAPON_FIRING
} weaponstate_t;

// this structure is cleared on each PutClientInServer(),
// except for 'client->pers'
class CGameClient
{

	public:

		// known to server
		CPlayerState			ps;		// communicated by server to clients
		int						ping;
		// private to game
		CGameClientPersistant	pers;
		CGameClientRespawn		resp;
		CPerdictionMoveState	old_pmove;	// for detecting out-of-pmove changes
		qboolean				showscores;	// set layout stat
		qboolean				showinventory;	// set layout stat
		qboolean				showhelp;
		qboolean				showhelpicon;
		int						ammo_index;
		int						buttons;
		int						oldbuttons;
		int						latched_buttons;
		qboolean				weapon_thunk;
		CGameItem				*newweapon;
		// sum up damage over an entire frame, so
		// shotgun blasts give a single big kick
		int						damage_armor;		// damage absorbed by armor
		int						damage_parmor;		// damage absorbed by power armor
		int						damage_blood;		// damage taken out of health
		int						damage_knockback;	// impact damage
		vec3_t					damage_from;		// origin for vector calculation
		float					killer_yaw;		// when dead, look at killer
		weaponstate_t			weaponstate;
		vec3_t					kick_angles;		// weapon kicks
		vec3_t					kick_origin;
		float					v_dmg_roll, v_dmg_pitch, v_dmg_time;	// damage kicks
		float					fall_time, fall_value;	// for view drop on fall
		float					damage_alpha;
		float					bonus_alpha;
		vec3_t					damage_blend;
		vec3_t					v_angle;		// aiming direction
		float					bobtime;		// so off-ground doesn't change it
		vec3_t					oldviewangles;
		vec3_t					oldvelocity;
		float					next_drown_time;
		int						old_waterlevel;
		int						breather_sound;
		int						machinegun_shots;	// for weapon raising
		// animation vars
		int						anim_end;
		int						anim_priority;
		qboolean				anim_duck;
		qboolean				anim_run;
		// powerup timers
		float					quad_framenum;
		float					invincible_framenum;
		float					breather_framenum;
		float					enviro_framenum;
		qboolean				grenade_blew_up;
		float					grenade_time;
		int						silencer_shots;
		int						weapon_sound;
		float					pickup_msg_time;
		float					respawn_time;		// can respawn when time > this

	private:

		// NONE
};

#endif
