// Filename         : .\objects\CConsoleVariable.h
// Author           : NA
// Author Email     : NA
// Description      : NA
// Required Headers : NA

// ZeroDiVide - Encapsulate the header
#ifndef _objects_cconsolevariable_h_
#define _objects_cconsolevariable_h_

/*
==========================================================

CVARS (console variables)

==========================================================
*/

#ifndef CVAR
#define	CVAR

#define	CVAR_ARCHIVE		1	// set to cause it to be saved to vars.rc
#define	CVAR_USERINFO		2	// added to userinfo  when changed
#define	CVAR_SERVERINFO		4	// added to serverinfo when changed
#define	CVAR_NOSET		8	// don't allow change from console at all,
					// but can be set from the command line
#define	CVAR_LATCH		16	// save changes until server restart

// nothing outside the Cvar_*() functions should modify these fields!
class CConsoleVariable
{
	public:

		char			*name;
		char			*string;
		char			*latched_string;	// for CVAR_LATCH vars
		int			flags;
		qboolean		modified;		// set each time the cvar is changed
		float			value;
		CConsoleVariable  	*next;

	private:

		// NONE
};

#endif		// CVAR

#endif
