// Filename         : .\local.h
// Author           : NA
// Author Email     : NA
// Description      : NA
// Required Headers : NA

// ZeroDiVide - Encapsulate the header
#ifndef _local_h_
#define _local_h_

// g_local.h -- local definitions for game module

#include "shared.h"

// ZeroDiVIde - SOURCE NOTES - Rewrite this comment to explain the changes
// define GAME_INCLUDE so that game.h does not define the
// short, server-visible CGameClient and CEdict structures,
// because we define the full size ones in this file
#define	GAME_INCLUDE
#include "game.h"

// the "gameversion" client command will print this plus compile date
#define	GAMEVERSION	"baseq2"

// protocol bytes that can be directly added to messages
#define	svc_muzzleflash		1
#define	svc_muzzleflash2	2
#define	svc_temp_entity		3
#define	svc_layout			4
#define	svc_inventory		5

//==================================================================

// view pitching times
#define DAMAGE_TIME		0.5
#define	FALL_TIME		0.3


// edict->spawnflags
// these are set with checkboxes on each entity in the map editor
#define	SPAWNFLAG_NOT_EASY			0x00000100
#define	SPAWNFLAG_NOT_MEDIUM		0x00000200
#define	SPAWNFLAG_NOT_HARD			0x00000400
#define	SPAWNFLAG_NOT_DEATHMATCH	0x00000800
#define	SPAWNFLAG_NOT_COOP			0x00001000

// edict->flags
#define	FL_FLY					0x00000001
#define	FL_SWIM					0x00000002	// implied immunity to drowining
#define FL_IMMUNE_LASER			0x00000004
#define	FL_INWATER				0x00000008
#define	FL_GODMODE				0x00000010
#define	FL_NOTARGET				0x00000020
#define FL_IMMUNE_SLIME			0x00000040
#define FL_IMMUNE_LAVA			0x00000080
#define	FL_PARTIALGROUND		0x00000100	// not all corners are valid
#define	FL_WATERJUMP			0x00000200	// player jumping out of water
#define	FL_TEAMSLAVE			0x00000400	// not the first on the team
#define FL_NO_KNOCKBACK			0x00000800
#define FL_POWER_ARMOR			0x00001000	// power armor (if any) is active
#define FL_RESPAWN				0x80000000	// used for item respawning


#define	FRAMETIME		0.1

// memory tags to allow dynamic memory to be cleaned up
#define	TAG_GAME	765		// clear when unloading the dll
#define	TAG_LEVEL	766		// clear when loading a new level


#define MELEE_DISTANCE	80

#define BODY_QUEUE_SIZE		8

typedef enum
{
	DAMAGE_NO,
	DAMAGE_YES,			// will take damage if hit
	DAMAGE_AIM			// auto targeting recognizes this
} damage_t;


typedef enum
{
	AMMO_BULLETS,
	AMMO_SHELLS,
	AMMO_ROCKETS,
	AMMO_GRENADES,
	AMMO_CELLS,
	AMMO_SLUGS
} ammo_t;


//deadflag
#define DEAD_NO					0
#define DEAD_DYING				1
#define DEAD_DEAD				2
#define DEAD_RESPAWNABLE		3

//range
#define RANGE_MELEE				0
#define RANGE_NEAR				1
#define RANGE_MID				2
#define RANGE_FAR				3

//gib types
#define GIB_ORGANIC				0
#define GIB_METALLIC			1

//monster ai flags
#define AI_STAND_GROUND			0x00000001
#define AI_TEMP_STAND_GROUND	0x00000002
#define AI_SOUND_TARGET			0x00000004
#define AI_LOST_SIGHT			0x00000008
#define AI_PURSUIT_LAST_SEEN	0x00000010
#define AI_PURSUE_NEXT			0x00000020
#define AI_PURSUE_TEMP			0x00000040
#define AI_HOLD_FRAME			0x00000080
#define AI_GOOD_GUY				0x00000100
#define AI_BRUTAL				0x00000200
#define AI_NOSTEP				0x00000400
#define AI_DUCKED				0x00000800
#define AI_COMBAT_POINT			0x00001000
#define AI_MEDIC				0x00002000
#define AI_RESURRECTING			0x00004000

//monster attack state
#define AS_STRAIGHT				1
#define AS_SLIDING				2
#define	AS_MELEE				3
#define	AS_MISSILE				4

// armor types
#define ARMOR_NONE				0
#define ARMOR_JACKET			1
#define ARMOR_COMBAT			2
#define ARMOR_BODY				3
#define ARMOR_SHARD				4

// power armor types
#define POWER_ARMOR_NONE		0
#define POWER_ARMOR_SCREEN		1
#define POWER_ARMOR_SHIELD		2

// handedness values
#define RIGHT_HANDED			0
#define LEFT_HANDED				1
#define CENTER_HANDED			2


// game.serverflags values
#define SFL_CROSS_TRIGGER_1		0x00000001
#define SFL_CROSS_TRIGGER_2		0x00000002
#define SFL_CROSS_TRIGGER_3		0x00000004
#define SFL_CROSS_TRIGGER_4		0x00000008
#define SFL_CROSS_TRIGGER_5		0x00000010
#define SFL_CROSS_TRIGGER_6		0x00000020
#define SFL_CROSS_TRIGGER_7		0x00000040
#define SFL_CROSS_TRIGGER_8		0x00000080
#define SFL_CROSS_TRIGGER_MASK	0x000000ff


// noise types for PlayerNoise
#define PNOISE_SELF				0
#define PNOISE_WEAPON			1
#define PNOISE_IMPACT			2


// edict->movetype values
typedef enum
{
MOVETYPE_NONE,			// never moves
MOVETYPE_NOCLIP,		// origin and angles change with no interaction
MOVETYPE_PUSH,			// no clip to world, push on box contact
MOVETYPE_STOP,			// no clip to world, stops on box contact

MOVETYPE_WALK,			// gravity
MOVETYPE_STEP,			// gravity, special edge handling
MOVETYPE_FLY,
MOVETYPE_TOSS,			// gravity
MOVETYPE_FLYMISSILE,	// extra size to monsters
MOVETYPE_BOUNCE
} movetype_t;

// CGameItem->flags
#define	IT_WEAPON		1		// use makes active weapon
#define	IT_AMMO			2
#define IT_ARMOR		4
#define IT_STAY_COOP	8
#define IT_KEY			16
#define IT_POWERUP		32

#include "objects/CGameItemArmor.h"
#include "objects/CGameItem.h"
#include "objects/CGameLocals.h"
#include "objects/CLevelLocals.h"
#include "objects/CSpawnTemp.h"
#include "objects/CMoveInfo.h"
#include "objects/CMonsterFrame.h"
#include "objects/CMonsterMove.h"
#include "objects/CMonsterInfo.h"


extern	CGameLocals		game;
extern	CLevelLocals	level;
extern	CGameImport		gi;
extern	CGameExport		globals;
extern	CSpawnTemp		st;

extern	int	sm_meat_index;
extern	int	snd_fry;

extern	int	jacket_armor_index;
extern	int	combat_armor_index;
extern	int	body_armor_index;


// means of death
#define MOD_UNKNOWN			0
#define MOD_BLASTER			1
#define MOD_SHOTGUN			2
#define MOD_SSHOTGUN		3
#define MOD_MACHINEGUN		4
#define MOD_CHAINGUN		5
#define MOD_GRENADE			6
#define MOD_G_SPLASH		7
#define MOD_ROCKET			8
#define MOD_R_SPLASH		9
#define MOD_HYPERBLASTER	10
#define MOD_RAILGUN			11
#define MOD_BFG_LASER		12
#define MOD_BFG_BLAST		13
#define MOD_BFG_EFFECT		14
#define MOD_HANDGRENADE		15
#define MOD_HG_SPLASH		16
#define MOD_WATER			17
#define MOD_SLIME			18
#define MOD_LAVA			19
#define MOD_CRUSH			20
#define MOD_TELEFRAG		21
#define MOD_FALLING			22
#define MOD_SUICIDE			23
#define MOD_HELD_GRENADE	24
#define MOD_EXPLOSIVE		25
#define MOD_BARREL			26
#define MOD_BOMB			27
#define MOD_EXIT			28
#define MOD_SPLASH			29
#define MOD_TARGET_LASER	30
#define MOD_TRIGGER_HURT	31
#define MOD_HIT				32
#define MOD_TARGET_BLASTER	33
#define MOD_FRIENDLY_FIRE	0x8000000

extern	int	meansOfDeath;


extern	CEdict			*g_edicts;

#define	FOFS(x) (int)&(((CEdict *)0)->x)
#define	STOFS(x) (int)&(((CSpawnTemp *)0)->x)
#define	LLOFS(x) (int)&(((CLevelLocals *)0)->x)
#define	CLOFS(x) (int)&(((CGameClient *)0)->x)

#define random()	((rand () & 0x7fff) / ((float)0x7fff))
#define crandom()	(2.0 * (random() - 0.5))

extern	CConsoleVariable	*maxentities;
extern	CConsoleVariable	*deathmatch;
extern	CConsoleVariable	*coop;
extern	CConsoleVariable	*dmflags;
extern	CConsoleVariable	*skill;
extern	CConsoleVariable	*fraglimit;
extern	CConsoleVariable	*timelimit;
extern	CConsoleVariable	*password;
extern	CConsoleVariable	*g_select_empty;
extern	CConsoleVariable	*dedicated;

extern	CConsoleVariable	*sv_gravity;
extern	CConsoleVariable	*sv_maxvelocity;

extern	CConsoleVariable	*gun_x, *gun_y, *gun_z;
extern	CConsoleVariable	*sv_rollspeed;
extern	CConsoleVariable	*sv_rollangle;

extern	CConsoleVariable	*run_pitch;
extern	CConsoleVariable	*run_roll;
extern	CConsoleVariable	*bob_up;
extern	CConsoleVariable	*bob_pitch;
extern	CConsoleVariable	*bob_roll;

extern	CConsoleVariable	*sv_cheats;
extern	CConsoleVariable	*maxclients;


#define world	(&g_edicts[0])

// item spawnflags
#define ITEM_TRIGGER_SPAWN		0x00000001
#define ITEM_NO_TOUCH			0x00000002
// 6 bits reserved for editor flags
// 8 bits used as power cube id bits for coop games
#define DROPPED_ITEM			0x00010000
#define	DROPPED_PLAYER_ITEM		0x00020000
#define ITEM_TARGETS_USED		0x00040000

//
// fields are needed for spawning from the entity string
// and saving / loading games
//
#define FFL_SPAWNTEMP		1

typedef enum {
	F_INT, 
	F_FLOAT,
	F_LSTRING,			// string on disk, pointer in memory, TAG_LEVEL
	F_GSTRING,			// string on disk, pointer in memory, TAG_GAME
	F_VECTOR,
	F_ANGLEHACK,
	F_EDICT,			// index on disk, pointer in memory
	F_ITEM,				// index on disk, pointer in memory
	F_CLIENT,			// index on disk, pointer in memory
	F_IGNORE
} fieldtype_t;

#include "objects/CField.h"

extern	CField fields[];
extern	CGameItem	itemlist[];


//
// g_cmds.c
//
void Cmd_Help_f (CEdict *ent);
void Cmd_Score_f (CEdict *ent);

//
// g_items.c
//
void PrecacheItem (CGameItem *it);
void InitItems (void);
void SetItemNames (void);
CGameItem	*FindItem (char *pickup_name);
CGameItem	*FindItemByClassname (char *classname);
#define	ITEM_INDEX(x) ((x)-itemlist)
CEdict *Drop_Item (CEdict *ent, CGameItem *item);
void SetRespawn (CEdict *ent, float delay);
void ChangeWeapon (CEdict *ent);
void SpawnItem (CEdict *ent, CGameItem *item);
void Think_Weapon (CEdict *ent);
int ArmorIndex (CEdict *ent);
int PowerArmorType (CEdict *ent);
CGameItem	*GetItemByIndex (int index);
qboolean Add_Ammo (CEdict *ent, CGameItem *item, int count);
void Touch_Item (CEdict *ent, CEdict *other, CPlane *plane, CSurface *surf);

//
// g_utils.c
//
qboolean	KillBox (CEdict *ent);
void	G_ProjectSource (vec3_t point, vec3_t distance, vec3_t forward, vec3_t right, vec3_t result);
CEdict *G_Find (CEdict *from, int fieldofs, char *match);
CEdict *findradius (CEdict *from, vec3_t org, float rad);
CEdict *G_PickTarget (char *targetname);
void	G_UseTargets (CEdict *ent, CEdict *activator);
void	G_SetMovedir (vec3_t angles, vec3_t movedir);

void	G_InitEdict (CEdict *e);
CEdict	*G_Spawn (void);
void	G_FreeEdict (CEdict *e);

void	G_TouchTriggers (CEdict *ent);
void	G_TouchSolids (CEdict *ent);

char	*G_CopyString (char *in);

float	*tv (float x, float y, float z);
char	*vtos (vec3_t v);

float vectoyaw (vec3_t vec);
void vectoangles (vec3_t vec, vec3_t angles);

//
// g_combat.c
//
qboolean OnSameTeam (CEdict *ent1, CEdict *ent2);
qboolean CanDamage (CEdict *targ, CEdict *inflictor);
void T_Damage (CEdict *targ, CEdict *inflictor, CEdict *attacker, vec3_t dir, vec3_t point, vec3_t normal, int damage, int knockback, int dflags, int mod);
void T_RadiusDamage (CEdict *inflictor, CEdict *attacker, float damage, CEdict *ignore, float radius, int mod);

// damage flags
#define DAMAGE_RADIUS			0x00000001	// damage was indirect
#define DAMAGE_NO_ARMOR			0x00000002	// armour does not protect from this damage
#define DAMAGE_ENERGY			0x00000004	// damage is from an energy based weapon
#define DAMAGE_NO_KNOCKBACK		0x00000008	// do not affect velocity, just view angles
#define DAMAGE_BULLET			0x00000010  // damage is from a bullet (used for ricochets)
#define DAMAGE_NO_PROTECTION	0x00000020  // armor, shields, invulnerability, and godmode have no effect

#define DEFAULT_BULLET_HSPREAD	300
#define DEFAULT_BULLET_VSPREAD	500
#define DEFAULT_SHOTGUN_HSPREAD	1000
#define DEFAULT_SHOTGUN_VSPREAD	500
#define DEFAULT_DEATHMATCH_SHOTGUN_COUNT	12
#define DEFAULT_SHOTGUN_COUNT	12
#define DEFAULT_SSHOTGUN_COUNT	20

//
// g_monster.c
//
void monster_fire_bullet (CEdict *self, vec3_t start, vec3_t dir, int damage, int kick, int hspread, int vspread, int flashtype);
void monster_fire_shotgun (CEdict *self, vec3_t start, vec3_t aimdir, int damage, int kick, int hspread, int vspread, int count, int flashtype);
void monster_fire_blaster (CEdict *self, vec3_t start, vec3_t dir, int damage, int speed, int flashtype, int effect);
void monster_fire_grenade (CEdict *self, vec3_t start, vec3_t aimdir, int damage, int speed, int flashtype);
void monster_fire_rocket (CEdict *self, vec3_t start, vec3_t dir, int damage, int speed, int flashtype);
void monster_fire_railgun (CEdict *self, vec3_t start, vec3_t aimdir, int damage, int kick, int flashtype);
void monster_fire_bfg (CEdict *self, vec3_t start, vec3_t aimdir, int damage, int speed, int kick, float damage_radius, int flashtype);
void M_droptofloor (CEdict *ent);
void monster_think (CEdict *self);
void walkmonster_start (CEdict *self);
void swimmonster_start (CEdict *self);
void flymonster_start (CEdict *self);
void AttackFinished (CEdict *self, float time);
void monster_death_use (CEdict *self);
void M_CatagorizePosition (CEdict *ent);
qboolean M_CheckAttack (CEdict *self);
void M_FlyCheck (CEdict *self);
void M_CheckGround (CEdict *ent);

//
// g_misc.c
//
void ThrowHead (CEdict *self, char *gibname, int damage, int type);
void ThrowClientHead (CEdict *self, int damage);
void ThrowGib (CEdict *self, char *gibname, int damage, int type);
void BecomeExplosion1(CEdict *self);

//
// g_ai.c
//
void AI_SetSightClient (void);

void ai_stand (CEdict *self, float dist);
void ai_move (CEdict *self, float dist);
void ai_walk (CEdict *self, float dist);
void ai_turn (CEdict *self, float dist);
void ai_run (CEdict *self, float dist);
void ai_charge (CEdict *self, float dist);
int range (CEdict *self, CEdict *other);

void FoundTarget (CEdict *self);
qboolean infront (CEdict *self, CEdict *other);
qboolean visible (CEdict *self, CEdict *other);
qboolean FacingIdeal(CEdict *self);

//
// g_weapon.c
//
void ThrowDebris (CEdict *self, char *modelname, float speed, vec3_t origin);
qboolean fire_hit (CEdict *self, vec3_t aim, int damage, int kick);
void fire_bullet (CEdict *self, vec3_t start, vec3_t aimdir, int damage, int kick, int hspread, int vspread, int mod);
void fire_shotgun (CEdict *self, vec3_t start, vec3_t aimdir, int damage, int kick, int hspread, int vspread, int count, int mod);
void fire_blaster (CEdict *self, vec3_t start, vec3_t aimdir, int damage, int speed, int effect, qboolean ahyper);
void fire_grenade (CEdict *self, vec3_t start, vec3_t aimdir, int damage, int speed, float timer, float damage_radius);
void fire_grenade2 (CEdict *self, vec3_t start, vec3_t aimdir, int damage, int speed, float timer, float damage_radius, qboolean held);
void fire_rocket (CEdict *self, vec3_t start, vec3_t dir, int damage, int speed, float damage_radius, int radius_damage);
void fire_rail (CEdict *self, vec3_t start, vec3_t aimdir, int damage, int kick);
void fire_bfg (CEdict *self, vec3_t start, vec3_t dir, int damage, int speed, float damage_radius);

//
// g_ptrail.c
//
void PlayerTrail_Init (void);
void PlayerTrail_Add (vec3_t spot);
void PlayerTrail_New (vec3_t spot);
CEdict *PlayerTrail_PickFirst (CEdict *self);
CEdict *PlayerTrail_PickNext (CEdict *self);
CEdict	*PlayerTrail_LastSpot (void);


//
// g_client.c
//
void respawn (CEdict *ent);
void BeginIntermission (CEdict *targ);
void PutClientInServer (CEdict *ent);
void InitClientPersistant (CGameClient *client);
void InitClientResp (CGameClient *client);
void InitBodyQue (void);
void ClientBeginServerFrame (CEdict *ent);

//
// g_player.c
//
void player_pain (CEdict *self, CEdict *other, float kick, int damage);
void player_die (CEdict *self, CEdict *inflictor, CEdict *attacker, int damage, vec3_t point);

//
// g_svcmds.c
//
void	ServerCommand (void);

//
// p_view.c
//
void ClientEndServerFrame (CEdict *ent);

//
// p_hud.c
//
void MoveClientToIntermission (CEdict *client);
void G_SetStats (CEdict *ent);
void ValidateSelectedItem (CEdict *ent);
void DeathmatchScoreboardMessage (CEdict *client, CEdict *killer);

//
// g_pweapon.c
//
void PlayerNoise(CEdict *who, vec3_t where, int type);

//
// m_move.c
//
qboolean M_CheckBottom (CEdict *ent);
qboolean M_walkmove (CEdict *ent, float yaw, float dist);
void M_MoveToGoal (CEdict *ent, float dist);
void M_ChangeYaw (CEdict *ent);

//
// g_phys.c
//
void G_RunEntity (CEdict *ent);

//
// g_main.c
//
void SaveClientData (void);
void FetchClientEntData (CEdict *ent);


//============================================================================

// client_t->anim_priority
#define	ANIM_BASIC		0		// stand / run
#define	ANIM_WAVE		1
#define	ANIM_JUMP		2
#define	ANIM_PAIN		3
#define	ANIM_ATTACK		4
#define	ANIM_DEATH		5

#include "objects/CGameClientPersistant.h"
#include "objects/CGameClientRespawn.h"
#include "objects/CGameClient.h"
#include "objects/CEdict.h"


// ZeroDiVide - End Encapuslation
#endif
// EOF
