// Filename         : .\objects\CPerdictionMoveState.h
// Author           : NA
// Author Email     : NA
// Description      : NA
// Required Headers : NA

// ZeroDiVide - Encapsulate the header
#ifndef _objects_cperdictionmovestate_h_
#define _objects_cperdictionmovestate_h_

// pmove_state_t is the information necessary for client side movement
// prediction
typedef enum 
{
	// can accelerate and turn
	PM_NORMAL,
	PM_SPECTATOR,
	// no acceleration or turning
	PM_DEAD,
	PM_GIB,		// different bounding box
	PM_FREEZE
} pmtype_t;

// pmove->pm_flags
#define	PMF_DUCKED			1
#define	PMF_JUMP_HELD		2
#define	PMF_ON_GROUND		4
#define	PMF_TIME_WATERJUMP	8	// pm_time is waterjump
#define	PMF_TIME_LAND		16	// pm_time is time before rejump
#define	PMF_TIME_TELEPORT	32	// pm_time is non-moving time
#define PMF_NO_PREDICTION	64	// temporarily disables prediction (used for grappling hook)

// this structure needs to be communicated bit-accurate
// from the server to the client to guarantee that
// prediction stays in sync, so no floats are used.
// if any part of the game code modifies this struct, it
// will result in a prediction error of some degree.
class CPerdictionMoveState
{

	public:

		pmtype_t	pm_type;
		short		origin[3];		// 12.3
		short		velocity[3];		// 12.3
		byte		pm_flags;		// ducked, jump_held, etc
		byte		pm_time;		// each unit = 8 ms
		short		gravity;
		short		delta_angles[3];	// add to command angles to get view direction
							// changed by spawns, rotating objects, and teleporters

	private:

		// NONE

};

#endif
