// Filename         : .\objects\CGameImport.h
// Author           : NA
// Author Email     : NA
// Description      : NA
// Required Headers : NA

// ZeroDiVide - Encapsulate the header
#ifndef _objects_cgameimport_h_
#define _objects_cgameimport_h_

//ZeroDiVide Changed struct declare to be c++
class CGameImport
{
	public:

		// special messages
		void		(*bprintf) (int printlevel, char *fmt, ...);
		void		(*dprintf) (char *fmt, ...);
		void		(*cprintf) (CEdict *ent, int printlevel, char *fmt, ...);
		void		(*centerprintf) (CEdict *ent, char *fmt, ...);
		void		(*sound) (CEdict *ent, int channel, int soundindex, float volume, float attenuation, float timeofs);
		void		(*positioned_sound) (vec3_t origin, CEdict *ent, int channel, int soundinedex, float volume, float attenuation, float timeofs);
		// config strings hold all the index strings, the lightstyles,
		// and misc data like the sky definition and cdtrack.
		// All of the current configstrings are sent to clients when
		// they connect, and changes are sent to all connected clients.
		void		(*configstring) (int num, char *string);
		void		(*error) (char *fmt, ...);
		// the *index functions create configstrings and some internal server state
		int			(*modelindex) (char *name);
		int			(*soundindex) (char *name);
		int			(*imageindex) (char *name);
		void		(*setmodel) (CEdict *ent, char *name);
		// collision detection
		CTrace		(*trace) (vec3_t start, vec3_t mins, vec3_t maxs, vec3_t end, CEdict *passent, int contentmask);
		int			(*pointcontents) (vec3_t point);
		qboolean	(*inPVS) (vec3_t p1, vec3_t p2);
		qboolean	(*inPHS) (vec3_t p1, vec3_t p2);
		void		(*SetAreaPortalState) (int portalnum, qboolean open);
		qboolean	(*AreasConnected) (int area1, int area2);
		// an entity will never be sent to a client or used for collision
		// if it is not passed to linkentity.  If the size, position, or
		// solidity changes, it must be relinked.
		void		(*linkentity) (CEdict *ent);
		void		(*unlinkentity) (CEdict *ent);		// call before removing an interactive edict
		int			(*BoxEdicts) (vec3_t mins, vec3_t maxs, CEdict **list,	int maxcount, int areatype);
		void		(*Pmove) (CPerdictionMove *pmove);		// player movement code common with client prediction
		// network messaging
		void		(*multicast) (vec3_t origin, multicast_t to);
		void		(*unicast) (CEdict *ent, qboolean reliable);
		void		(*WriteChar) (int c);
		void		(*WriteByte) (int c);
		void		(*WriteShort) (int c);
		void		(*WriteLong) (int c);
		void		(*WriteFloat) (float f);
		void		(*WriteString) (char *s);
		void		(*WritePosition) (vec3_t pos);	// some fractional bits
		void		(*WriteDir) (vec3_t pos);		// single byte encoded, very coarse
		void		(*WriteAngle) (float f);
		// managed memory allocation
		void		*(*TagMalloc) (int size, int tag);
		void		(*TagFree) (void *block);
		void		(*FreeTags) (int tag);
		// console variable interaction
		CConsoleVariable	*(*cvar) (char *var_name, char *value, int flags);
		CConsoleVariable	*(*cvar_set) (char *var_name, char *value);
		CConsoleVariable	*(*cvar_forceset) (char *var_name, char *value);
		// ClientCommand and ServerCommand parameter access
		int			(*argc) (void);
		char		*(*argv) (int n);
		char		*(*args) (void);	// concatenation of all argv >= 1
		// add commands to the server console as if they were typed in
		// for map changing, etc
		void		(*AddCommandString) (char *text);
		void		(*DebugGraph) (float value, int color);

	private:

		// NONE
};

#endif
