// Filename         : .\objects\CEdict.h
// Author           : NA
// Author Email     : NA
// Description      : NA
// Required Headers : NA

// ZeroDiVide - Encapsulate the header

#ifndef _objects_cedict_h_
#define _objects_cedict_h_

#define	MAX_ENT_CLUSTERS	16


#include "CEntityState.h"
#include "CGameClient.h"
#include "CLink.h"
#include "CMoveInfo.h"
#include "CMonsterInfo.h"
#include "CPlane.h"
#include "CSurface.h"

// edict->solid values

typedef enum
{
SOLID_NOT,			// no interaction with other objects
SOLID_TRIGGER,		// only touch when inside, after moving
SOLID_BBOX,			// touch on edge
SOLID_BSP			// bsp clip, touch on edge
} solid_t;

class CEdict
{

	public:

	CEntityState	s;
	CGameClient		*client;		// NULL if not a player
									// the server expects the first part
									// of CGameClient to be a player_state_t
									// but the rest of it is opaque

	qboolean	inuse;
	int			linkcount;

	// FIXME: move these fields to a server private sv_entity_t
	CLink		area;				// linked to a division node or leaf
	
	int			num_clusters;		// if -1, use headnode instead
	int			clusternums[MAX_ENT_CLUSTERS];
	int			headnode;			// unused if num_clusters != -1
	int			areanum, areanum2;

	//================================

	int			svflags;
	vec3_t		mins, maxs;
	vec3_t		absmin, absmax, size;
	solid_t		solid;
	int			clipmask;
	CEdict		*owner;


	// DO NOT MODIFY ANYTHING ABOVE THIS, THE SERVER
	// EXPECTS THE FIELDS IN THAT ORDER!

	//================================
	int			movetype;
	int			flags;

	char		*model;
	float		freetime;			// sv.time when the object was freed
	
	//
	// only used locally in game, not by server
	//
	char		*message;
	char		*classname;
	int			spawnflags;

	float		timestamp;

	float		angle;			// set in qe3, -1 = up, -2 = down
	char		*target;
	char		*targetname;
	char		*killtarget;
	char		*team;
	char		*pathtarget;
	char		*deathtarget;
	char		*combattarget;
	CEdict		*target_ent;

	float		speed, accel, decel;
	vec3_t		movedir;
	vec3_t		pos1, pos2;

	vec3_t		velocity;
	vec3_t		avelocity;
	int			mass;
	float		air_finished;
	float		gravity;		// per entity gravity multiplier (1.0 is normal)
								// use for lowgrav artifact, flares

	CEdict		*goalentity;
	CEdict		*movetarget;
	float		yaw_speed;
	float		ideal_yaw;

	float		nextthink;
	void		(*prethink) (CEdict *ent);
	void		(*think)(CEdict *self);
	void		(*blocked)(CEdict *self, CEdict *other);	//move to moveinfo?
	void		(*touch)(CEdict *self, CEdict *other, CPlane *plane, CSurface *surf);
	void		(*use)(CEdict *self, CEdict *other, CEdict *activator);
	void		(*pain)(CEdict *self, CEdict *other, float kick, int damage);
	void		(*die)(CEdict *self, CEdict *inflictor, CEdict *attacker, int damage, vec3_t point);

	float		touch_debounce_time;		// are all these legit?  do we need more/less of them?
	float		pain_debounce_time;
	float		damage_debounce_time;
	float		fly_sound_debounce_time;	//move to clientinfo
	float		last_move_time;

	int			health;
	int			max_health;
	int			gib_health;
	int			deadflag;
	qboolean	show_hostile;

	float		powerarmor_time;

	char		*map;			// target_changelevel

	int			viewheight;		// height above origin where eyesight is determined
	int			takedamage;
	int			dmg;
	int			radius_dmg;
	float		dmg_radius;
	int			sounds;			//make this a spawntemp var?
	int			count;

	CEdict		*chain;
	CEdict		*enemy;
	CEdict		*oldenemy;
	CEdict		*activator;
	CEdict		*groundentity;
	int			groundentity_linkcount;
	CEdict		*teamchain;
	CEdict		*teammaster;

	CEdict		*mynoise;		// can go in client only
	CEdict		*mynoise2;

	int			noise_index;
	int			noise_index2;
	float		volume;
	float		attenuation;

	// timing variables
	float		wait;
	float		delay;			// before firing targets
	float		random;

	float		teleport_time;

	int			watertype;
	int			waterlevel;

	vec3_t		move_origin;
	vec3_t		move_angles;

	// move this to clientinfo?
	int			light_level;

	int			style;			// also used as areaportal number

	CGameItem		*item;			// for bonus items

	// common data blocks
	CMoveInfo		moveinfo;
	CMonsterInfo	monsterinfo;
};

#endif
