/*
 * Copyright (c) 1999 Thomas Grey All Rights Reserved.
 *
 * Thomas Grey grants you ("Licensee") a non-exclusive, royalty
 * free, license to use, modify and redistribute this software in
 * source and binary code form, provided that the following conditions 
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * This software is provided "AS IS," without a warranty of any
 * kind. ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND
 * WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY
 * EXCLUDED.  THOMAS GREY AND HIS LICENSORS SHALL NOT BE LIABLE
 * FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
 * MODIFYING OR DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO
 * EVENT WILL THOMAS GREY OR HIS LICENSORS BE LIABLE FOR ANY
 * LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT, INDIRECT, SPECIAL,
 * CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER CAUSED AND
 * REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF OR
 * INABILITY TO USE SOFTWARE, EVEN IF THOMAS GREY HAS BEEN
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 *
 * This software is not designed or intended for use in on-line
 * control of aircraft, air traffic, aircraft navigation or aircraft
 * communications; or in the design, construction, operation or
 * maintenance of any nuclear facility. Licensee represents and
 * warrants that it will not use or redistribute the Software for such
 * purposes.  
 */

/* This code only works partially at the moment- more recent releases of info may help elucidate the spec for h2 models*/

/*Add code to disgard an object listed as an extra param- replace existing hasrd coded values.
*/

import java.net.URL;
import java.net.MalformedURLException;
import java.io.InputStream;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipEntry;

public final class MDLheretic2Model extends MDLModel{

    private int version = 1;
    private int lumpVersion = -1;
    private int lumpLength = -1;
    private boolean loadskin = false;
    private int actual_num_skins = 0;
//Skin    
/**The number of MIPS maps in the m8 file.**/
    protected static int MIPLEVELS =16;
/**The version of the m8 file. Expected to be 2.**/
    protected static int MIP_VERSION = 2;
/**The number of colours in the palette.**/
    protected static int PAL_SIZE = 256;
    private java.awt.image.IndexColorModel pal;
//mesh    
    private int filepos = 0;
    private int skinw;
    private int skinh;
    private int frameSizeBytes;
    private int num_skins;
    private int num_vertices;
    private int num_st_vertices;
    private int num_triangles;
    private MDLTrisList frame_tris[];
    private int max_num_tris;
//    private int num_gl_cmds;
    private int num_frames;
 //   private int totalFrames;
    private float radius;
    
//    private MDLSkinVertex[] sVerts;
    private short[] sVertsS;
    private short[] sVertsT;
    private short[][] tris;
    private short[][] stTris;
    private byte[][] skin;
    
    private MDLSimpleFrame[] frames;
 //   private byte[][] cSkin;
/*
    public String weaponName;
    public int weaponSkinw;
    public int weaponSkinh;
    public int weaponFrameSizeBytes;
    public int weaponNum_skins;
    public int weaponNum_vertices;
    public int weaponNum_st_vertices;
    public int weaponNum_triangles;
    public int weaponNum_gl_cmds;
    public int weaponNum_frames;
    public int weaponTotalFrames;
    
    public short[] weaponSVertsS;
    public short[] weaponSVertsT;
    public short[][] weaponTris;
    public short[][] weaponStTris;
    public MDLSimpleFrame[] weaponFrames;
    public byte[][] weaponSkin;
 */   
    private int currentFrame = 0;
    private int currentSkin = 0;
  //  private boolean haveWeapon = false;
   // private boolean loadWeapon = false;
    private int max_vertices;
   // private int max_triangles;
    //private int max_skinh;
    private int shift;
    
    private int percentageDone;
    private int percentagePerFile = 1;
    
    private int[] loadframes;
    private boolean haveWepSkin = false;
    private int loadingSkin;
    private int skinsSeen;
    private int[] loadskins;
    
    private boolean specialWepSkin = false;
	    
	public int getVersion(){
	    return version;
	}
	
	public short getTriangleVertexIndex(int triangle, int vertex){
//	    if (!haveWeapon){
		return tris[triangle][vertex];
//	    }else{
//		if (triangle < num_triangles){
//		    return tris[triangle][vertex];
//		}else{
//		    i = triangle - num_triangles;
//		    if (currentFrame < weaponNum_frames){
//			return weaponTris[i][vertex];
//		    }else{
//			return tris[0][vertex];
//		    }
//		}
//	    }
	}
	
	public short getSkinVertexT(int triangle, int vertexIndex){
		return sVertsT[(stTris[triangle][vertexIndex])];
	}
	
	public short getSkinVertexS(int triangle, int vertexIndex){
		return sVertsS[(stTris[triangle][vertexIndex])];
	}
    	
	public void setCurrentSkinIndex(int skin){
	    currentSkin = skin;
	}
	
	public int getCurrentSkinIndex(){
	    return currentSkin;
	}
		
	public int getCurrentFrameIndex(){
	    return currentFrame;
	}
	
	public void setCurrentFrameIndex(int fi){
	    currentFrame = fi;
	}
	
	public int getNumberOfAnimationFrames(int start, int finish){
		return 1;//(finish-start+1);
	}
	
	public int getFrameDelayMillis(){
	    return 100;
	}	    
		
	public void nextSkin(){
/*	    currentSkin++;
	    currentSkin %= num_skins;
	    cSkin = skins[currentSkin];*/
	}
	
	public void lastSkin(){
	/*    currentSkin--;
	    if (currentSkin <0){
		currentSkin = num_skins -1;
	    }
	    cSkin = skins[currentSkin]; */
	}
	
	public void lastFrame(){
	    currentFrame--;
	    if (currentFrame <0){
		currentFrame = num_frames -1;
	    }
	    
	}

	public void nextFrame(){
	    currentFrame++;
	    currentFrame %= num_frames;
    
	}
	
	public byte getTexel(short x, short y){
	    if (actual_num_skins > 0){
		return skin[x][y];
	    }else{
		return (byte)0;
	    }
//	    }else if (y > -1 && y < skinh){
//		return cSkin[x][y];
//	    }else{
//		i = y - skinh;
//		if(!specialWepSkin){
//		    return weaponSkin[x][i];
//		}else{
//		    return cSkin[x][i];
//		}
//	    }
	}
	
	public int getTotalFrames(){
	    return 1;//totalFrames;
	}
	
	public int getTotalSkins(){
	    return num_skins;
	}
		
	public String getFrameName(){
	    return frames[currentFrame].name;
	}
	
	public float getBoundingRadius(){
	    return radius;
	}
	
	public int getNumberOfSkins(){
	    return actual_num_skins;
	}
	
	public int getSkinWidth(){
	    return 1;//skinw;
	}
	
	public int getSkinHeight(){
	    return 1;//skinh;
	}
	

	public float getVertexX(int vertex){
//	    if (!haveWeapon){
		    return frames[currentFrame].frameVertsX[vertex];
/*	    }else{
		if (vertex < num_vertices){
		    return frames[currentFrame].frameVertsX[vertex];
		}else{
		    i = vertex - num_vertices;
		    if (currentFrame < weaponNum_frames){
			return weaponFrames[currentFrame].frameVertsX[i];
		    }else{
			return frames[currentFrame].frameVertsX[0];
		    }
		}
	    }*/
	}
	
	public float getVertexY(int vertex){
//	    if (!haveWeapon){
		    return frames[currentFrame].frameVertsY[vertex];
	/*    }else{
		if (vertex < num_vertices){
		    return frames[currentFrame].frameVertsY[vertex];
		}else{
		    i = vertex - num_vertices;
		    if (currentFrame < weaponNum_frames){
			return weaponFrames[currentFrame].frameVertsY[i];
		    }else{
			return frames[currentFrame].frameVertsY[0];
		    }
		}
	    }*/
	}
	
	public float getVertexZ(int vertex){
//	    if (!haveWeapon){
		    return frames[currentFrame].frameVertsZ[vertex];
	/*    }else{
		if (vertex < num_vertices){
		    return frames[currentFrame].frameVertsZ[vertex];
		}else{
		    i = vertex - num_vertices;
		    if (currentFrame < weaponNum_frames){
			return weaponFrames[currentFrame].frameVertsZ[i];
		    }else{
			return frames[currentFrame].frameVertsZ[0];
		    }
		}
	    }*/
	}
	
	public boolean getClockwiseCull(){
	    return true;
	}
	
	public int getNumberOfVertices(){
//	    if (haveWeapon){
//		return max_vertices;
//	    }else{
		return num_vertices;
//	    }
	}
	
	public int getNumberOfTriangles(){
//	    if (haveWeapon){
//		return max_triangles;
//	    }else{
		return num_triangles;
//	    }
	}
	
	public int getNumberOfFrames(){
	    return num_frames;
	}
	
	public String getModelFormat(){
	    return "hrertic2";
	}

	public String getAuthorInfo(){
	    return "Copyright T.J.Grey 1999";
	}
	
	public String getAuthorName(){
	    return "Tom Grey";
	}
	
//	private void loadExtraInfo(){
//	    loadskin=false;
//	    String[] eInfo = getExtraInfo();
//	    if (eInfo[0].startsWith("l")){
//		loadskin = true;
//	    }
//	    return;    	    
//	}

	
	protected void readModelThread(int[] loadf, int[] loads, int shifty){
	    
	    showStatus("MDLheretic2Model: Heretic2 model format class copyright T.J.Grey 1999");
//	    loadExtraInfo();
	    radius = 0;
	    String modelName = getParameter("MODEL");
	    String modelNameLC = modelName.toLowerCase();
	    if (modelName.startsWith("!*!")){
		modelName = modelName.substring(3);
		//readInfoModel(modelName, false);
	    }else if (modelNameLC.endsWith(".zip")){
		readSingleZip(modelName);
	    }else{
		error("Unknown model specifier- should be either .zip or .txt");
	    }
    // Calculate the bounding radius
	    calculateRadius();
    // Ensure get 100% at end!
	    showPercentage(100);
	    System.gc();
	    System.gc();

	}
/*
	private void readInfoModel(String modelFilename, boolean fromFile){
	    showStatus("MDLquake2Model: Preparing to read model info file");
	    int totalEntries = 100;
	    int[] numentries = null;
	    int numfiles = 1;
	    String[] files = null;
	    int fnumber =0;
    //!fromFile- ie MODEL param list
		totalEntries = 0;
		java.util.StringTokenizer st = new java.util.StringTokenizer(modelFilename,";");
		String temp = st.nextToken();
		numfiles = (Integer.decode(temp)).intValue();
		files = new String[numfiles];
		numentries = new int[numfiles];
		fnumber = 0;
		while(fnumber < numfiles){
		    files[fnumber] = st.nextToken();
		    temp = st.nextToken();
		    numentries[fnumber] = (Integer.decode(temp)).intValue();
		    totalEntries += numentries[fnumber];
		    fnumber++;
		}
	    percentagePerFile = (int)(100/totalEntries);
	    int pcFromEntries = 0;
// read the files in
	    boolean haveTris = false;
//Loop over files
	    try{
		for (int f = 0; f < numfiles; f++){
		    String token = files[f];
		    showStatus("MDLquake2Model: Opening connection for "+token);
		    BufferedInputStream bis = null;
		    try{
			bis = new BufferedInputStream(getStreamForFile(token));
		    }catch(MalformedURLException e){
			error("Got MalformedURLException : "+e+" try checking MODELPATH");
		    }
		    int entriesSeen = 0;
		    ZipInputStream zipModelStream = new ZipInputStream(bis);
		    ZipEntry cfile = zipModelStream.getNextEntry();
		    String cname = cfile.getName();
		    cname = cname.toLowerCase();
		    showStatus("MDLquake2Model: Current file is "+cname);
		    if (cfile == null){
			error("Error, zipfile "+token+" is empty or corrupt!");
		    }
    // check if tris.md2.. if so then read, if not have we seen it?
		    if (cname.endsWith(".md2") && !haveTris){// && !cname.startsWith("w_") && !cname.startsWith("weapon")){
			md2Method(zipModelStream, shift);
			haveTris = true;
			pcFromEntries = percentagePerFile;
			percentageDone = pcFromEntries;
			showPercentage(percentageDone);
			entriesSeen++;
			if (entriesSeen < numentries[f]){
			    cfile = zipModelStream.getNextEntry();
			}
//			skins = new byte[num_skins][skinw][skinh];
		    }
		    if (!haveTris){
			error("Sorry but tris.md2 must be the first file in the first archive in the info file");
		    }
    // Loop over entries
		    while(entriesSeen < numentries[f]){
			readEntry(cfile, zipModelStream);
			entriesSeen++;
			pcFromEntries += percentagePerFile;
			percentageDone = pcFromEntries;
			showPercentage(percentageDone);
			if (entriesSeen < numentries[f]){
			    cfile = zipModelStream.getNextEntry();
			}
		    }
		    showStatus("MDLquake2Model: Closing connection");
		    zipModelStream.close();
		    bis.close();
		}
	    }catch (IOException e){
		error("Got IOException: "+e);
	    }
	    
	}
*/	    
	private void readSingleZip(String modelFilename){
//	    int pcFromEntries = 0;
	    try{
		showStatus("MDLquakeModel: Opening connection for zipped 3ds model..");
		ZipEntry cfile; //current zip entry
		String cname = null; //name of current zip entry file
		ZipInputStream zipModelStream = new ZipInputStream(new BufferedInputStream(getStreamForFile(modelFilename)) );
		cfile = zipModelStream.getNextEntry();
		if (cfile == null){
		    error("Error, zipfile is empty or corrupt!");
		}
		cname = cfile.getName();
		cname = cname.toLowerCase();
		showStatus("MDLquake2Model: Current file is "+cname);
		    actual_num_skins = 0;
		if (cname.endsWith(".fm")){
		    readfm(zipModelStream, shift);
		}else if (cname.endsWith(".m8")){
		    readSkin(zipModelStream);
		    actual_num_skins = 1;
		}else{
		    error("Unknown file type: "+cname);
		}
		cfile = zipModelStream.getNextEntry();
		if (cfile != null){
		    cname = cfile.getName();
		    cname = cname.toLowerCase();
		    if (cname.endsWith(".fm")){
			readfm(zipModelStream, shift);
		    }else if (cname.endsWith(".m8")){
			readSkin(zipModelStream);
			actual_num_skins = 1;
		    }else{
			error("Unknown file type: "+cname);
		    }
		}
		calculateRadius();
	//Since we now have this
//	        skins = new byte[num_skins][skinw][skinh];//MDLSkinGroup[num_skins];
	//	pcFromEntries += percentagePerFile;
	//	percentageDone = pcFromEntries;
	//	showPercentage(percentageDone);
	//	cfile = zipModelStream.getNextEntry();
	//	boolean keepReading = true;
	//	if (cfile == null){
	//	    keepReading = false;
	//	}
    // Read the other gubbings
	//	while(keepReading){
	//	    if (readEntry(cfile, zipModelStream)){
	//		pcFromEntries += percentagePerFile;
	//		percentageDone = pcFromEntries;
	//		showPercentage(percentageDone);
	//	    }
	//	    cfile = zipModelStream.getNextEntry();
	    // Only read on if this was not last entry and don't have all the bits!
		//    keepReading = ( (cfile!=null));// && !( haveWeapon&&haveWepSkin ) );
		//}
		showStatus("MDLquake2Model: Reading model... done... Closing data stream");
		zipModelStream.closeEntry();
		zipModelStream.close();
		showStatus("MDLquake2Model: Data stream closed ok");
		zipModelStream = null;
	    }catch(IOException e){
		error("Error opening data Stream for model- <"+e+">");
	    }
	    return;
	}
/*	
	private boolean readEntry(ZipEntry cfile, InputStream zipModelStream) throws IOException{
	    String cname = cfile.getName();
	    cname = cname.toLowerCase();
	    cname = cfile.getName();
	    cname = cname.toLowerCase();
	    showStatus("MDLquake2Model: Current file is "+cname);
	    if (cname.endsWith(".md2")){
//		if(loadWeapon && !haveWeapon){
		  //  weaponName = cname.substring(0,cname.lastIndexOf("."));
		   // showStatus("MDLquake2Model: Reading weapon md2 file "+weaponName);
		    //md2Method(zipModelStream,loadframes, shift, true);
//		    haveWeapon = true;
//		    return true;
	//	}else{
	//	    showStatus("MDLquake2Model: Skipping weapon "+cname);
	//	    return false;
	//	}
	    }else if (cname.endsWith("_i.pcx")){
		showStatus("MDLquake2Model: Skipping icon pcx");
		System.out.println("MDLquake2Model: Skipping icon pcx");
		return false;
	    }else if (cname.endsWith(".pcx")){
//	System.out.println("!!!!!!!"+cname+weaponName);
//		if (cname.startsWith("weapon") || cname.startsWith("w_")){
	//	    if (!specialWepSkin && haveWeapon && cname.equals(weaponName+".pcx")){// || cname.startsWith("w_") ){
//			loadPCX(zipModelStream,loadingSkin, true);
	//		haveWepSkin = true;
	//		return true;
	//	    }else{
	//		return false;
	//	    }
	//	}
	    }else{
		System.out.println("MDLquake2Model: Unknown file type: "+cname+"; skipping");
		    return false;
	    }
	    return true;
    }
	*/	
	private void calculateRadius(){
	    radius = (float) Math.sqrt(radius);
	    radius *= 2;
	    showStatus("MDLquake2Model: Radius calculated as "+radius);
	}

	private void readfm(InputStream zipModelStream, int shift) throws IOException{
	    boolean done = false;
	    String lumpName = readLump(zipModelStream);
	    while(!done){
    //
		showStatus("Lump name: "+lumpName);
		if (lumpName.equals("!EOF!")){
		    showStatus("EOF!!!");
		    return;
		}else if (lumpName.equals("header")){
		    System.out.println("Header found");
		    skinw = readInt(zipModelStream);
		    System.out.println("skinw: "+skinw);
		    skinh = readInt(zipModelStream);
		    System.out.println("skinh: "+skinh);
		    frameSizeBytes = readInt(zipModelStream);
		    System.out.println("framesizebytes: "+frameSizeBytes);
		    num_skins = readInt(zipModelStream);
		    System.out.println("num_skins: "+num_skins);
		    num_vertices = readInt(zipModelStream);
		    System.out.println("num_vertices: "+num_vertices);
		    num_st_vertices = readInt(zipModelStream);
		    System.out.println("num_st_verticies: "+num_st_vertices);
		    num_triangles = readInt(zipModelStream);
		    System.out.println("num_triangles: "+num_triangles);
		    System.out.println("8: "+readInt(zipModelStream));
		    num_frames = readInt(zipModelStream);
		    System.out.println("num_frames: "+num_frames);
		    System.out.println("9: "+readInt(zipModelStream));
		    filepos += lumpLength;
		}else if(lumpName.equals("skin")){
		    showStatus("Skin names");
		    readSkinNames(zipModelStream);
		}else if(lumpName.equals("st coord")){
		    showStatus("stVerts found");
		    read_st_verts(zipModelStream);
		}else if(lumpName.equals("tris")){
		    showStatus("tris found");
		    read_tris(zipModelStream);
		}else if(lumpName.equals("frames")){
		    showStatus("frames found");
		    readFrames(zipModelStream);
		}else if(lumpName.equals("glcmds")){
		    showStatus("glcmds found");
		    dodgySkip(lumpLength,zipModelStream);
		}else if(lumpName.equals("mesh nodes")){
		    showStatus("mesh nodes found");
		    dodgySkip(lumpLength,zipModelStream);
		}else{
		    showStatus("UNKNOWN LUMP!!");
		    dodgySkip(lumpLength,zipModelStream);
		}
		lumpName = readLump(zipModelStream);
	    }
	}

/** Actually reads and stores the relavant image and header data.
*   @param skinStream An input stream from which reading should proceed.
**/
    protected void readSkin(java.io.InputStream skinStream) throws java.io.IOException{
	showStatus("M8View: Reading header");
    //Version
	int m8Version = readInt(skinStream);
//	debug("version: "+m8Version);
//Name	
	byte[] thirtyTwoBytes = new byte[32];
	int length = 32;
	for (int j=0; j<32; j++){
	    thirtyTwoBytes[j]=(byte)skinStream.read();       // magic nums
	    if (thirtyTwoBytes[j] == 0 && j < length){
		length = j;
	    }
	}
//	m8Name=new String(thirtyTwoBytes,0,length);
//	if (length == 0){
//	    m8Name= "!UNNAMED!";
//	}
//	debug("Skin name: "+m8Name);
//Widths and Heights	
	int[] m8Width = new int[MIPLEVELS];
	int[] m8Height = new int[MIPLEVELS];
	for (int i = 0; i< MIPLEVELS; i++){
	    m8Width[i] = readInt(skinStream);
	    m8Height[i] = readInt(skinStream);
//	    debug(" Level "+i+" w= "+m8Width[i]+" h= "+m8Height[i]);
	    if (m8Width[i] > 50000 || m8Height[i] > 50000 || m8Width[i] < 0 || m8Height[i] < 0){
		error("M8View: Aborting, width or height > 50000 or negative");
	    }
	}
//Offsets
	int[] m8Offsets = new int[MIPLEVELS];
	for (int i = 0; i< MIPLEVELS; i++){
	    m8Offsets[i] = readInt(skinStream);
//	    debug(" Level "+i+" Offset= "+m8Offsets[i]);
	    if (m8Offsets[i] > 10000000 || m8Offsets[i] <0){
		error("M8View: Aborting, offset > 10000000 or negative");
	    }
	}	
// Skip animation names	
	for(int i = 0; i<32; i++){
	    skinStream.read();
	}
// Palette
	showStatus("M8View: Reading palette");
	byte[] r = new byte[PAL_SIZE];
	byte[] g = new byte[PAL_SIZE];
	byte[] b = new byte[PAL_SIZE];
	for (int i=0; i< PAL_SIZE; i++){
//	    showStatus("M8View: Reading palette colour "+i);
	    r[i] = (byte) skinStream.read();
	    g[i] = (byte) skinStream.read();
	    b[i] = (byte) skinStream.read();
	}
	pal = new java.awt.image.IndexColorModel(8,PAL_SIZE,r,g,b);
//flags + contents +value
	for (int i= 0; i<12;i++){
	    skinStream.read();
	}
//Now skip to first offset
	showStatus("M8View: Advancing to first image");
//	debug("M8View: Advancing to first image");
	int skip = m8Offsets[0] - (80 + 12*MIPLEVELS+3*PAL_SIZE);
//	debug("Skipping "+skip+" to first image");
	if (skip < 0){
	    error("M8View: Invalid first offset");
	}
	for (int i=0; i<skip; i++){
    //We skip with read() which is bad form but skip() seems ill behaved
	    skinStream.read();
	}
	skin = new byte[m8Width[0]][m8Height[0]];
	for (int y=0; y<m8Height[0];y++){
	    for (int x=0; x<m8Width[0];x++){
		skin[x][y] = (byte)skinStream.read();   
	    }
	}
	showStatus("M8View: Skin read");

    }
    
// Returns name but puts length and version in the lumpLength and lumpVersion class variables
	private String readLump(InputStream modelStream) throws IOException{
	    byte[] chars = new byte[32];
	    int bRead =0;
	    int slength = 0;
	    for (int c=0; c<32; c++){
		bRead = modelStream.read();
		if (bRead == -1){
		    showStatus("End-of-file found");
		    return "!EOF!";
		}
		chars[c] = (byte)bRead;
		if (chars[c] != 0){slength++;}
	    }
	    String lname = new String(chars,0,slength);
	    lumpVersion = readInt(modelStream);
	    lumpLength = readInt(modelStream);
	    return lname;
	}
	
	private void skipTill(int position, InputStream dataStream) throws IOException{
	    int i = position - filepos;
	    if (i < 0){
		error("Unable to skip- file has advanced beyond requested position");
	    }
	    if (i == 0){
		return;
	    }
	    while (filepos < position){
		dataStream.read();
		filepos++;
		yield();
	    }
	}
// DANGER: ignores filepos.. do not use unless advancing filepos elsewhere	
	private void dodgySkip(int nb, InputStream dataStream) throws IOException{
	    while (nb > 0){
		dataStream.read();
		nb--;
	    }
	}
	
	private void readSkinNames(InputStream modelStream) throws IOException{
	    byte[] chars = new byte[64];
	    int slength = 0;
	    for (int n=0; n<num_skins;n++){
		slength = 0;
		for (int c=0; c<64; c++){
		    chars[c] = (byte)modelStream.read();
		    if (chars[c] != 0){slength++;}
		}
		String lname = new String(chars,0,slength);
		showStatus("Skin name: "+lname);
	    }
	}
	
	private void read_st_verts(InputStream modelStream) throws IOException{
	    sVertsS = new short[num_st_vertices];
	    sVertsT = new short[num_st_vertices];
	    for (int v=0; v<num_st_vertices; v++){
		sVertsS[v] = readShort(modelStream);
		sVertsT[v] =  readShort(modelStream);
//		showStatus("U,V: "+tempu+", "+tempv);
	    }
	}
	
	private void read_tris(InputStream modelStream) throws IOException{
	    tris = new short[num_triangles][3];
	    stTris = new short[num_triangles][3];
	    for (int t=0; t<num_triangles; t++){
		tris[t][0] = readShort(modelStream);
		tris[t][1] = readShort(modelStream);
		tris[t][2] = readShort(modelStream);
		stTris[t][0] = readShort(modelStream);
		stTris[t][1] = readShort(modelStream);
		stTris[t][2] = readShort(modelStream);
//		System.out.println("("+tempa+", "+tempb+", "+tempc+") ("+tempat+", "+tempbt+", "+tempct+")");
	    }
	}
		    
	private void readFrames(InputStream modelStream) throws IOException{
	    int loadingFrame = 0;
	    frames = new MDLSimpleFrame[num_frames];
	    while(loadingFrame < num_frames){
		float temp = 0;
		int skippy = frameSizeBytes-(40+(4*num_vertices));
		frames[loadingFrame] = new MDLSimpleFrame(num_vertices);
		float xscale = 1;
		float yscale = 1;
		float zscale = 1;
		float xtrans = 0;
		float ytrans = 0;
		float ztrans = 0;
		xscale = readFloat(modelStream);
		yscale = readFloat(modelStream);
		zscale = readFloat(modelStream);
		xtrans = readFloat(modelStream);
		ytrans = readFloat(modelStream);
		ztrans = readFloat(modelStream);
		byte[] sixteenBytes = new byte[16];
		int length = 16;
		for (int k = 0; k < 16; k++){
		    sixteenBytes[k] = (byte) modelStream.read();
		    if (sixteenBytes[k] == 0 && k < length){
			length = k;
		    }
		}
		frames[loadingFrame].name = new String(sixteenBytes,0,length);
		showStatus("MDLquake2Model: Frame name is "+frames[loadingFrame].name);
		for (int j = 0; j < num_vertices; j++){
		    frames[loadingFrame].frameVertsX[j] = modelStream.read();
		    frames[loadingFrame].frameVertsY[j] = modelStream.read();
		    frames[loadingFrame].frameVertsZ[j] = modelStream.read();
// Bin the light normal
		    modelStream.read();
// Scale and translate
		    frames[loadingFrame].frameVertsX[j] = frames[loadingFrame].frameVertsX[j] * xscale + xtrans;		    
		    frames[loadingFrame].frameVertsY[j] = frames[loadingFrame].frameVertsY[j] * yscale + ytrans;
		    frames[loadingFrame].frameVertsZ[j] = frames[loadingFrame].frameVertsZ[j] * zscale + ztrans;		    
		    frames[loadingFrame].frameVertsZ[j] += shift;
		    temp = (frames[loadingFrame].frameVertsX[j]*frames[loadingFrame].frameVertsX[j]);
		    temp += (frames[loadingFrame].frameVertsY[j]*frames[loadingFrame].frameVertsY[j]);
		    temp += (frames[loadingFrame].frameVertsZ[j]*frames[loadingFrame].frameVertsZ[j]);
		    radius = Math.max(temp,radius);
		}
	//	dodgySkip(skippy, modelStream);
	//	filepos += frameSizeBytes;
		    loadingFrame++;
	// If we have loaded all the frames we need we can (touch wood) skive even looking at the rest
		//i++;
	    }
	}

	
	private final short readShort(InputStream dataStream) throws IOException{

	    byte[] twoBytes = new byte[2];
	    twoBytes[1]=(byte)dataStream.read();
	    twoBytes[0]=(byte)dataStream.read();
	    short returnShort = 0;
	    returnShort = (short)(returnShort | ( (twoBytes[0] & 255) << 8) );
	    returnShort = (short)(returnShort | (twoBytes[1] & 255) );
	    return returnShort;
	}
	
	public java.awt.image.IndexColorModel getInternalPalette(){
	    return pal;
	}
	
	private void error(String errorMsg){
	    showStatus("MDLquake2Model "+errorMsg);
	    System.out.println("MDLquake2Model "+errorMsg);
	    throw new RuntimeException("MDLquake2Model "+errorMsg);
	}

}