/*
 * Copyright (c) 1999 Thomas Grey All Rights Reserved.
 *
 * Thomas Grey grants you ("Licensee") a non-exclusive, royalty
 * free, license to use, modify and redistribute this software in
 * source and binary code form, provided that the following conditions 
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * This software is provided "AS IS," without a warranty of any
 * kind. ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND
 * WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY
 * EXCLUDED.  THOMAS GREY AND HIS LICENSORS SHALL NOT BE LIABLE
 * FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
 * MODIFYING OR DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO
 * EVENT WILL THOMAS GREY OR HIS LICENSORS BE LIABLE FOR ANY
 * LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT, INDIRECT, SPECIAL,
 * CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER CAUSED AND
 * REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF OR
 * INABILITY TO USE SOFTWARE, EVEN IF THOMAS GREY HAS BEEN
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 *
 * This software is not designed or intended for use in on-line
 * control of aircraft, air traffic, aircraft navigation or aircraft
 * communications; or in the design, construction, operation or
 * maintenance of any nuclear facility. Licensee represents and
 * warrants that it will not use or redistribute the Software for such
 * purposes.  
 */

import java.awt.Event;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.IndexColorModel;
import java.net.URL;
import java.net.MalformedURLException;
import java.io.InputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.awt.event.MouseEvent;
import java.util.StringTokenizer;
import java.awt.Frame;
import java.awt.MediaTracker;

// public class MDLView extends java.applet.Applet implements MouseMotionListener{
public class MDLViewMain{

	MDLView master;
	MDLViewCanvas mdlViewCanvas;
	MDLHelpWindow helpWindow;
//	MDLMonitorWindow monitorWindow;
	Frame skinWindow;
	URL codeBase;
	URL docBase;
	URL paletteURL;
	String palFileName;
//	URL modelURL;
	MDLModel myModel;
	static final int MDL_VER = 6;
	String modelFileName;
	int mouseX;
	int mouseY;
	boolean moveNotRotate;
	boolean tabReady = true;
	// Used to keep track of fast rendering on move
	boolean fastRendering = false;
	boolean suppressFastRender = false;
	boolean initialised = false;
	boolean rotating = false;
	boolean modelReady = false;
	int shiftY = 0;
	int i;
	String statusMessage;

	public MDLViewMain(MDLView m) {

		System.gc();
		master = m;
		if (master.Version%100>=10){
		    master.showStatus("MDLView v"+master.Version/100+"."+master.Version%100+" by T.J.Grey (tjg1@ch.ic.ac.uk)");
		}else{
		    master.showStatus("MDLView v"+master.Version/100+".0"+master.Version%100+" by T.J.Grey (tjg1@ch.ic.ac.uk)");
		}
		master.showStatus("MDLView: Initialising...");
		codeBase = master.getCodeBase();
		Dimension d = master.size();
		modelFileName = "newModelNotSet";

	}

	public void start() {

	//	System.out.println("Start called");
		System.gc();
		System.gc();
		System.gc();
// Are we starting for the first time?
		if (!initialised){
		    codeBase = master.getCodeBase();
		    docBase = master.getDocumentBase();
		    String formatName = master.getParameter("FORMAT");
		    String className = "MDL"+formatName+"Model";
		    if(formatName == null){
			className = "MDLquakeModel";
		    }
		    master.showStatus("MDLView: Finding model format class: "+className);
		    try{
			master.showStatus("MDLView: Instancing model as "+className);
			Class modelClass = Class.forName(className);
			master.showStatus("MDLView: Model class created");
			Object myModelInstance = modelClass.newInstance();
			master.showStatus("MDLView: Creating model class instance");
			myModel = (MDLModel) myModelInstance;
			master.showStatus("MDLView: Model class cast");
		    }catch (ClassNotFoundException e){
			error("No class (MDL"+formatName+"Model.class) can be found which matches the FORMAT you specifed");
		    }catch (InstantiationException e){
			error("Model class problem: Instancing exception: "+e);
		    }catch (IllegalAccessException e){
			error("Model class problem: IllegalAccessException exception: "+e);
		    }
		    myModel.setModelTracker(master);
		    String load = master.getParameter("LOADSKINS");
		    Dimension d = master.size();
		    master.showStatus("MDLView: Loading and initialising renderer");
		    mdlViewCanvas = new MDLViewCanvas(d, myModel, master.DEBUG);
		    master.showStatus("MDLView: Initialised, adding canvas to applet");
		    master.setLayout(new java.awt.BorderLayout());
		    master.add("Center",mdlViewCanvas);
	//Check for dreaded SHIFTY
		    String YShift = master.getParameter("SHIFTY");
//		    int shiftY;
		    if (YShift != null){
			try{
			    shiftY = (Integer.decode(YShift)).intValue();
			}catch(NumberFormatException e){
			    System.out.println("MDLView: Bad SHIFTY value: "+YShift);
			    shiftY = 0;
			}
		    }else{
			shiftY = 0;
		    }
// Zoom
		    String zoomStr = master.getParameter("ZOOM");
		    float zoom =(float) 0.;
		    if (zoomStr != null){
			try{
			    zoom = (Double.valueOf(zoomStr)).floatValue();
//		    System.out.println("Zoom is "+zoom);
			}catch(NumberFormatException e){
			    System.out.println("MDLView: Bad ZOOM value: "+zoomStr);
			}
			mdlViewCanvas.setZoom(zoom);
		    }
// 'Y' Rot
		    String YRot = master.getParameter("YANGLE");
		    int Yang;
		    if (YRot != null){
			try{
			    Yang = (Integer.decode(YRot)).intValue();
			}catch(NumberFormatException e){
			    System.out.println("MDLView: Bad YANGLE value: "+YRot);
			    Yang = 0;
			}
		    }else{
			Yang = 0;
		    }
		    mdlViewCanvas.setZAngle(Yang);
// 'X' Rot
		    String XRot = master.getParameter("XANGLE");
		    int Xang;
		    if (XRot != null){
			try{
			    Xang = (Integer.decode(XRot)).intValue();
			}catch(NumberFormatException e){
			    System.out.println("MDLView: Bad XANGLE value: "+XRot);
			    Xang = 0;
			}
		    }else{
			Xang = 0;
		    }
		    mdlViewCanvas.setYAngle(Xang);
// To rotate or not to rotate
		    String rot = master.getParameter("ROTATE");
		    if (rot != null){
			    rotating = interpretBoolean(rot);
			    mdlViewCanvas.setRotating(rotating);
		    }else{
			mdlViewCanvas.setRotating(false);
			rotating = false;
		    }
// To cycle or not to rotate
		    String cyc = master.getParameter("CYCLE");
		    if (cyc != null){
			    mdlViewCanvas.startAnimated(interpretBoolean(cyc));
		    }else{
			mdlViewCanvas.startAnimated(false);
		    }
    // Rendermode
		    String rMode = master.getParameter("RENDERMODE");
		    if (myModel.getModelError() ){
			mdlViewCanvas.setMode("error");
		    }else if (rMode != null){
			mdlViewCanvas.setMode(rMode);
		    }else{
			mdlViewCanvas.setMode("wireframe");	//Wireframe
		    }
		    mdlViewCanvas.setForegroundColour(master.getForeground());
		    mdlViewCanvas.setBackgroundColour(master.getBackground());
		    initialised = true;
		}
		    
// Read in the Model
		    String modelTemp = master.getParameter("MODEL");
	//System.out.println("Model is :"+modelFileName);
		    if (modelFileName != modelTemp){
			if (modelTemp == null){
			    error("MDLView: No model specified... please add to html... <PARAM NAME=MODEL VALUE=nameOfModelFile");
			}else{
				modelFileName = modelTemp;
			}
			modelReady = false;
		    }
		if (myModel.getModelReady()){
			mdlViewCanvas.modelReady();
			mdlViewCanvas.start();
		}else{
		    String loadskins = master.getParameter("LOADSKINS");
		    String loadframes = master.getParameter("LOADFRAMES");
		    master.removeAll();
//	    System.out.println("CONTAINS: "+master.countComponents());
		    getModel(modelFileName, loadframes, loadskins, shiftY);
		    mdlViewCanvas.setModel(myModel);
		}
		master.repaint();
	}
	

	public void stop() {

		myModel.stopCall();
		mdlViewCanvas.stop();

	}

	public void destroy() {

		myModel.stopCall();
		System.gc();

	}

	public void modelReady(){
	    modelReady = true;
	    IndexColorModel palette = null;
	    String load = master.getParameter("LOADSKINS");
	    String formatName = master.getParameter("FORMAT");
	    master.showStatus("MDLView: Model read");
	    String pFName = master.getParameter("PALETTE");
	    if (pFName == null){
		if (load == null || load.startsWith("0")){
		    pFName="!*!NULL!*!";
		}else{
		    if (formatName == null){
			pFName = "quake.pal";
		    }else{
			pFName = formatName+".pal";
		    }
		}
	    }
	    if (pFName.equals("INTERNAL")){
		master.showStatus("MDLView: Internal palette!");
		palette = myModel.getInternalPalette();
		if (palette == null){
		    error("Model won't give me the internal palette :( ");
		}
	    }else if (pFName.equals("!*!NULL!*!")){
		palette = null;
	    }else{
		if (pFName != palFileName){
		    if (load == null || load.startsWith("0")){
			palette = readPalette(master.getCodeBase(), pFName,false);
		    }else{
			palette = readPalette(master.getCodeBase(), pFName,true);		    
		    }
		    palFileName = pFName;
		}
	    }
//	     }   master.setLayout(new java.awt.BorderLayout());
	    master.add(mdlViewCanvas);//,"Center");
	    master.validate();
	    mdlViewCanvas.setPalette(palette);
	    if (master.haveBackgroundImage()){
		java.awt.Image bi = master.getBackgroundImage();
		boolean scale = master.scaleBackgroundImage();
		mdlViewCanvas.initialiseGraphics(bi,scale);
	    }else{
	    //Use null as no bImage and false as dummy value
		mdlViewCanvas.initialiseGraphics(null,false);
	    }
	    mdlViewCanvas.modelReady();
	    master.showStatus("MDLView: Starting renderer");
	    mdlViewCanvas.start();
	}
	
	
	public final String getAuthorInfo(){
	    return "T.J.Grey (tjg1@ch.ic.ac.uk) Copyright 1998";
	}
	

	private IndexColorModel readPalette(URL codebase, String palFileName, boolean addTrans){
		IndexColorModel pal = null;
		try {
			paletteURL= new URL(codeBase, palFileName);
		} catch (MalformedURLException e){
			System.out.println("MDLView: Error in palette URL <"+e+">");
			master.showStatus("MDLView: Error in palette URL...");
			throw new RuntimeException("MDLView: Error in palette URL...");
    		}
		master.showStatus("MDLView: Opening connection for palette as "+paletteURL);
		try{
			InputStreamReader palStream = new InputStreamReader(paletteURL.openStream());
			StreamTokenizer palToken = new StreamTokenizer( palStream );
			palToken.eolIsSignificant(true);
// Skip two lines of header
			for (int x = 0; x < 2;){
				int tokenType = palToken.nextToken();
				if (tokenType == palToken.TT_EOL){
					x++;
//					System.out.println("lINE: "+x);
				}
			}

			palToken.nextToken();
			int numberOfColours = (int) palToken.nval;
			if (numberOfColours != 256){
				master.showStatus("MDLView: !CARE!.. Pal says "+numberOfColours+" colours.. we use 256");
			}
			byte[] red = new byte[numberOfColours];
			byte[] green = new byte[numberOfColours];
			byte[] blue = new byte[numberOfColours];

			palToken.eolIsSignificant(false);

			for(int i=0; i < numberOfColours; i++){
				master.showStatus("MDLView: Reading colour "+i);
				palToken.nextToken();
				red[i]=(byte)palToken.nval;
				palToken.nextToken();
				green[i]=(byte)palToken.nval;
				palToken.nextToken();
				blue[i]=(byte)palToken.nval;
			}
			if (addTrans){
// Assume that 255 is transaparent
			    pal = new IndexColorModel(8,numberOfColours,red,green,blue,255);
			}else{
			    pal = new IndexColorModel(8,numberOfColours,red,green,blue);
			}
			palStream.close();
		}catch(IOException e){
			error("Error reading palette- <"+e+">");
		}
		return pal;
	}

	public boolean mouseDown(Event e, int x, int y) {
	    mouseX= x;
	    mouseY = y;
	    return false;
	}

	public boolean mouseDrag(Event e, int x, int y) {

		i = mdlViewCanvas.getRenderMode();
		if (i == mdlViewCanvas.textureMapped && !suppressFastRender){
		    fastRendering = true;
		    mdlViewCanvas.setRenderMode(mdlViewCanvas.wireframe);
		}
		if (moveNotRotate){
		    mdlViewCanvas.translateZ(2*(mouseY-y));
		}else{
		    mdlViewCanvas.rotateZ((x-mouseX));
		    mdlViewCanvas.rotateY((y-mouseY));
		}
		mouseX = x;
		mouseY = y;
		return false;

	}

	public boolean mouseMove(Event e, int x, int y) {

		master.showStatus(statusMessage);
		return true;
	}

	public boolean keyDown(Event e, int key){

//	    System.out.println(key);
	    switch (key){
		case 63:	// the ? key
		    if (helpWindow == null){
			helpWindow = new MDLHelpWindow(master.Version, myModel);
			helpWindow.show();
		    }else{
			helpWindow.show();
		    }
		    return true;
		case 109:
//		    if (monitorWindow == null){
//			monitorWindow = new MDLMonitorWindow(mdlViewCanvas, myModel,modelFileName);
//			monitorWindow.show();
//		    }else{
//			monitorWindow.show();
//		    }
		    mdlViewCanvas.toggleShowInfo();
		    return true;
		case 122: // The z key
		    moveNotRotate = true;
		    return true;
		case 97: // The a key
		    suppressFastRender = !suppressFastRender;
		    master.showStatus("MDLView: Goto wireframe is now "+!suppressFastRender);
		    return true;
		case 114:
//		    if (rotating){
//			master.showStatus("MDLView: Stopping rotation");
//			mdlViewCanvas.setRotating(false);
//			rotating = false;
//		    }else{
			rotating = !rotating;
			master.showStatus("MDLView: Rotate model is now "+rotating);
			mdlViewCanvas.setRotating(rotating);
//		    }
		    return true;
		case Event.TAB:
		    if (tabReady){
			master.showStatus("MDLView: Changing mode");
			mdlViewCanvas.nextRenderMode();
			tabReady = false;
			return true;
		    }
		case Event.LEFT:
		    master.showStatus("MDLView: Retreating one sub-frame");
		    mdlViewCanvas.lastSimpleFrame();
		    return true;
		case Event.RIGHT:
		    mdlViewCanvas.nextSimpleFrame();
		    master.showStatus("MDLView: Advancing one sub-frame");
		    return true;
		case 99:
		    if(!mdlViewCanvas.isAnimated){
			    master.showStatus("MDLView: Starting animation");
			    mdlViewCanvas.startAnimation();
		    }else{
			    master.showStatus("MDLView: Stopping animation");
			    mdlViewCanvas.stopAnimation();
		    }
		    return true;
		case Event.UP:
		    if (mdlViewCanvas.getRenderMode()== mdlViewCanvas.textureMapped){
			mdlViewCanvas.lastSkin();
			return true;
		    }
		case Event.DOWN:
		    if (mdlViewCanvas.getRenderMode()== mdlViewCanvas.textureMapped){
			mdlViewCanvas.nextSkin();
			return true;
		    }
	    }
	    if (myModel.keyPressed(key) ){
		mdlViewCanvas.scheduleTransform();
		mdlViewCanvas.scheduleRender();
	    }
	    return true;
	}

	public boolean keyUp(Event e, int key){

	    switch (key){
		    case 122: // z key
			moveNotRotate = false;
			return true;
		    case Event.TAB:
			tabReady = true;
			return true;
//		    case 109:	// the m key
//			mdlViewCanvas.setShowInfo(false);
//			return true;
	    }
	    return false;
	}

	public boolean mouseUp(Event e, int x, int y) {

		if (fastRendering && !suppressFastRender){
		    fastRendering = false;
		    mdlViewCanvas.setRenderMode(mdlViewCanvas.textureMapped);
		    return true;
		}
		return false;
	}

	public boolean mouseEnter(Event e, int x, int y){

	    master.requestFocus();
	    master.showStatus("MDLView: For help press '?'");
	    return false;
    	}

	public boolean mouseExit(Event e, int x, int y){
	
	    master.showStatus("");
	    return false;
	}
	
	protected boolean interpretBoolean(String bool){
	    if (bool == null){
		return false;
	    }
	    bool = bool.toLowerCase();
	    if (bool.startsWith("t")){
		return true;
	    }
	    return false;
	}
	
	private void error(String errorMsg){
	    master.showStatus("MDLView "+errorMsg);
	    System.out.println("MDLView "+errorMsg);
	    throw new RuntimeException("MDLView "+errorMsg);	    
	}
	
	private void getModel(String filename, String loadframes,String loadskins, int shift){
		myModel.readModel(docBase,codeBase,loadframes, loadskins, shift);
	}

}
