/*
 * Copyright (c) 1999 Thomas Grey All Rights Reserved.
 *
 * Thomas Grey grants you ("Licensee") a non-exclusive, royalty
 * free, license to use, modify and redistribute this software in
 * source and binary code form, provided that the following conditions 
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * This software is provided "AS IS," without a warranty of any
 * kind. ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND
 * WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY
 * EXCLUDED.  THOMAS GREY AND HIS LICENSORS SHALL NOT BE LIABLE
 * FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
 * MODIFYING OR DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO
 * EVENT WILL THOMAS GREY OR HIS LICENSORS BE LIABLE FOR ANY
 * LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT, INDIRECT, SPECIAL,
 * CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER CAUSED AND
 * REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF OR
 * INABILITY TO USE SOFTWARE, EVEN IF THOMAS GREY HAS BEEN
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 *
 * This software is not designed or intended for use in on-line
 * control of aircraft, air traffic, aircraft navigation or aircraft
 * communications; or in the design, construction, operation or
 * maintenance of any nuclear facility. Licensee represents and
 * warrants that it will not use or redistribute the Software for such
 * purposes.  
 */

import java.applet.Applet;
import java.awt.Dimension;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Image;
import java.awt.Graphics;
import java.awt.image.MemoryImageSource;
import java.awt.image.IndexColorModel;
import java.lang.Thread;
//import java.awt.event.*;

public class MDLViewCanvas extends java.awt.Canvas implements Runnable{

//byte colour;
	boolean rotating = false;
	int degsPerFrame = 10;
    // General variables
	short num_vertices;
	short num_triangles;
	float radius;
//	short skinw;
//	short skinh;
	boolean clockwiseCull;
	boolean aBoolean;
	boolean DEBUG;
	int j;
	int i;
	int startRowIndex;
	int col;
	int row;
	int screenPositionIndex;
    // The old and new x,y and z of the verticies for generatePoints()
        float x,y,z, xOld,yOld,zOld;
    // Index of verticies of current triangle in render()
	int v1, v2, v3;
	int height = 5;
	short halfWidth;
	short halfHeight;
	int width = 5;
	short[] aValues;
	short[] bValues;
	float[] xValues;
    //TEMP!!!!!
//	short[] aValuesR;
    //
//	int[] aTriPoints;
//	int[] bTriPoints;
	short startA;
	short endA;
	boolean flatTop = false;
	boolean flatBot = false;
    // Index of top, bottom and other vertex of current poly (used by renderer!)
	short polyClipTop = 0;
	short polyTop =0;
	short polyBottom = 0;
	short polyClipBottom = 0;
	short polyOther = 0;
	short polyClipOther = 0;
	float polySlopeLeft = 0;
	float polySlopeRight = 0;
	float aStartLeft;
	float aStartRight;
	float txStartLeft;
	float tyStartLeft;
	float txStartRight;
	float tyStartRight;
	float slopeTxLeft;
	float slopeTyLeft;
	float slopeTxRight;
	float slopeTyRight;
	float tStepX;
	float tStepY;
	float ftx;
	float fty;
	short polyTopS;
	short polyOtherS;
	short polyBottomS;
	short polyTopT;
	short polyOtherT;
	short polyBottomT;
//	short skinwOver2;
	short tx;
	short ty;
	float zoom = (float)2.0; //zoom level in model_radii
	int depth;
    // Max distance to model = 5 * model.radius
	int maxDepth;
    // Scaling factors for screen coordiantes
	float scaleFac = 300;
	Dimension mySize = new Dimension (height,width);
	Color backgroundColour;
	Color foregroundColour;
	Image gScreenImage;
	Image memScreenImage;
	boolean haveBImage = false;
	Image bImage;
//	boolean scaleBImage = false;
//	int bImageX = 0;
//	int bImageY = 0;
//	int bImageW = 0;
//	int bImageH = 0;
	static final byte clean = (byte)255;
	byte[] pixelByteArray;
	int numberOfPixels;
	Graphics offGraphics;
	int renderMode =0;
	static public final int Error = 0;
	static public final int wireframe = 1;
	static public final int hiddenLine = 3;
	static public final int textureMapped = 2;
// Number of rendering modes
	static final int numRenderModes = 3;
	IndexColorModel palette;
	MDLModel myModel;
	MemoryImageSource memImage;
	boolean imageReady = false;
	boolean isAnimated = false;
	static final double radsPerDeg = 3.1415927/180;
	static final double degsPerRad = 1/radsPerDeg;
	double theta = 0; // Angle about z
	double phi = 0; //Angle about y
	float cosTheta;
	float sinTheta;
	float cosPhi;
	float sinPhi;
	float xfac; // Y sin(theta) + X cos(theta)
	private Thread renderThread;
	private boolean renderPlease = true;
	private boolean transformPlease = true;
	private long startTime;
	private boolean stopRender =false;
// Delay of renderer in ms
	int[] delayTime;
	private long renderTimerStart;
	private int sumRenderInterval = 0;
	long ticks=0;
	long nextFrameTick = 0;
	long nextRotTick = 0;
// ********** VERSION 1.1
	float[] depthArray;
	float zStartLeft;
	float zStartRight;
	float zSlopeLeft;
	float zSlopeRight;
	float polyTopZ;
	float polyOtherZ;
	float polyBottomZ;
	float zStep;
	float zPixel;
	boolean boundsError = false;
	boolean showInfo = false;
	boolean noSkins = false;

	public MDLViewCanvas(Dimension d, MDLModel model, boolean debug){

		super();
		DEBUG = debug;
		height = d.height;
		halfHeight = (short)(height/2);
		width = d.width;
		halfWidth = (short)(width/2);
		numberOfPixels = (width*height);
		mySize = d;
		myModel = model;
// Setup delayTimes
		delayTime = new int[numRenderModes];
		for (i=0; i < numRenderModes; i++){
		    delayTime[i] = 10;
		}
//		aTriPoints = new int[3];
//		bTriPoints = new int[3];
		backgroundColour = new Color(0,0,0);
		foregroundColour = new Color(255,255,255);
		pixelByteArray = new byte[numberOfPixels];
		depthArray = new float[numberOfPixels];

	}
	
	public void setPalette(IndexColorModel pal){ 
		palette = pal;
	}
		
	public final static String getAuthorInfo(){
	    return ("Copyright T.J.Grey 1998");
	}
	
	
	public void initialiseGraphics(Image backImage, boolean scaleBImage){
		if (palette == null){
//		    showStatus("MDLView: Warning! Palette is null- using default palette");
		    makePal();
		}
		memImage = new MemoryImageSource(width, height, palette, pixelByteArray, 0, width);
		memImage.setAnimated(true);
		memScreenImage = this.createImage(memImage);
		gScreenImage = this.createImage(width, height);
	// get the image graphics context
		offGraphics = gScreenImage.getGraphics();
		haveBImage = false;
//	    System.out.println(backImage);
		if (backImage != null){
		    haveBImage = true;
		    int bImageH = backImage.getHeight(this);
		    int bImageW = backImage.getWidth(this);
		    bImage = this.createImage(width, height);
		    Graphics tempGraph = bImage.getGraphics();
		    tempGraph.setColor(backgroundColour);
		    tempGraph.fillRect(0,0,width,height);
		    if (scaleBImage){
			tempGraph.drawImage(backImage,0,0,width,height,this);
		    }else{
			int bImageX = (int)((float)(width-bImageW)/2);
			int bImageY = (int)((float)(height-bImageH)/2);
			tempGraph.drawImage(backImage,bImageX,bImageY,bImageW,bImageH, this);
		    }
		}
		resize(mySize);
		validate();
	}

	public Dimension getMinimumSize(){
		return mySize;
	}

	public Dimension getPreferedSize(){
		return mySize;
	}

	public void modelReady(){
		if (backgroundColour.equals(foregroundColour)){
		    System.out.println("MDLView: Background is same as foreground- ensure both set correctly");
		    backgroundColour = new Color(255,255,255);
		    foregroundColour = new Color(0,0,0);
		}
		num_vertices = (short) myModel.getNumberOfVertices();
		num_triangles = (short) myModel.getNumberOfTriangles();
		radius = myModel.getBoundingRadius();
		clockwiseCull = myModel.getClockwiseCull();
		aValues = new short[num_vertices];
		bValues = new short[num_vertices];
		xValues = new float[num_vertices];
//TEMP!!!!
//		aValuesR = new short[num_vertices];
//
	// Check for no skins:
		noSkins = (myModel.getNumberOfSkins() == 0);
	// Setup start depth = 2*model.radius
		depth = (int)(zoom*radius);
		maxDepth = 20*(int)radius;
	// Calculate scaleFac
		scaleFac = 4*java.lang.Math.min(width, height);
		generatePoints();
	// Initailise rendering flags
	       transformPlease = true;
	       renderPlease = true;
	}
    
	public void start(){
	       startTime = System.currentTimeMillis();
	       transformPlease = true;
	       renderPlease = true;
	       stopRender = false;
		ticks =0;
	       nextFrameTick = 0;
	       nextRotTick = 0;
	       renderThread = new Thread(this,"MDLViewRender");
	       renderThread.setPriority(Thread.NORM_PRIORITY-1);
	       renderThread.start();
	       scheduleRender();
	       if (isAnimated){
		startAnimation();
		}	
	}
	
	public void stop(){
	    stopRender = true;
	    imageReady = false;
	    if (renderThread != null && renderThread.isAlive()){
                renderThread.stop();// = null;
	    }
	}
/*	
	public void setBackgroundImage(Image bi, boolean scale){
	    scaleBImage = scale;
	    if (bi != null){
		bImage = bi;
		haveBImage = true;
		bImageH = bImage.getHeight(this);
		bImageW = bImage.getWidth(this);
		if (bImageH > 0 && bImageW > 0){
		    bImageX = (width - bImageW)/2;
		    bImageY = (height - bImageH)/2;
		}else{
		    haveBImage = false;
		}
	    }else{
		System.out.println("MDLView: BIMAGE is null... ignoring");
	    }
	}
*/	
	public void scheduleRender(){
	
	    renderPlease = true;
	}

	public void scheduleTransform(){
	
	    transformPlease = true;
	}


	public void setModel(MDLModel mod){
		myModel = mod;
		imageReady = false;
	}
	
	private void makePal(){
	    byte[] r = new byte[256];
	    byte[] g = new byte[256];
	    byte[] b = new byte[256];
	    for (int c = 0; c <256; c++){
		r[c] = (byte)(255-c);
		g[c] = (byte)(255-c);
		b[c] = (byte)(255-c);
	    }
	    palette = new IndexColorModel(8,256,r,g,b);
	    return;
	}

	private void render(){

	// Prevent rendering of an unloaded model
		if (myModel.getModelError() || !myModel.getModelReady() ){
			imageReady = false;
			return;
		}
		imageReady = false;
		// Choose style dependant method
		switch (renderMode){
			case (textureMapped):	//goreous texture mapping
//			    System.out.println("TExturemapping");
			    if (!noSkins){
	// Set the background to be transparent
				for (i = 0; i < numberOfPixels; i++){
				    depthArray[i] = -Float.MAX_VALUE;
				    pixelByteArray[i] = clean;
				}
	// Loop over triangles
				boundsError = false;
				for (i=0; i<num_triangles; i++){
				    renderThread.yield();
				    try{
					drawTriangleToScreenArray(i);//sortedTriangles[i]);
				    }catch(ArrayIndexOutOfBoundsException e){
					boundsError = true;
				    }
				}
			    // end triangles
				memImage.newPixels();
				if (haveBImage){
				    offGraphics.drawImage(bImage, 0, 0, this);
				    offGraphics.drawImage(memScreenImage, 0, 0, this);
				}else{
				    offGraphics.drawImage(memScreenImage, 0, 0,backgroundColour, this);
				}
			    }else{
			    
// Do depthArray rendered ala la sirds
//System.out.println("!!!");
				for (i = 0; i < numberOfPixels; i++){
				    depthArray[i] = -Float.MAX_VALUE;
				    pixelByteArray[i] = clean;
				}
	// Loop over triangles
				boundsError = false;
				for (i=0; i<num_triangles; i++){
				    renderThread.yield();
				    try{
					drawTriangleToScreenArray(i);//sortedTriangles[i]);
				    }catch(ArrayIndexOutOfBoundsException e){
					boundsError = true;
				    }
				}
				float maxDepth = Float.MAX_VALUE;
				float minDepth = -Float.MAX_VALUE;
				for (i = 0; i < numberOfPixels; i++){
				    if (pixelByteArray[i] != clean){
					minDepth = Math.max(depthArray[i],minDepth);
					maxDepth = Math.min(depthArray[i],maxDepth);
				    }
				}
				float depthPerColor = (minDepth-maxDepth)/252;
				for (i = 0; i < numberOfPixels; i++){
					if (pixelByteArray[i] != clean){
					    depthArray[i] = (depthArray[i]-maxDepth)/depthPerColor;
					    pixelByteArray[i] = (byte)(252-(int)(depthArray[i]));
					}else{
					    pixelByteArray[i] = (byte) 255;
					}
				}
				memImage.newPixels();
				offGraphics.drawImage(memScreenImage, 0, 0, this);
			    }
			    break;
			case(wireframe):	//Wireframe
//			    System.out.println("Wireframe");
    		// Create the image	
			    // Wipe the background
			    if (haveBImage){
				offGraphics.drawImage(bImage, 0, 0, this);
			    }else{
				offGraphics.setColor(backgroundColour);
				offGraphics.fillRect(0, 0, width, height);			    
			    }
			    offGraphics.setColor(foregroundColour);
		    // Since the model is "see through" no z-sort/buffer needed loop straight over triangles
			    for (i=0; i<num_triangles; i++){
			        v1 = (myModel.getTriangleVertexIndex(i,0) );
			        v2 = (myModel.getTriangleVertexIndex(i,1) );
			        v3 = (myModel.getTriangleVertexIndex(i,2) );
			        offGraphics.drawLine(aValues[v1],bValues[v1],aValues[v2],bValues[v2]);
			        offGraphics.drawLine(aValues[v2],bValues[v2],aValues[v3],bValues[v3]);
			        offGraphics.drawLine(aValues[v3],bValues[v3],aValues[v1],bValues[v1]);
			    }
		    /* Since the model is "see through" no z-sort/buffer needed loop straight over triangles
			    for (i=0; i<num_triangles; i++){
			        v1 = (myModel.getTriangleVertexIndex(i,0) );
			        v2 = (myModel.getTriangleVertexIndex(i,1) );
			        v3 = (myModel.getTriangleVertexIndex(i,2) );
				offGraphics.setColor(Color.red);
			        offGraphics.drawLine(aValues[v1],bValues[v1],aValues[v2],bValues[v2]);
			        offGraphics.drawLine(aValues[v2],bValues[v2],aValues[v3],bValues[v3]);
			        offGraphics.drawLine(aValues[v3],bValues[v3],aValues[v1],bValues[v1]);
				offGraphics.setColor(Color.blue);
			        offGraphics.drawLine(aValuesR[v1],bValues[v1],aValuesR[v2],bValues[v2]);
			        offGraphics.drawLine(aValuesR[v2],bValues[v2],aValuesR[v3],bValues[v3]);
			        offGraphics.drawLine(aValuesR[v3],bValues[v3],aValuesR[v1],bValues[v1]);
			    }*/
			    break;
		    default:
				// Show Error Banner
			    offGraphics.drawString("ERROR",5,10);
		}
		// Cause the new image to be displayed
		if(boundsError){
		    offGraphics.setColor(Color.red);
		    offGraphics.drawString("ARRAY BOUNDS EXCEEDED",10,10);
		    offGraphics.drawString("ARRAY BOUNDS EXCEEDED",10,height);
		}
		if(showInfo){
	    //Show inportant stuff at top!!
		    offGraphics.setColor(Color.red);
		    offGraphics.drawRect(0,0,width-1,height-1);
		    offGraphics.drawString("Frame: "+myModel.getCurrentFrameIndex()+", "+myModel.getFrameName(),10,20);
		    offGraphics.drawString("Zoom: "+zoom,10,30);
		    offGraphics.drawString("Angles Y: "+(int)(theta*degsPerRad)+", X: "+(int)(phi*degsPerRad),10,40);
		    offGraphics.drawString("Skin: "+myModel.getCurrentSkinIndex(),10,50);
		    
		    offGraphics.drawString("Frames loaded: "+myModel.getFramesString(),10,63);
		    offGraphics.drawString("Skins loaded: "+myModel.getSkinsString(),10,73);
		    offGraphics.drawString("Vertices: "+myModel.getNumberOfVertices()+" Triangles: "+myModel.getNumberOfTriangles(),10,83);
		    offGraphics.drawString("Rendertime: "+sumRenderInterval+"ms",10,93);
		    offGraphics.drawString("Vertical shift: "+myModel.getYShift(),10,103);
		    offGraphics.drawString("Press 'm' to remove this info",10,118);
		}
		imageReady = true;
		update(this.getGraphics() );
		renderPlease = false;
	}
		

// Used to get rendered images for movie- returns rendered copy of current frame
	public Image getImage(){
		if (myModel.getModelError() || !myModel.getModelReady() ){
//		    System.out.println("NULLL");
		    return null;
		}
		generatePoints();
	// Set the background to be transparent
		for (i = 0; i < numberOfPixels; i++){
		    depthArray[i] = -Float.MAX_VALUE;
		    pixelByteArray[i] = clean;
		}
    // Loop over triangles
		for (i=0; i<num_triangles; i++){
		    drawTriangleToScreenArray(i);//sortedTriangles[i]);
		}
		// end triangles
		
		memImage = new MemoryImageSource(width, height, palette, pixelByteArray, 0, width);
		memImage.setAnimated(false);
		return this.createImage(memImage);
	}

	public void paint(Graphics g){
		update(g);
	}
	
	public void toggleShowInfo(){
	    showInfo = !showInfo;
	    renderPlease = true;
	}

	private void generatePoints(){
// Generate transform equations
	    cosTheta = (float) java.lang.Math.cos(theta);
	    sinTheta = (float) java.lang.Math.sin(theta);
	    cosPhi = (float) java.lang.Math.cos(phi);
	    sinPhi = (float) java.lang.Math.sin(phi);
// Loop over points
	    for (i=0; i<num_vertices; i++){
// Extract the point of interest
		xOld = myModel.getVertexX(i);
		yOld = myModel.getVertexY(i);
		zOld = myModel.getVertexZ(i);
// Transform the model
		xfac = xOld*cosTheta - yOld*sinTheta;
		x = xfac*cosPhi + zOld * sinPhi;
		y = yOld * cosTheta + xOld * sinTheta;
		z = zOld*cosPhi - xfac*sinPhi;
/* Transform the model
		float xfacR = xOld*cosTheta - (yOld+1)*sinTheta;
		float xR = xfac*cosPhi + zOld * sinPhi;
		float yR = (yOld+1) * cosTheta + xOld * sinTheta;
		float zR = zOld*cosPhi - xfac*sinPhi;
// Move back, test too close
		xR -= radius;
		xR -= depth;*/
		x -= radius;
		x -= depth;
		xValues[i] = x;
// Generate screen coordiantes
		aValues[i] = (short)((scaleFac*y/(-x)) + halfWidth);
//		aValuesR[i] = (short)((scaleFac*yR/(-xR)) + halfWidth);
		bValues[i] = (short)(halfHeight - (short)(scaleFac*z/(-x)));
	    }
		transformPlease = false;
	}

	public void update(Graphics g) {
		// Paint screen image up
		if (imageReady){
//		    System.out.println("Drawing to screen");
		    g.drawImage(gScreenImage, 0, 0, width, height, this);
		}
	}

	public void setMode(String mode){
// Set the mode eg wireframe etc
		mode = mode.toLowerCase();
		if (mode.equals("wireframe")|| mode.equals("wire")){
			renderMode = wireframe;
		}else if(mode.equals("hiddenline")){
			System.out.println("MDLViewCanvas: Hiddenline mode is no longer avalible");
			renderMode = wireframe;//hiddenLine;
		}else if(mode.equals("texturemapped") || mode.equals("texture")||mode.equals("texturemap")||mode.equals("texturemapping")){
			renderMode = textureMapped;
		}else if(mode.equals("error")){
			renderMode = 0;
		}else{
			renderMode = wireframe;
			System.out.println("MDLView: Unknown mode '"+mode+"' reverting to wireframe");
		}
		renderPlease = true;
	}

	public void nextRenderMode(){
		if (renderMode == numRenderModes-1){
			renderMode = 1;
		}else{
			renderMode++;
		}
		if (renderMode == hiddenLine){
		    nextRenderMode();
		}
		renderPlease = true;
	}
	
	public int getRenderMode() {
	    return renderMode;
	}
	
	public void setRenderMode(int mode){
		if (mode <= numRenderModes-1){
		    renderMode = mode;
		}else{
		    System.out.println("MDLView: No mode corresponding to "+mode+" found");
		    renderMode = wireframe;
		}
		if (renderMode == hiddenLine){
		    nextRenderMode();
		}
		renderPlease = true;
	}

	public void stopAll(){
	    	stopRender = true;
	}
	
	public void startAnimated(boolean dowe){
		isAnimated = (dowe);
	}

	public void startAnimation(){
	    if (myModel.getNumberOfFrames() > 0){
		isAnimated = true;
		nextFrameTick = ticks;
		renderPlease = true;
	    }
	}

	public void stopAnimation(){
		isAnimated = false;
	}
	
	public void setSkinGroup(int snum){
	    myModel.setCurrentSkinIndex(snum);
	    renderPlease = true;
	}


	public void setBackgroundColour(Color bColour) {
	    backgroundColour = bColour;
	}

	public void setForegroundColour(Color fColour){
	    foregroundColour = fColour;
	}


	public void setRotating(int degsPF){
	    if (degsPF > 0){
		rotating = true;
		degsPerFrame = degsPF;
	    }else{
		rotating = false;
	    }
	}
	
	public void setRotating(boolean yesOrNo){
	    rotating = yesOrNo;
	}

	public void nextSimpleFrame(){
	    myModel.nextFrame();
	    transformPlease = true;
	    renderPlease = true;
	}
	
	public void nextSkin(){
	    myModel.nextSkin();
	    renderPlease = true;
	}
	
	public void lastSkin(){
	    myModel.lastSkin();
	    renderPlease = true;
	}
		
	public void lastSimpleFrame(){
	    myModel.lastFrame();
	    transformPlease = true;
	    renderPlease = true;
	}
	
	public void setZAngle(int ang){
	    theta = (float) (ang * radsPerDeg);
	    theta = theta %  6.2831854;
	    transformPlease = true;
	    renderPlease = true;
	}	    
		
	public void setYAngle(int ang){
	    phi = (float) (ang * radsPerDeg);
	    phi = phi %  6.2831854;
	    transformPlease = true;
	    renderPlease = true;
	}	    
	
	public void rotateZ(int ang){
	    theta += (float) (ang * radsPerDeg);
	    theta = theta %  6.2831854;
	    transformPlease = true;
	    renderPlease = true;
	}

	public void rotateY(int ang){
	    phi += (float) (ang * radsPerDeg);
	    phi = phi %  6.2831854;
	    transformPlease =true;
	    renderPlease = true;
	}
	
	public void setZoom(float z){
	
	    if (z < 50 &&  z > 0){
		zoom =z;
	    }
	    transformPlease = true;
	    renderPlease = true;
	}

	private void tick(){
	    if (rotating && (ticks >= nextRotTick) ){
		rotateZ(degsPerFrame);
		nextRotTick = ticks + 30;
	    }
	    if (isAnimated && (ticks >= nextFrameTick)){
		nextFrameTick = ticks + myModel.getFrameDelayMillis();
		nextSimpleFrame();
	    }
	}
	
	public void run(){

		while(!stopRender && renderThread != null){
			System.gc();
			tick();
			if (transformPlease){
			    generatePoints();
			}
			if (renderPlease){
			    renderTimerStart = System.currentTimeMillis();
			    render();
			    sumRenderInterval = (int)(System.currentTimeMillis()-renderTimerStart);
			    delayTime[renderMode] += 0.1*(sumRenderInterval - delayTime[renderMode]);
			    delayTime[renderMode] = Math.max(delayTime[renderMode],50);
			}
			renderThread.yield();
			try {
			    ticks += 50;//sumRenderInterval;
			    startTime += delayTime[renderMode];// (myModel.getFrameDelayMillis()*delayTimeScaler[renderMode]);
			    Thread.sleep(Math.max(0,startTime-System.currentTimeMillis()));
			} catch (InterruptedException e) {
			    System.out.println("Interupted render thread");
			}
		}
	}
	
	public void translateZ(int distance){
	    if ((distance+depth) < maxDepth && (distance+depth) > 0){
		zoom += (distance/radius);
		depth = (int)(radius * zoom);
	    }
	    transformPlease = true;
	    renderPlease = true;
	}

    private void drawTriangleToScreenArray(int polygon){
	row = col =0;
	    // get top and bottom index- unrolled loop
	polyTop = 0;
	polyBottom = 0;
	polyOther = 0;
	v1= myModel.getTriangleVertexIndex(polygon, 0);
	v2= myModel.getTriangleVertexIndex(polygon, 1);
	v3 = myModel.getTriangleVertexIndex(polygon, 2);
	if (bValues[myModel.getTriangleVertexIndex(polygon, polyTop)] > bValues[v2]){polyTop = 1;}
	if (bValues[myModel.getTriangleVertexIndex(polygon, polyTop)] > bValues[v3]){polyTop = 2;}
	if (bValues[myModel.getTriangleVertexIndex(polygon, polyBottom)] < bValues[v2]){polyBottom = 1;}
	if (bValues[myModel.getTriangleVertexIndex(polygon, polyBottom)] < bValues[v3]){polyBottom = 2;}
	if (polyOther == polyTop || polyOther == polyBottom){
	    polyOther = 1;
	    if (polyOther == polyTop || polyOther == polyBottom){
		polyOther = 2;
	    }
	}
    	// Assume right-handed
	v1=myModel.getTriangleVertexIndex(polygon,polyTop);
	v2=myModel.getTriangleVertexIndex(polygon,polyOther);
	v3=myModel.getTriangleVertexIndex(polygon,polyBottom);
	// Test if actually right-handed
	flatTop = false;
	flatBot = false;
	boolean righthanded = true;
	if (bValues[v1]==bValues[v2]){
	    flatTop = true;
	    if (aValues[v1] > aValues[v2]){
		j = v1;
		polyClipBottom = polyTop;
		v1 = v2;
		polyTop = polyOther;
		v2 = j;
		polyOther = polyClipBottom;
	    }
//	    return;
	}else if(bValues[v3]==bValues[v2]){
	    flatBot = true;
	    if (aValues[v3] > aValues[v2]){
		j = v3;
		polyClipBottom = polyBottom;
		v3 = v2;
		polyBottom = polyOther;
		v2 = j;
		polyOther = polyClipBottom;
	    }
//	    return;
	}
	polySlopeLeft = (float)(aValues[v3]-aValues[v1])/(float)(bValues[v3]-bValues[v1]);
	polySlopeRight = (float)(aValues[v2]-aValues[v1])/(float)(bValues[v2]-bValues[v1]);
	righthanded =( flatTop|| flatBot||(aValues[v2]) >= ((short)(aValues[v1]+ ((float)(bValues[v2]-bValues[v1]))*polySlopeLeft)));
	    //yes actually right handed- continue
    // Back cull is anticlockwise vertices
	if (righthanded){
	    if (cullable() ){
		return;
	    }
	}else{    
	    if(cullable2()){
		return;
	    }
	}
	    polyTopT = myModel.getSkinVertexT(polygon, polyTop);
	    polyOtherT = myModel.getSkinVertexT(polygon, polyOther);
	    polyBottomT = myModel.getSkinVertexT(polygon, polyBottom);
	    polyTopS = myModel.getSkinVertexS(polygon, polyTop);
	    polyOtherS = myModel.getSkinVertexS(polygon, polyOther);
	    polyBottomS = myModel.getSkinVertexS(polygon, polyBottom);

	// Change polyTop etc to point directly to the vertex index
	    polyTop = (short)v1;
	    polyBottom = (short)v3;
	    polyOther = (short)v2;
	    
	    polyTopZ = xValues[polyTop];
	    polyOtherZ = xValues[polyOther];
	    polyBottomZ = xValues[polyBottom];
	    
	    slopeTxLeft = (float)(polyBottomS - polyTopS)/(float)(bValues[polyBottom] - bValues[polyTop]);
	    slopeTyLeft = (float)(polyBottomT - polyTopT)/(float)(bValues[polyBottom] - bValues[polyTop]);
	    slopeTxRight = (float)(polyOtherS - polyTopS)/(float)(bValues[polyOther] - bValues[polyTop]);
	    slopeTyRight = (float)(polyOtherT - polyTopT)/(float)(bValues[polyOther] - bValues[polyTop]);
	    
	    zSlopeLeft = (polyBottomZ - polyTopZ)/(float)(bValues[polyBottom] - bValues[polyTop]);
	    zSlopeRight = (polyOtherZ - polyTopZ)/(float)(bValues[polyOther] - bValues[polyTop]);

	    aStartLeft = aValues[polyTop];
	    aStartRight = aValues[polyTop];
	    
	    txStartLeft = polyTopS;
	    tyStartLeft = polyTopT;
	    txStartRight = polyTopS;
	    tyStartRight = polyTopT;
	    
	    zStartLeft = polyTopZ;
	    zStartRight = polyTopZ;

    // Move top and bottom points in polyTop and POlyBottom
	    polyClipTop = bValues[polyTop];
	    polyClipOther = bValues[polyOther];
	    polyClipBottom = bValues[polyBottom];
	    
	    
	    if (!flatTop){
// Clip
		if (polyClipTop < 0){
		    if(polyClipBottom < 0){
			return;
		    }
		    if (polyClipOther <0){
			j = polyClipOther-polyClipTop;
		    }else{
			j = -polyClipTop;
		    }
		    aStartLeft += (j*polySlopeLeft);
		    aStartRight += (j*polySlopeRight);
		    txStartLeft += (j*slopeTxLeft);
		    tyStartLeft += (j*slopeTyLeft);
		    txStartRight += (j*slopeTxRight);
		    tyStartRight += (j*slopeTyRight);
		    zStartLeft += (j*zSlopeLeft);
		    zStartRight += (j*zSlopeRight);
		    polyClipTop = 0;
		}
		if (polyClipOther > height -1){
		    polyClipOther = (short)(height);
		}
// Begin the polyfilling
		startRowIndex = (polyClipTop-1)*width;
	    
		if (flatBot && polyClipOther < height){
		    polyClipOther++;
		}	
	    
		for (row = polyClipTop; row < polyClipOther; row++){
		if(righthanded){
		    startA = (short)(aStartLeft);
		    endA = (short)(aStartRight);
		}else{
		    startA = (short)(aStartRight);
		    endA = (short)(aStartLeft);
		}
		    j = endA-startA+1;
		if (righthanded){
		    tStepX = (float)(txStartRight - txStartLeft)/(float)j;
		    tStepY = (float)(tyStartRight - tyStartLeft)/(float)j;
		    zStep = (zStartRight - zStartLeft)/(float) j;
		    ftx = txStartLeft;
		    fty = tyStartLeft;
		    zPixel = zStartLeft;
		}else{
		    tStepX = (float)(txStartLeft - txStartRight)/(float)j;
		    tStepY = (float)(tyStartLeft - tyStartRight)/(float)j;
		    zStep = (zStartLeft - zStartRight)/(float) j;
		    ftx = txStartRight;
		    fty = tyStartRight;
		    zPixel = zStartRight;
		}
		// Clip left to right
		    if (startA < 0){
			col = -startA;
			ftx += col*tStepX;
			fty += col*tStepY;
			zPixel += col*zStep;
			startA = 0;
		    }
		    if (endA > width-1){
			endA = (short)(width-1);
		    }
		
		    startRowIndex += width;
		    screenPositionIndex = startRowIndex+startA;
		    col = startRowIndex + endA;
		    while (screenPositionIndex <= col){
			if (depthArray[screenPositionIndex]<zPixel){
			    tx = (short)(ftx);
			    ty = (short)(fty);
			    pixelByteArray[screenPositionIndex] = myModel.getTexel(tx,ty);
			    depthArray[screenPositionIndex] = zPixel;
			}
			screenPositionIndex++;
			ftx += tStepX;
			fty += tStepY;
			zPixel += zStep;
		    }

		aStartLeft += polySlopeLeft;
		aStartRight += polySlopeRight;
	    
		txStartLeft += slopeTxLeft;
		tyStartLeft += slopeTyLeft;
		txStartRight += slopeTxRight;
		tyStartRight += slopeTyRight;
	    
		zStartLeft += zSlopeLeft;
		zStartRight += zSlopeRight;
	    }
	    if (flatBot){
		return;
	    }
	}
//flatTop	
    // PolyOther downwards
        // Move top and bottom points in polyTop and POlyBottom
	polyClipOther = bValues[polyOther];
	polyClipBottom = bValues[polyBottom];


	polySlopeRight = (float)(aValues[polyBottom]-aValues[polyOther])/(float)(bValues[polyBottom]-bValues[polyOther]);
	aStartRight = aValues[polyOther];

	slopeTxRight = (float)(polyBottomS - polyOtherS)/(float)(bValues[polyBottom] - bValues[polyOther]);
	slopeTyRight = (float)(polyBottomT - polyOtherT)/(float)(bValues[polyBottom] - bValues[polyOther] );
	txStartRight = polyOtherS;
	tyStartRight = polyOtherT;
	
	zSlopeRight = (polyBottomZ - polyOtherZ)/(float)(bValues[polyBottom] - bValues[polyOther]);
	zStartRight = polyOtherZ;

// Clip
	if (polyClipOther < 0){
	    if (polyClipBottom < 0){
		return;
	    }
	    j = -polyClipOther;
	    aStartLeft += (j*polySlopeLeft);
	    aStartRight += (j*polySlopeRight);
	    txStartLeft += (j*slopeTxLeft);
	    tyStartLeft += (j*slopeTyLeft);
	    txStartRight += (j*slopeTxRight);
	    tyStartRight += (j*slopeTyRight);
	    zStartLeft += (j*zSlopeLeft);
	    zStartRight += (j*zSlopeRight);
	    polyClipOther = 0;
	}
	if (polyClipBottom > height -1){
	    polyClipBottom = (short)(height-1);
	}
// Begin the polyfilling
	startRowIndex = (polyClipOther-1)*width;
	for (row = polyClipOther; row <= polyClipBottom; row++){

		if(righthanded){
		    startA = (short)(aStartLeft);
		    endA = (short)(aStartRight);
		}else{
		    startA = (short)(aStartRight);
		    endA = (short)(aStartLeft);
		}
	    j = endA-startA+1;
		if (righthanded){
		    tStepX = (float)(txStartRight - txStartLeft)/(float)j;
		    tStepY = (float)(tyStartRight - tyStartLeft)/(float)j;
		    zStep = (zStartRight - zStartLeft)/(float) j;
		    ftx = txStartLeft;
		    fty = tyStartLeft;
		    zPixel = zStartLeft;
		}else{
		    tStepX = (float)(txStartLeft - txStartRight)/(float)j;
		    tStepY = (float)(tyStartLeft - tyStartRight)/(float)j;
		    zStep = (zStartLeft - zStartRight)/(float) j;
		    ftx = txStartRight;
		    fty = tyStartRight;
		    zPixel = zStartRight;
		}
		// Clip left to right
	    if (startA < 0){
		col = -startA;
		ftx += col*tStepX;
		fty += col*tStepY;
		zPixel += col*zStep;
		startA = 0;
	    }
	    if (endA > width-1){
		endA = (short)(width-1);
	    }

	    startRowIndex += width;
	    screenPositionIndex = startRowIndex+startA;
	    col = startRowIndex + endA;
	    while (screenPositionIndex <= col){
		    if (depthArray[screenPositionIndex]<zPixel){
			tx = (short)(ftx);
			ty = (short)(fty);
			pixelByteArray[screenPositionIndex] = myModel.getTexel(tx,ty);
			depthArray[screenPositionIndex] = zPixel;
		    }
		    screenPositionIndex++;
		    ftx += tStepX;
		    fty += tStepY;
		    zPixel += zStep;
		}

	    aStartLeft += polySlopeLeft;
	    aStartRight += polySlopeRight;
//
	    txStartLeft += slopeTxLeft;
	    tyStartLeft += slopeTyLeft;
	    txStartRight += slopeTxRight;
	    tyStartRight += slopeTyRight;
	    
	    zStartLeft += zSlopeLeft;
	    zStartRight += zSlopeRight;
	}
	return;
	
	
    }

    private boolean cullable2(){
	if (clockwiseCull){
	    if (polyOther +1 != polyTop){
		if(polyOther == 2 && polyTop == 0){
		    return false;
		}
		return true;
	    }
	    return false;
	}else{
	    if (polyOther -1 != polyTop){
		if(polyTop == 2 && polyOther == 0){
		    return false;
		}
		return true;
	    }
	    return false;
	}
    }
    
    private boolean cullable(){
	if (clockwiseCull){
    // Backface cull if anticlockwise vertex ordering
	    if (polyOther != polyTop+1){
		if( polyTop==2 && polyOther==0 ){
		    return false;
		}
		return true;
	    }
	    return false;
	}else{
	    if (polyOther != polyTop -1){
		if (polyOther ==2 && polyTop ==0){
		    return false;
		}
		return true;
	    }
	    return false;
	}
    }

    // End of class	
}
