/*
 * Copyright (c) 1999 Thomas Grey All Rights Reserved.
 *
 * Thomas Grey grants you ("Licensee") a non-exclusive, royalty
 * free, license to use, modify and redistribute this software in
 * source and binary code form, provided that the following conditions 
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * This software is provided "AS IS," without a warranty of any
 * kind. ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND
 * WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY
 * EXCLUDED.  THOMAS GREY AND HIS LICENSORS SHALL NOT BE LIABLE
 * FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
 * MODIFYING OR DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO
 * EVENT WILL THOMAS GREY OR HIS LICENSORS BE LIABLE FOR ANY
 * LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT, INDIRECT, SPECIAL,
 * CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER CAUSED AND
 * REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF OR
 * INABILITY TO USE SOFTWARE, EVEN IF THOMAS GREY HAS BEEN
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 *
 * This software is not designed or intended for use in on-line
 * control of aircraft, air traffic, aircraft navigation or aircraft
 * communications; or in the design, construction, operation or
 * maintenance of any nuclear facility. Licensee represents and
 * warrants that it will not use or redistribute the Software for such
 * purposes.  
 */

import java.awt.Event;

public class MDLView extends java.applet.Applet implements MDLModelTracker, Runnable{

	MDLViewMain main;
	boolean initialised = false;
	boolean modelReady = false;
	String mouseOverText;
	String statusMessage = "MDLView loading...";
	java.awt.Color backgroundColour;
	java.awt.Color foregroundColour;
	boolean haveBImage = false;
	boolean scaleBI;
	java.awt.Image bImage;
	boolean DEBUG = false;
	boolean noOut = false;
	static int Version = 103;
	int w;
	int h;
	int ix;
	int iy;
	int pcolx;
	int pcorx;
	int pcoty;
	int pcoby;
	Thread starterThread;

	int pcbx;
	
	public void init() {
		System.gc();
		String suppressOut = getParameter("NOSTATUS");
		if (suppressOut !=null){
		    suppressOut = suppressOut.toLowerCase();
		    noOut = suppressOut.startsWith("t");
		}
		showStatus("MDLView: Initialising...");
//		setLayout(new java.awt.BorderLayout());
		String bColour = getParameter("BCOLOUR");
		String fColour = getParameter("FCOLOUR");
		backgroundColour = getColourFromString(bColour);
		foregroundColour = getColourFromString(fColour);
		java.awt.Dimension mySize = size();
		w = mySize.width;
		h = mySize.height;
	    
		pcolx = (int)(0.05 * (w-1));
		pcorx = w-1 - (2*pcolx);
		pcoty = (int)(0.1*(h-1));
		if (pcoty <36){
		    pcoty = 36;
		}
		pcoby= 14;
	    
		pcbx = 0;

		showStatus("MDLView: Loading main applet methods");
		
	}

	public void start() {
	
	    if (!initialised){
		    removeAll();
		    DEBUG = (getParameter("DEBUG") != null);
		    setLayout(new java.awt.BorderLayout());
		    String bColour = getParameter("BCOLOUR");
		    String fColour = getParameter("FCOLOUR");
		    backgroundColour = getColourFromString(bColour);
		    foregroundColour = getColourFromString(fColour);
// Background image
		    haveBImage = false;
		    String bImageStr = getParameter("BIMAGE");
		    String bImageScaleStr = getParameter("SCALEBIMAGE");
		    if (bImageScaleStr == null){
			bImageScaleStr = "false";
		    }
		    bImageScaleStr = bImageScaleStr.toLowerCase();
		    if (bImageScaleStr.startsWith("f")){
			scaleBI = false;
		    }else{
			scaleBI = true;
		    }
		    if (bImageStr != null){
			java.awt.MediaTracker BITracker = new java.awt.MediaTracker(this);
			bImage = getImage(getDocumentBase(), bImageStr);
			BITracker.addImage(bImage, 0);
			showStatus("MDLView: Loading background");
			try {
			    BITracker.waitForAll();
			} catch (InterruptedException e) {}
			if (BITracker.checkAll() && !BITracker.isErrorAny()){
			    haveBImage = true;
			}else{
			    System.out.println("MDLView: BIMAGE ignored- error getting image");
			    showStatus("MDLView: BIMAGE ignored- error getting image");
			}
		    }
		    java.awt.Dimension mySize = size();
		    w = mySize.width;
		    h = mySize.height;
		    pcolx = (int)(0.05 * (w-1));
		    pcorx = w-1 - (2*pcolx);
		    pcoty = (int)(0.1*(h-1));
		    if (pcoty <36){
			pcoty = 36;
		    }
		    pcoby= 14;
		    pcbx = 0;
//		    paint(this.getGraphics());
	    }
	    showStatus("MDLView: Creating thread to read parameters");
	    starterThread = new Thread(this,"StarterThread");
	    starterThread.start();
	}

	public void stop() {
	    main.stop();
	    if (starterThread != null && starterThread.isAlive()){
		starterThread.stop();
		starterThread = null;
		initialised = false;
	    }
	    main.stop();
	}
	
	public java.awt.Image getBackgroundImage(){
	    return bImage;
	}
	
	public boolean haveBackgroundImage(){
	    return haveBImage;
	}
	
	public boolean scaleBackgroundImage(){
	    return scaleBI;
	}
	
	public void destroy() {

	    main.destroy();

	}
	
	public java.awt.Color getBackground(){
	    return backgroundColour;
	}
	
	public java.awt.Color getForeground(){
	    return foregroundColour;
	}
	
	public String getAppletInfo() {
	    if (Version%100 >= 10){
		return ("MDLView v"+Version/100+"."+Version%100+": An Applet by T.J.Grey to Display 3D Model Files");
	    }else{
		return ("MDLView v"+Version/100+".0"+Version%100+": An Applet by T.J.Grey to Display 3D Model Files");
	    }		
	}

	public String[][] getParameterInfo() {

		String[][] info = {
	// Parameter Name     Kind of Value   Description
			{"MODEL",	"relative URL",	"The URL of the model file (ie MODELPATH is not set) relative to document base (ie the HTML page)"},
			{"MODELPATH",	"relative URL",	"The path of the model files relative to code base (ie the applet classes)"},
			{"BCOLOUR",	"hex number",	"Colour of background eg #FFFFFF"},
			{"FCOLOUR",	"hex number",	"Colour used for wireframe eg #000000"},
			{"PALETTE",	"relative URL",	"URL of Palette file, relative to codebase"},
			{"FORMAT",	"string",	"Supported model type- the name of the Model class without 'MDL' or 'Model'"},
			{"LOADFRAMES",        "string",          "Number frames to load, then frame numbers IN ORDER, no spaces eg 4,0-3,5"},
			{"LOADSKINS",        "string",          "Number skins to load, then skin numbers IN ORDER, no spaces eg 2,0,5"},
			{"RENDERMODE",     "string",          "Start mode- currently 'wireframe','hiddenline' or 'texturemapped'"},
			{"ROTATE",           "boolean",          "Start with model rotating either 'true' or 'false'"},
			{"YANGLE",           "int",          "Start with model rotated by this about the vertical angle"},
			{"XANGLE",           "int",          "Start with model rotated by this about the left/right angle"},
			{"STARTSKIN",           "int",          "Start with this skin"},
			{"CYCLE",           "boolean",          "Start with model cycling through frames"},
//
			{"ZOOM",          "float",         "Zoom level for model- use with care!"},
			{"SHIFTY",          "int",      "Shifts model vertically (use with care!)"},
			{"BIMAGE",       "String",  "NAME of a gif or jpeg to show behind the model"},
			{"SCALEBIMAGE", "boolean", "Scale the BIMAGE to fit applet"},
			{"EXTRA",     "String",          "Info passed to the model format class."},
			{"NOSTATUS",     "boolean",          "Suppress statusline messages."},
			{"MOUSEOVER","String", "Text to be displayed when the mouse is over the applet"}
		};
		return info;
	}
	
// Seperate thread to run MDLViewMain.start()
	public void run(){
	    update(this.getGraphics());
	    if (!initialised){
    		main = new MDLViewMain(this);
	    }
	    main.start();
	    initialised = true;
	}
	
	public void paint(java.awt.Graphics g){
	    super.paint(g);
	    update(g);
	}
	
	public void update(java.awt.Graphics g){
	    if(haveBImage){
		if (scaleBI){
		    g.drawImage(bImage,0,0,w,h,this);
		    g.setColor(foregroundColour);
		    g.drawRect(0,0,w-1,h-1);
		}else{
		    g.drawImage(bImage,ix,iy,this);
		    g.setColor(foregroundColour);
		    g.drawRect(0,0,w-1,h-1);
		}
	    }else{
		g.setColor(backgroundColour);
		g.fillRect(0,0,w,h);
		g.setColor(foregroundColour);
		g.drawRect(0,0,w-1,h-1);
	    }
	    writeMessage(statusMessage);
	    g.setColor(backgroundColour);
	    g.fillRect(pcolx,pcoty,pcorx,pcoby);
	    g.setColor(foregroundColour);
	    g.drawRect(pcolx,pcoty,pcorx,pcoby);
	    g.drawRect(pcolx+2,pcoty+2,pcorx-4,pcoby-4);
	    g.fillRect(pcolx+2,pcoty+2,pcbx,pcoby-4);
	}
	
	public void writeMessage(String text){
		java.awt.Graphics gph = this.getGraphics();
		gph.setColor(backgroundColour);
		gph.fillRect(1,1,w-2,35);
		gph.setColor(foregroundColour);
		gph.drawString(statusMessage,10,30);
	}

	public void showPercentage(int pcent){
	    if (!modelReady){
		java.awt.Graphics gph = this.getGraphics();
		int pcOld = pcbx;
		pcbx = (int)((pcent*(pcorx-4))/100);
		if (pcbx < pcOld){
		    gph.setColor(backgroundColour);
		    gph.fillRect(pcolx+2,pcoty+2,pcorx-4,pcoby-4);
		    gph.setColor(foregroundColour);
		    gph.drawRect(pcolx+2,pcoty+2,pcorx-4,pcoby-4);
		}
		gph.setColor(foregroundColour);
		gph.fillRect(pcolx+2,pcoty+2,pcbx,pcoby-4);
	    }
	}


	public void modelReady(){
	    modelReady = true;
	    String text = getParameter("MOUSEOVER");
	    if (text != null){
		mouseOverText = "MDLView: "+text;
	    }else{
		mouseOverText = "MDLView: For help press '?'";
	    }
	    main.modelReady();
	}
	
	public void showStatus(String message){

	    if (DEBUG && !modelReady && !message.equals(statusMessage)){
		System.out.println("DBG: "+message);
	    }
	    if(!noOut){
		super.showStatus(message);
		if (!modelReady){
		    statusMessage = message;
		    writeMessage(statusMessage);
		}
	    }
	}
	
	public final String getAuthorInfo(){
	    return "T.J.Grey (tjg1@ch.ic.ac.uk) Copyright 1998";
	}


	public boolean mouseDown(Event e, int x, int y) {
	    return main.mouseDown(e,x,y);
	}

	public boolean mouseDrag(Event e, int x, int y) {

		return main.mouseDrag(e,x,y);

	}

	public boolean mouseMove(Event e, int x, int y) {

		if (modelReady){
		    statusMessage = mouseOverText;
//	    showStatus(main.mdlViewCanvas.tempFunc(x,y));
		}
		showStatus(statusMessage);
		return true;
	}

	public boolean keyDown(Event e, int key){

		return main.keyDown(e,key);
	}

	public boolean keyUp(Event e, int key){

    	    return main.keyUp(e,key);
	}

	public boolean mouseUp(Event e, int x, int y) {
		return main.mouseUp(e,x,y);
	}

	public boolean mouseEnter(Event e, int x, int y){

		requestFocus();
		return false;
    	}

	public boolean mouseExit(Event e, int x, int y){
	    return false;
	}
	
	public String getExtraParameter(){
		return getParameter("EXTRA");
	}
	
	private java.awt.Color getColourFromString(String colourName){

		if (colourName == null || colourName.length() != 7){
		    System.out.println("MDLView: "+colourName+" not specified or specified incorrectly, using white");
		    System.out.println("... usage eg <PARAM NAME=BCOLOUR VALUE=#FF00FF>");
		    colourName = "#FFFFFF";
		}
		java.awt.Color colour = null;
		try{
		    int red;
		    int green;
		    int blue;
		    String rdColour = "0x"+colourName.substring(1,3);
		    String gnColour = "0x"+colourName.substring(3,5);
		    String blColour = "0x"+colourName.substring(5,7);
		    red = (Integer.decode(rdColour)).intValue();
		    green = (Integer.decode(gnColour)).intValue();
		    blue = (Integer.decode(blColour)).intValue();
		    colour =  new java.awt.Color(red,green,blue);
		} catch(NumberFormatException e){
		    System.out.println("MDLView: Error extracting colour, using white");
		    colour = new java.awt.Color(255,255,255);
		}
		return colour;
	}


}
