/*
 * Copyright (c) 1999 Thomas Grey All Rights Reserved.
 *
 * Thomas Grey grants you ("Licensee") a non-exclusive, royalty
 * free, license to use, modify and redistribute this software in
 * source and binary code form, provided that the following conditions 
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * This software is provided "AS IS," without a warranty of any
 * kind. ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND
 * WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY
 * EXCLUDED.  THOMAS GREY AND HIS LICENSORS SHALL NOT BE LIABLE
 * FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
 * MODIFYING OR DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO
 * EVENT WILL THOMAS GREY OR HIS LICENSORS BE LIABLE FOR ANY
 * LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT, INDIRECT, SPECIAL,
 * CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER CAUSED AND
 * REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF OR
 * INABILITY TO USE SOFTWARE, EVEN IF THOMAS GREY HAS BEEN
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 *
 * This software is not designed or intended for use in on-line
 * control of aircraft, air traffic, aircraft navigation or aircraft
 * communications; or in the design, construction, operation or
 * maintenance of any nuclear facility. Licensee represents and
 * warrants that it will not use or redistribute the Software for such
 * purposes.  
 */

import java.awt.Dimension;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Image;
import java.awt.Graphics;
import java.lang.Thread;
//import java.awt.event.*;

public class MDLMovieThread implements Runnable{

	long startTime;
//	int delayTime = 100;
	int delays[];
	MDLMovie myMovie;
	int num_frames;
	boolean stopAni;
	Thread myThread;
	
	public MDLMovieThread(MDLMovie myM){
	    myMovie = myM;
	}

	public void setNumberOfFrames(int nf){
	    num_frames = nf;
	    delays = new int[num_frames];
	}
		
	public void addFrame(int fd, int framenumber){
	    delays[framenumber] = fd;
	}
	
	public void start(){
	    startTime = System.currentTimeMillis();
	    stopAni = false;
	    myThread = new Thread(this);
	    myThread.start();
	
    }
    
    public void stopAnimation(){
	stopAni = true;
    }
    
	public void run(){

//	    Thread myThread = this.currentThread();
		while(!stopAni){
			myThread.yield();
			myMovie.showNextFrame();
			try {
				startTime += delays[myMovie.getCurrentFrame()];
				Thread.sleep(Math.max(0,startTime-System.currentTimeMillis()));
			} catch (InterruptedException e) {
			    System.out.println("Interupted animation thread");
			}
		}
	}
	
	public static final String getAuthorInfo(){
	    return ("Copyright T.J.Grey 1998");
	}
	
	public void setDelay(int frame, int delay){
		delays[frame] = delay;			    		    	
	}	
   // End of class	
}
