/*
 * Copyright (c) 1999 Thomas Grey All Rights Reserved.
 *
 * Thomas Grey grants you ("Licensee") a non-exclusive, royalty
 * free, license to use, modify and redistribute this software in
 * source and binary code form, provided that the following conditions 
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * This software is provided "AS IS," without a warranty of any
 * kind. ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND
 * WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY
 * EXCLUDED.  THOMAS GREY AND HIS LICENSORS SHALL NOT BE LIABLE
 * FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
 * MODIFYING OR DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO
 * EVENT WILL THOMAS GREY OR HIS LICENSORS BE LIABLE FOR ANY
 * LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT, INDIRECT, SPECIAL,
 * CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER CAUSED AND
 * REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF OR
 * INABILITY TO USE SOFTWARE, EVEN IF THOMAS GREY HAS BEEN
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 *
 * This software is not designed or intended for use in on-line
 * control of aircraft, air traffic, aircraft navigation or aircraft
 * communications; or in the design, construction, operation or
 * maintenance of any nuclear facility. Licensee represents and
 * warrants that it will not use or redistribute the Software for such
 * purposes.  
 */

import java.awt.Event;
import java.awt.Dimension;
import java.awt.BorderLayout;
import java.awt.Graphics;
import java.awt.Color;
import java.awt.image.IndexColorModel;
import java.awt.Image;
import java.net.URL;
import java.net.MalformedURLException;
import java.io.InputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.awt.event.MouseEvent;
import java.util.StringTokenizer;
import java.awt.MediaTracker;

// public class MDLView extends java.applet.Applet implements MouseMotionListener{
public class MDLMovie extends java.applet.Applet implements MDLModelTracker, Runnable{

	MDLViewCanvas mdlViewCanvas;
	MDLMovieThread mdlMovieThread;
	static int Version = 103;
	URL codeBase;
	URL docBase;
	URL paletteURL;
	URL modelURL;
	MDLModel myModel;
	static final int MDL_VER = 6;
	String modelFileName;
	String palFileName;
	int movieType = 1;
	static final int movieRotate = 1;
	static final int movieAnimate = 2;
	Dimension d;
	String loadframes;
	String loadskins;
	boolean initialised = false;
	int shiftY = 0;
	boolean modelReady = false;
	boolean DEBUG;
	boolean noOut = false;
	String statusMessage = "Loading..";
	int w = 0;
	int h= 0;
	boolean isAnimated = true;
	Color bgColor;
	boolean haveBImage = false;
	boolean scaleBImage;
	Image bImage;
	Image[] frames;
	int num_frames;
	int currentFrame = 0;
	int delayTime = 100;
	boolean imageOk = false;
	int biw,bih,bix,biy,pcbx;

	public void init() {

		System.gc();
		imageOk = false;
		String suppressOut = getParameter("NOSTATUS");
		if (suppressOut != null){
		    suppressOut = suppressOut.toLowerCase();
		    noOut = suppressOut.startsWith("t");
		}
		debugOut("MDLMovie v"+Version/100+"."+Version%100+" by T.J.Grey (tjg1@ch.ic.ac.uk)");
		showStatus("MDLView: Initialising...");
		codeBase = getCodeBase();
	}

	public void start() {
		    codeBase = getCodeBase();
		    docBase = getDocumentBase();
	//	System.out.println("Start called");
		System.gc();
		System.gc();
		System.gc();
		Dimension d = this.size();
		w = d.width;
		h=d.height;
		if (!initialised){
	//	    removeAll();
// Initalise the canvas
		    if (getParameter("DEBUG") != null){
			DEBUG = true;
		    }else{
			DEBUG = false;
		    }
		    d = this.size();
		    showStatus("MDLMovie: Initialising canvas");
		    mdlMovieThread= new MDLMovieThread(this);
	//	    setLayout(new BorderLayout());
	//	    mdlMovieCanvas.setModelReady(false);
		    codeBase = getCodeBase();
		    docBase = getDocumentBase();
		    String bColour = getParameter("BCOLOUR");
		    if (bColour == null || bColour.length() != 7){
			System.out.println("MDLMovie: BCOLOUR not specified or specified incorrectly, using white for background");
			System.out.println("... usage eg <PARAM NAME=BCOLOUR VALUE=#FF00FF>");
			bColour = "#FFFFFF";
		    }
		    bgColor = getColourFromHex(bColour);
	//	    mdlMovieCanvas.setBackground(getColourFromHex(bColour));
//		    add("Center",mdlMovieCanvas);

// Background image
		    String bImageStr = getParameter("BIMAGE");
		    String bImageScaleStr = getParameter("SCALEBIMAGE");
		    if (bImageScaleStr == null){
			bImageScaleStr = "false";
		    }
		    if (bImageStr != null){
			MediaTracker BITracker = new MediaTracker(this);
			bImage = getImage(getDocumentBase(), bImageStr);
			BITracker.addImage(bImage, 0);
			showStatus("MDLView: Loading background");
			debugOut("MDLView: Loading background image as "+bImageStr);
			try {
                   //Start downloading the images. Wait until they're loaded.
			    BITracker.waitForAll();
			} catch (InterruptedException e) {}
			if (BITracker.checkAll() && !BITracker.isErrorAny()){
			    haveBImage = true;
			    biw = bImage.getWidth(this);
			    bih = bImage.getHeight(this);
			    bix = w - biw;
			    biy = h - bih;
			    bix /= 2;
			    biy /= 2;
			}else{
			    haveBImage = false;
			    System.out.println("MDLView: BIMAGE ignored- error getting image");
			    showStatus("MDLView: BIMAGE ignored- error getting image");
			}
			scaleBImage = false;
			String sc= getParameter("SCALEBIMAGE");
			if (sc != null){
			    sc = sc.toLowerCase();
			    if (sc.equals("true")){
				scaleBImage = true;
			    }else{
				scaleBImage = false;
			    }
			}
		//	    mdlMovieCanvas.setBackgroundImage(bImage, scale);
		//	    bImage = null;
		    }
		    showStatus("MDLMovie: Begining initialisation thread");
		    Thread initThread = new Thread(this,"MDLInitThread");
		    initThread.start();
		}else{
//		    mdlMovieThread= new MDLMovieThread(this);
		    mdlMovieThread.start();
		}
	    }
		    
	    public void run(){
		    String formatName = getParameter("FORMAT");
		    String className = "MDL"+formatName+"Model";
		    if(formatName == null){
			className = "MDLquakeModel";
		    }
		    showStatus("MDLMovie: Finding and loading model format: "+className);
		    try{
			debugOut("MDLMovie: Instancing model as "+className);
			showStatus("MDLMovie: Instancing model as "+className);
			Class modelClass = Class.forName(className);
			debugOut("MDLMovie: Model class created");
			showStatus("MDLMovie: Model class created");
			Object myModelInstance = modelClass.newInstance();
			showStatus("MDLMovie: Model class instanced");
			debugOut("MDLMovie: Model class instanced");
			myModel = (MDLModel) myModelInstance;
			debugOut("MDLMovie: Model class cast");
			showStatus("MDLMovie: Model class cast");
		    }catch (ClassNotFoundException e){
			System.out.println("MDLMovie: No class can be found which matches the FORMAT you specifed");
			throw new RuntimeException("MDLMovie: No class can be found which matches the FORMAT you specifed");
		    }catch (InstantiationException e){
			System.out.println("MDLMovie: Model class problem: Instancing exception: "+e);
			throw new RuntimeException("MDLMovie: Model class problem: Instancing exception");
		    }catch (IllegalAccessException e){
			System.out.println("MDLMovie: Model class problem: IllegalAccessException exception: "+e);			
			throw new RuntimeException("MDLMovie: Model class problem: IllegalAccessException exception");
		    }
		    myModel.setModelTracker(this);
		    d = this.size();
		    showStatus("MDLMovie: Initialising renderer");
		    mdlViewCanvas = new MDLViewCanvas(d, myModel, DEBUG);
//
		    String MType = getParameter("MOVIETYPE");
		    if (MType == null){
			MType = ("rotate");
		    }
		    MType = MType.toLowerCase();
		    if (MType.equals("animate")){
			movieType = movieAnimate;
		    }else{
			movieType = movieRotate;
		    }
//		System.out.println("MDLView: Codebase is "+codeBase);
	//Check for dreaded SHIFTY
		    String YShift = getParameter("SHIFTY");
//		    int shiftY;
		    if (YShift != null){
			try{
			    shiftY = (Integer.decode(YShift)).intValue();
			}catch(NumberFormatException e){
			    System.out.println("MDLMovie: Bad SHIFTY value: "+YShift);
			    shiftY = 0;
			}
		    }else{
			shiftY = 0;
		    }
		    String dTStr = getParameter("DELAYTIME");
		    if (dTStr != null){
			try{
			    delayTime = (Integer.decode(dTStr)).intValue();
			}catch(NumberFormatException e){
			    System.out.println("MDLMovie: Bad DELAYTIME value: "+dTStr);
			    delayTime = 100;
			}
		    }else{
			delayTime = 100;
		    }
//		    mdlMovieThread.setDelayTime
// Zoom
		    String zoomStr = getParameter("ZOOM");
		    float zoom =(float) 0.;
		    if (zoomStr != null){
			try{
			    zoom = (Double.valueOf(zoomStr)).floatValue();
//		    System.out.println("Zoom is "+zoom);
			}catch(NumberFormatException e){
			    System.out.println("MDLMovie: Bad ZOOM value: "+zoomStr);
			}
			mdlViewCanvas.setZoom(zoom);
		    }
// 'Y' Rot
		    String YRot = getParameter("YANGLE");
		    int Yang;
		    if (YRot != null){
			try{
			    Yang = (Integer.decode(YRot)).intValue();
			}catch(NumberFormatException e){
			    System.out.println("MDLMovie: Bad YANGLE value: "+YRot);
			    Yang = 0;
			}
		    }else{
			Yang = 0;
		    }
		    mdlViewCanvas.setZAngle(Yang);
// 'X' Rot
		    String XRot = getParameter("XANGLE");
		    int Xang;
		    if (XRot != null){
			try{
			    Xang = (Integer.decode(XRot)).intValue();
			}catch(NumberFormatException e){
			    System.out.println("MDLMovie: Bad XANGLE value: "+XRot);
			    Xang = 0;
			}
		    }else{
			Xang = 0;
		    }
		    mdlViewCanvas.setYAngle(Xang);
// Read in the Model
		    String modelTemp = getParameter("MODEL");
	//System.out.println("Model is :"+modelFileName);
		    if (modelFileName != modelTemp){
			if (modelTemp == null){
				System.out.println("MDLMovie: No model specified... please add to html...");
				System.out.println("          <PARAM NAME=MODEL VALUE=player.mdl>");
				showStatus("MDLMovie: !!Fatal!! No model to load");
				mdlViewCanvas.setMode("Error");
				throw new RuntimeException("MDLMovie: Can't run- no model specified in page");
			}else{
		//		System.out.println("MDLView: NEW MODEL");
				modelFileName = modelTemp;
			}
			modelReady = false;
		    }
		    mdlViewCanvas.setMode("texturemapped");	//Wireframe
//		    mdlViewCanvas.setForegroundColour(fColour);
//		    super.setForeground(getColourFromHex(fColour));
		    loadframes = getParameter("LOADFRAMES");
		    loadskins = getParameter("LOADSKINS");
		    if (movieType == movieRotate){
			if (myModel.getNumberOfFrames() >1){
			    System.out.println("MDLMovie: Bad load frames- only need ONE frame for rotation");
			    throw new RuntimeException("MDLMovie: Bad loadframes: More than one frame in a rotate movie");
			}			
		    }
	    // Animated movie
		    if (movieType == movieAnimate){
			if (myModel.getNumberOfFrames() > 100){
			    System.out.println("MDLMovie: Can't have more than 100 frames!");			
			    throw new RuntimeException("MDLMovie: Can't have more than 100 frames!");			
			}
		    }
		    getModel(docBase, modelFileName, loadframes, loadskins, shiftY);
		    mdlViewCanvas.setModel(myModel);
	}

	public void paint(Graphics g){
	    if (!imageOk){
		g.setColor(java.awt.Color.white);
		g.fillRect(0,0,w,h);
	    }
//	    super.paint(g);
	    update(g);
	}
	
	public void update(java.awt.Graphics g){
	    if (imageOk){
		g.drawImage(frames[currentFrame],0,0,this);
	    }else{
		g.setColor(java.awt.Color.white);
		g.fillRect(0,0,w,30);
		g.setColor(java.awt.Color.black);
		if (!noOut){
		    g.setColor(java.awt.Color.black);
		    g.drawString(statusMessage,10,20);
		    g.drawRect(2,22,w-4,5);
		    g.fillRect(2,22,pcbx,5);
		}else{
		    g.drawRect(2,2,w-4,5);
		    g.fillRect(2,2,pcbx,5);
		}
	    }
	}
	
	public void stop() {

	    if (myModel != null){
		myModel.stopCall();
	    }
	    mdlMovieThread.stopAnimation();
//	    mdlMovieThread = null;
	}
	
	public void showPercentage(int pc){
	   pcbx = (int)((float)pc/100.0*(float)(w-4));
	    update(this.getGraphics());
	}

	public void debugOut(String text){
	    if (DEBUG){
		System.out.println(text);
	    }
	}

	public String getAppletInfo() {
		return ("MDLMovie v"+Version/100+"."+Version%100+": An Applet by T.J.Grey to Display Model Files");
	}

	public String[][] getParameterInfo() {

		String[][] info = {
	// Parameter Name     Kind of Value   Description
			{"MODEL",	"relative URL",	"The URL of the mdl file relative to document base (ie the HTML page)"},
			{"MOVIETYPE",	"String",   "Type of movie: 'ROTATE' or 'ANIMATE'"},
			{"BCOLOUR",	"hex number",	"Colour of background eg #FFFFFF"},
//			{"FCOLOUR",	"hex number",	"Colour used for wireframe eg #000000"},
			{"PALETTE",	"relative URL",	"URL of Palette file, relative to codebase"},
//			{"COLOURMAP",	"relative URL",	"URL of colourmap file, relative to codebase"},
			{"LOADFRAMES",        "string",          "Number frames to load , then frame numbers IN ORDER, no spaces eg 4,0-3,5 (NB need only one frame for a ROTATE movie)"},
			{"LOADSKINS",        "string",          "Number skins to load, then skin numbers IN ORDER, no spaces eg 2,0,5"},
			{"DELAYTIME",     "int",          "Time between frames in milliseconds if < 100"},
			{"YANGLE",           "int",          "Start with model rotated by this about the vertical angle"},
			{"XANGLE",           "int",          "Start with model rotated by this about the left/right angle"},
			{"NOSTATUS",           "boolean",          "Suppress statusline messages"},
//
			{"ZOOM",          "float",         "Zoom level for model- use with care!"},
			{"SHIFTY",          "int",      "Shifts model vertically (use with care!)"},
			{"BIMAGE",       "relative URL",  "Image to be used as background"},
			{"SCALEBIMAGE",   "Boolean",  "Scale background image to fill background"},
			{"EXTRA",     "String",          "Extra info for model format- model format specific"},
			{"MOUSEOVER",      "String",          "Text to show when user moves mouse over applet"},
//			{"sounds",          "URLs",         "audio samples"},
		};
		return info;
	}    

	public int getCurrentFrame(){
	    return currentFrame;
	}

	public void modelReady(){
	
		showStatus("MDLMovie: Model read");
		debugOut("MDLMovie: Model read");
		String pFName = getParameter("PALETTE");
		String formatName= getParameter("FORMAT");
		IndexColorModel palette = null;
		if (pFName == null){
		    if (formatName == null){
			pFName = "quake.pal";
		    }else{
			pFName = formatName+".pal";
		    }
		}
		if (pFName.equals("INTERNAL")){
		    debugOut("MDLMovie: Internal palette!");
		    palette = myModel.getInternalPalette();
		    if (palette == null){
			System.out.println("MDLMovie: Model won't give me the internal palette :( ");
			throw new RuntimeException("MDLMovie: Model won't give me the internal palette :( ");
		    }
		}else{
		    if (pFName != palFileName){
			palette = readPalette(getCodeBase(), pFName);
			palFileName = pFName;
		    }
		}

// Initialise model settings in canvas
		mdlViewCanvas.setPalette(palette);
		mdlViewCanvas.modelReady();
		showStatus("MDLMovie: Generating animation");
		debugOut("MDLMovie: Generating animation");
// Ok what sort of movie are we producing?
		if (movieType == movieAnimate){
// Count actual number of single frames- as opposed to groups of frames in LOADFRAMES
		    num_frames = myModel.getNumberOfAnimationFrames(0,myModel.getNumberOfFrames()-1);
		    num_frames = Math.min(100, num_frames);
		    mdlMovieThread.setNumberOfFrames(num_frames);
		    frames = new Image[num_frames];
		    myModel.setCurrentFrameIndex(0);
//		    mdlMovieThread.setNumberOfFrames(num_frames);
		    currentFrame = -1;
		    while ( currentFrame < num_frames-1){
			imageOk = false;
			currentFrame++;
			showStatus("MDLMovie: Generating frame "+currentFrame+" of "+num_frames);
			debugOut("MDLMovie: Generating frame "+currentFrame+" of "+num_frames);
			addFrame(mdlViewCanvas.getImage(),myModel.getFrameDelayMillis());
			mdlMovieThread.addFrame(myModel.getFrameDelayMillis(),currentFrame);
			imageOk = true;
			update(this.getGraphics());
			myModel.nextFrame();
		    }
		}else{ // (movieType == movieRotate) we hope
		    num_frames=20;
		    mdlMovieThread.setNumberOfFrames(num_frames);
		    frames = new Image[num_frames];
		    currentFrame = -1;
		    while ( currentFrame < 19){
			showStatus("MDLMovie: Generating frame "+currentFrame);
			imageOk = false;
			currentFrame++;
			addFrame(mdlViewCanvas.getImage(),delayTime);
			mdlMovieThread.addFrame(delayTime,currentFrame);
			imageOk = true;
			update(this.getGraphics());
			mdlViewCanvas.rotateZ(18);
		    }
		}
//		add("Center", mdlMovieCanvas);
	//	mdlMovieCanvas.movieReady();
	//	mdlMovieCanvas.startAnimation();
		System.gc();
		System.gc();
		System.gc();
		System.gc();
		showStatus("MDLMovie: Starting movie");
		mdlViewCanvas = null;
		myModel = null;
		System.gc();
		System.gc();
		System.gc();
		System.gc();
		initialised = true;
		repaint();
		String text = getParameter("MOUSEOVER");
		if (text != null){
		    statusMessage = "MDLMovie: "+text;
		}else{
		    statusMessage = "MDLMovie running";
		}
//		mdlMovieThread= new MDLMovieThread(this);
		mdlMovieThread.start();
//		System.out.println("DONE!");
	}
	
	public void showStatus(String message){
	    if (!modelReady){
		statusMessage = message;
	    }
	    update(this.getGraphics());
	    if (!noOut){
		super.showStatus(statusMessage);
	    }
	}
	
	public final String getAuthorInfo(){
	    return "T.J.Grey (tjg1@ch.ic.ac.uk) Copyright 1998";
	}
	

	private IndexColorModel readPalette(URL codebase, String palFileName){
		IndexColorModel palette = null;
		try {
			paletteURL= new URL(codeBase, palFileName);
		} catch (MalformedURLException e){
			System.out.println("MDLMovie: Error in palette URL <"+e+">");
			showStatus("MDLMovie: Error in palette URL...");
			throw new RuntimeException("MDLMovie: Can't get palette");
		}
//		System.out.println("MDLView: Opening connection for palette as "+paletteURL);
		showStatus("MDLMovie: Opening connection for palette as "+paletteURL);
		try{
			InputStreamReader palStream = new InputStreamReader(paletteURL.openStream());
			StreamTokenizer palToken = new StreamTokenizer( palStream );
			palToken.eolIsSignificant(true);
// Skip two lines of header
			for (int x = 0; x < 2;){
				int tokenType = palToken.nextToken();
				if (tokenType == palToken.TT_EOL){
					x++;
//					System.out.println("lINE: "+x);
				}
			}

			palToken.nextToken();
			int numberOfColours = (int) palToken.nval;
			if (numberOfColours != 256){
				System.out.println("MDLMovie: !CARE!.. Pal says "+numberOfColours+" colours.. we use 255");
			}
			byte[] red = new byte[numberOfColours];
			byte[] green = new byte[numberOfColours];
			byte[] blue = new byte[numberOfColours];

			palToken.eolIsSignificant(false);

			for(int i=0; i < numberOfColours; i++){
				palToken.nextToken();
				red[i]=(byte)palToken.nval;
				palToken.nextToken();
				green[i]=(byte)palToken.nval;
				palToken.nextToken();
				blue[i]=(byte)palToken.nval;
			}
// Assume that FF is transaparent
			palette = new IndexColorModel(8,numberOfColours,red,green,blue,255);
			
			palStream.close();
		}catch(IOException e){
			System.out.println("MDLMovie: Error reading palette- <"+e+">");
			showStatus("MDLMovie: Error reading palette- <"+e+">");
			throw new RuntimeException("MDLMovie: Error getting palette");
		}
		return palette;
	}

//	void readColorMap(char *mapfile,unsigned char *cm){
//	FILE *in;
//	in=fopen(mapfile,"rb");

//	fread(cm,1,256*32,in);
//	fclose(in);

//}

	public String getExtraParameter(){
		return getParameter("EXTRA");
	}

	private int intFromFourBytes(byte[] intAsBytes){

/** Converts 4 UNSIGNED bytes to one integer **/

		int returnInt = 0;
		returnInt = returnInt | ( (intAsBytes[0] & 255) << 24);
		returnInt = returnInt | ( (intAsBytes[1] & 255) << 16);
		returnInt = returnInt | ( (intAsBytes[2] & 255) << 8);
		returnInt = returnInt | (intAsBytes[3] & 255);

		return returnInt;

	}

	private float floatFromFourBytes(byte[] floatAsBytes){

/** Converts four bytes into a float (uses intFromFourBytes) **/
		float returnFloat = 0;
		int asInt;
		
		asInt = intFromFourBytes(floatAsBytes);
		returnFloat = java.lang.Float.intBitsToFloat(asInt);

		return returnFloat;

	}

	private int readInt(InputStream stream) throws IOException{

		int i;
		byte[] fourBytes = new byte[4];
		for (i=0; i<4;i++){
			fourBytes[3-i]=(byte)stream.read();
		}
		return intFromFourBytes(fourBytes);
	}

	private float readFloat(InputStream stream) throws IOException{

		int i;
		byte[] fourBytes = new byte[4];
		for (i=0; i<4;i++){
			fourBytes[3-i]=(byte)stream.read();
		}
		return floatFromFourBytes(fourBytes);
	}

	public boolean mouseDown(Event e, int x, int y) {

	    if (!isAnimated){
		showStatus("MDLMovie: Starting movie...");
//		mdlMovieThread= new MDLMovieThread(this);
		mdlMovieThread.start();
		isAnimated = true;
	    }else{
		showStatus("MDLMovie: Stopping movie..");
		mdlMovieThread.stopAnimation();
//		mdlMovieThread = null;
		isAnimated = false;
	    }
	    return true;
	}
	
	private void addFrame(Image f, int fd){
//	    mdlMovieThread.setDelay(currentFrame,fd);
	    Image temp = this.createImage(w, h);
	    Graphics tg = temp.getGraphics();
	    tg.setColor(bgColor);
	    tg.fillRect(0,0,w,h);
	    if (haveBImage){
		if (scaleBImage){
		    tg.drawImage(bImage,0,0,w,h,this);
		}else{
		    tg.drawImage(bImage,bix,biy,biw,bih,this);
		}
	    }
	    tg.drawImage(f,0,0,this);
	    frames[currentFrame] = temp;
//	    currentFrame = framenumber;
//	    modelReady = true;
//	    update(this.getGraphics());
	}

	public void showNextFrame(){
	    currentFrame++;
	    currentFrame %= num_frames;
	    update(this.getGraphics());		
	}	    	

	
	public InputStream getStreamForFile(String filename){
		URL temp = null;
		try {
			temp= new URL(getDocumentBase(), filename);
		} catch (MalformedURLException e){
			System.out.println("MDLMovie: Error in requested URL <"+e+">");
			showStatus("MDLMovie: Error in requested URL...");
			throw new RuntimeException("MDLMovie: Error in requested URL");
		}
		InputStream IStream = null;
		try{
		    IStream = temp.openStream();
		}catch (IOException e){
		    System.out.println("MDLMovie: Error reading model-requested URL for "+filename+": "+e);
		    showStatus("MDLMovie: Error reading a model-requested URL for "+filename);
		    throw new RuntimeException("MDLMovie: Error reading URL");
		}
		return IStream;
	
	}


	public boolean mouseEnter(Event e, int x, int y){
		requestFocus();
		return false;
    	}
	
	public boolean mouseMove(Event e, int x, int y){
	    showStatus(statusMessage);
	    return true;
	}
	
	private void getModel(URL base, String filename, String loadframes, String loadskins, int shift){
		try {
//	System.out.println(base+" "+filename);
			modelURL= new URL(base, filename);
		} catch (MalformedURLException e){
			System.out.println("MDLMovie: Error in model URL <"+e+">");
			showStatus("MDLMovie: Error in model URL...");
			throw new RuntimeException("MDLMovie: Error in model URL");
		}
		myModel.readModel(docBase,codeBase, loadframes, loadskins, shift);
//		System.out.println("MDLView: Opening connection for model as "+modelURL);
		showStatus("MDLMovie: Opening connection for model as "+modelURL);

	}
	
	private Color getColourFromHex(String colourHex) throws NumberFormatException{

		int red;
		int green;
		int blue;
		String rdColour = "0x"+colourHex.substring(1,3);
		String gnColour = "0x"+colourHex.substring(3,5);
		String blColour = "0x"+colourHex.substring(5,7);
		red = (Integer.decode(rdColour)).intValue();
		green = (Integer.decode(gnColour)).intValue();
		blue = (Integer.decode(blColour)).intValue();
		return new Color(red,green,blue);
	}

}
