/*
 * Copyright (c) 1999 Thomas Grey All Rights Reserved.
 *
 * Thomas Grey grants you ("Licensee") a non-exclusive, royalty
 * free, license to use, modify and redistribute this software in
 * source and binary code form, provided that the following conditions 
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * This software is provided "AS IS," without a warranty of any
 * kind. ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND
 * WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY
 * EXCLUDED.  THOMAS GREY AND HIS LICENSORS SHALL NOT BE LIABLE
 * FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
 * MODIFYING OR DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO
 * EVENT WILL THOMAS GREY OR HIS LICENSORS BE LIABLE FOR ANY
 * LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT, INDIRECT, SPECIAL,
 * CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER CAUSED AND
 * REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF OR
 * INABILITY TO USE SOFTWARE, EVEN IF THOMAS GREY HAS BEEN
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 *
 * This software is not designed or intended for use in on-line
 * control of aircraft, air traffic, aircraft navigation or aircraft
 * communications; or in the design, construction, operation or
 * maintenance of any nuclear facility. Licensee represents and
 * warrants that it will not use or redistribute the Software for such
 * purposes.  
 */

import java.awt.Frame;
import java.awt.Button;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Event;
import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.Font;
import java.applet.AppletContext;

public class MDLHelpWindow extends Frame{

    static Button okBut;
    static Panel okPan;
    static Panel textPan;
    static Label padding2;
    static Label title;
    static Label title2;
    static Label title3;
    Label titleFormat;
    static Label line1;
    static Label line2;
    static Label line3;
    static Label line4;
    static Label line4a;
    static Label line5;
    static Label line6;
    static Label line7;
    static Label padding3;
    static Label line8;
    static Label line9;
    static Label line10;

    public MDLHelpWindow(int version, MDLModel myModel){
	super();
	title = new Label();
	textPan = new Panel();
	title.setFont(new Font("Helvetica", Font.PLAIN, 20));
	if (version%100 >= 10){
	    title.setText("MDLView v"+(version/100)+"."+(version%100));
	}else{
	    title.setText("MDLView v"+(version/100)+".0"+(version%100));
	}
	title2 = new Label("Copyright: T.J.Grey 1998");
	title3 = new Label("(tjg1@ch.ic.ac.uk)");
	int formatVersion = myModel.getVersion();
	if (formatVersion%100>=10){
	    titleFormat = new Label("Format class for "+myModel.getModelFormat()+" models [v"+(formatVersion/100)+"."+(formatVersion%100)+"] by "+myModel.getAuthorName());
	}else{
	    titleFormat = new Label("Format class for "+myModel.getModelFormat()+" models [v"+(formatVersion/100)+".0"+(formatVersion%100)+"] by "+myModel.getAuthorName());	
	}
	textPan.setLayout(new GridLayout(0,1));
	padding2 = new Label();
	line6 = new Label("General:");
	line1 = new Label("Dragging the mouse will rotate the model. If the 'z' key is held down while");
        line2 = new Label("the mouse is dragged then the model will zoom in/out.");
	line7 = new Label("Other keys:");
	line3 = new Label("?: Bring up this window!          Tab: Toggle between wireframe/texture mapped");
	line4 = new Label("c: Toggle model animation         r: Toggle model rotation");
	line4a= new Label("m: Information overlay            a: Toggle change to wireframe for free-rotate");
	line5 = new Label("Up/Down Arrow: Last/next skin     Left/Right Arrow:   Last/next animation frame");
	padding3 = new Label();
	line8 = new Label("Many thanks to Brian Martin for the MedDLe source code and to Olivier Montanuy");
	line9 = new Label("for 'The Most Unofficial Quake Technical Specification'.");
	line10= new Label("Both the above proved very useful sources of technical information.");
	setTitle("MDLView help");
	setLayout(new BorderLayout());
	okBut = new Button("Dismiss");
	okPan = new Panel();
	okPan.add(okBut);
	add("Center",textPan);
	textPan.add(title);
	textPan.add(title2);
	textPan.add(title3);
	textPan.add(titleFormat);
	textPan.add(padding2);
	textPan.add(line6);
	textPan.add(line1);
	textPan.add(line2);
	textPan.add(line7);
	textPan.add(line3);
	textPan.add(line4);
	textPan.add(line4a);
	textPan.add(line5);
	textPan.add(padding3);
	textPan.add(line8);
	textPan.add(line9);
	textPan.add(line10);
	add("South",okPan);
	pack();
    }

    public boolean action(Event e, Object arg){
	if(e.target instanceof Button){
	    this.hide();
	    return true;
	}
        return false;
    }
       
}
