/*
 * Copyright (c) 1999 Thomas Grey All Rights Reserved.
 *
 * Thomas Grey grants you ("Licensee") a non-exclusive, royalty
 * free, license to use, modify and redistribute this software in
 * source and binary code form, provided that the following conditions 
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * This software is provided "AS IS," without a warranty of any
 * kind. ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND
 * WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY
 * EXCLUDED.  THOMAS GREY AND HIS LICENSORS SHALL NOT BE LIABLE
 * FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
 * MODIFYING OR DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO
 * EVENT WILL THOMAS GREY OR HIS LICENSORS BE LIABLE FOR ANY
 * LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT, INDIRECT, SPECIAL,
 * CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER CAUSED AND
 * REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF OR
 * INABILITY TO USE SOFTWARE, EVEN IF THOMAS GREY HAS BEEN
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 *
 * This software is not designed or intended for use in on-line
 * control of aircraft, air traffic, aircraft navigation or aircraft
 * communications; or in the design, construction, operation or
 * maintenance of any nuclear facility. Licensee represents and
 * warrants that it will not use or redistribute the Software for such
 * purposes.  
 */

/* This code is currently not working correctly for most 3ds models*/

/*Add code to disgard an object listed as an extra param- replace existing hasrd coded values.
*/

import java.net.URL;
import java.net.MalformedURLException;
import java.io.InputStream;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipEntry;

public final class MDL3dsModel extends MDLModel{

    private int version = 1;
    private int filepos;
    private int i;
    private String disgards[];
    private int num_disgards;
//    private int skinw;
 //   private int skinh;
  //  private int totalSkins;
//    private int frameSizeBytes;
//    private int num_skins;
    private int num_vertices;
//    private int num_st_vertices;
    private int num_triangles;
    private MDLTrisList frame_tris[];
    private int max_num_tris;
//    private int num_gl_cmds;
    private int num_Objects;
 //   private int totalFrames;
    private float radius;
    
//    private MDLSkinVertex[] sVerts;
//    private short[] sVertsS;
 //   private short[] sVertsT;
    private short[][] tris;
  //  private short[][] stTris;
   // private byte[][][] skins;
    
    private MDLSimpleFrame[] frames;
    private MDLSimpleFrame compositeFrame;
 //   private byte[][] cSkin;
/*
    public String weaponName;
    public int weaponSkinw;
    public int weaponSkinh;
    public int weaponFrameSizeBytes;
    public int weaponNum_skins;
    public int weaponNum_vertices;
    public int weaponNum_st_vertices;
    public int weaponNum_triangles;
    public int weaponNum_gl_cmds;
    public int weaponNum_frames;
    public int weaponTotalFrames;
    
    public short[] weaponSVertsS;
    public short[] weaponSVertsT;
    public short[][] weaponTris;
    public short[][] weaponStTris;
    public MDLSimpleFrame[] weaponFrames;
    public byte[][] weaponSkin;
 */   
    private int currentFrame = 0;
    private int currentSkin = 0;
  //  private boolean haveWeapon = false;
   // private boolean loadWeapon = false;
    private int max_vertices;
   // private int max_triangles;
    //private int max_skinh;
    private int shift;
    
    private int percentageDone;
    private int percentagePerFile = 1;
    
    private int[] loadframes;
    private boolean haveWepSkin = false;
    private int loadingSkin;
    private int skinsSeen;
    private int[] loadskins;
    
    private boolean specialWepSkin = false;
	    
	public int getVersion(){
	    return version;
	}
	
	public short getTriangleVertexIndex(int triangle, int vertex){
//	    if (!haveWeapon){
		return tris[triangle][vertex];
//	    }else{
//		if (triangle < num_triangles){
//		    return tris[triangle][vertex];
//		}else{
//		    i = triangle - num_triangles;
//		    if (currentFrame < weaponNum_frames){
//			return weaponTris[i][vertex];
//		    }else{
//			return tris[0][vertex];
//		    }
//		}
//	    }
	}
	
	public short getSkinVertexT(int triangle, int vertexIndex){
	    return (short)0;
	}
	
	public short getSkinVertexS(int triangle, int vertexIndex){
	    return (short)0;
	}
    	
	public void setCurrentSkinIndex(int skin){
	    currentSkin = skin;
	}
	
	public int getCurrentSkinIndex(){
	    return currentSkin;
	}
		
	public int getCurrentFrameIndex(){
	    return currentFrame;
	}
	
	public void setCurrentFrameIndex(int fi){
	    currentFrame = fi;
	}
	
	public int getNumberOfAnimationFrames(int start, int finish){
		return 1;//(finish-start+1);
	}
	
	public int getFrameDelayMillis(){
	    return 100;
	}	    
		
	public void nextSkin(){
/*	    currentSkin++;
	    currentSkin %= num_skins;
	    cSkin = skins[currentSkin];*/
	}
	
	public void lastSkin(){
	/*    currentSkin--;
	    if (currentSkin <0){
		currentSkin = num_skins -1;
	    }
	    cSkin = skins[currentSkin]; */
	}
	
	public void lastFrame(){
/*	    currentFrame--;
	    if (currentFrame <0){
		currentFrame = num_frames -1;
	    }*/
	    
	}

	public void nextFrame(){
/*	    currentFrame++;
	    currentFrame %= num_frames;
    */
	}
	
	public byte getTexel(short x, short y){
	    return (byte)0;
//	    if (!haveWeapon){
//		return cSkin[x][y];
//	    }else if (y > -1 && y < skinh){
//		return cSkin[x][y];
//	    }else{
//		i = y - skinh;
//		if(!specialWepSkin){
//		    return weaponSkin[x][i];
//		}else{
//		    return cSkin[x][i];
//		}
//	    }
	}
	
	public int getTotalFrames(){
	    return 1;//totalFrames;
	}
	
	public int getTotalSkins(){
	    return 0;//totalSkins;
	}
		
	public String getFrameName(){
	    return "noName";// frames[currentFrame].name;
	}
	
	public float getBoundingRadius(){
	    return radius;
	}
	
	public int getNumberOfSkins(){
	    return 0;//num_skins;
	}
	
	public int getSkinWidth(){
	    return 1;//skinw;
	}
	
	public int getSkinHeight(){
	    return 1;//skinh;
	}
	

	public float getVertexX(int vertex){
//	    if (!haveWeapon){
		return -compositeFrame.frameVertsZ[vertex];
/*	    }else{
		if (vertex < num_vertices){
		    return frames[currentFrame].frameVertsX[vertex];
		}else{
		    i = vertex - num_vertices;
		    if (currentFrame < weaponNum_frames){
			return weaponFrames[currentFrame].frameVertsX[i];
		    }else{
			return frames[currentFrame].frameVertsX[0];
		    }
		}
	    }*/
	}
	
	public float getVertexY(int vertex){
//	    if (!haveWeapon){
		return compositeFrame.frameVertsX[vertex];
	/*    }else{
		if (vertex < num_vertices){
		    return frames[currentFrame].frameVertsY[vertex];
		}else{
		    i = vertex - num_vertices;
		    if (currentFrame < weaponNum_frames){
			return weaponFrames[currentFrame].frameVertsY[i];
		    }else{
			return frames[currentFrame].frameVertsY[0];
		    }
		}
	    }*/
	}
	
	public float getVertexZ(int vertex){
//	    if (!haveWeapon){
		return compositeFrame.frameVertsY[vertex];
	/*    }else{
		if (vertex < num_vertices){
		    return frames[currentFrame].frameVertsZ[vertex];
		}else{
		    i = vertex - num_vertices;
		    if (currentFrame < weaponNum_frames){
			return weaponFrames[currentFrame].frameVertsZ[i];
		    }else{
			return frames[currentFrame].frameVertsZ[0];
		    }
		}
	    }*/
	}
	
	public boolean getClockwiseCull(){
	    return true;
	}
	
	public int getNumberOfVertices(){
//	    if (haveWeapon){
//		return max_vertices;
//	    }else{
		return num_vertices;
//	    }
	}
	
	public int getNumberOfTriangles(){
//	    if (haveWeapon){
//		return max_triangles;
//	    }else{
		return num_triangles;
//	    }
	}
	
	public int getNumberOfFrames(){
	    return 1;//num_frames;
	}
	
	public String getModelFormat(){
	    return "3ds";
	}

	public String getAuthorInfo(){
	    return "Copyright T.J.Grey 1999";
	}
	
	public String getAuthorName(){
	    return "Tom Grey";
	}
	
	private void loadExtraInfo(){
	    disgards = getExtraInfo();
	    if (disgards != null){
//		showStatus(disgards[0]);
		num_disgards = disgards.length;
	    }else{
		num_disgards = 0;
	    }
		return;
	}

	
	protected void readModelThread(int[] loadf, int[] loads, int shifty){
	    
	    showStatus("MDL3dsModel: 3ds model format class copyright T.J.Grey 1998");
	    loadExtraInfo();
	    radius = 0;
	    String modelName = getParameter("MODEL");
	    String modelNameLC = modelName.toLowerCase();
	    if (modelName.startsWith("!*!")){
		modelName = modelName.substring(3);
		//readInfoModel(modelName, false);
	    }else if (modelNameLC.endsWith(".zip")){
		readSingleZip(modelName);
	    }else{
		error("Unknown model specifier- should be either .zip or .txt");
	    }
    // Calculate the bounding radius
	    calculateRadius();
    // Ensure get 100% at end!
	    showPercentage(100);
	    System.gc();
	    System.gc();

	}
	private void readSingleZip(String modelFilename){
//	    int pcFromEntries = 0;
	    try{
		showStatus("MDL3dsModel: Opening connection for zipped 3ds model..");
		ZipEntry cfile; //current zip entry
		String cname = null; //name of current zip entry file
		ZipInputStream zipModelStream = new ZipInputStream(new BufferedInputStream(getStreamForFile(modelFilename)) );
		cfile = zipModelStream.getNextEntry();
		if (cfile == null){
		    error("Error, zipfile is empty or corrupt!");
		}
		cname = cfile.getName();
		cname = cname.toLowerCase();
		showStatus("MDLquake2Model: Current file is "+cname);
//		if (!cname.endsWith(".3ds")){
//		    error("Sorry but file does not appear to be a 3ds file");
//		}
		read3ds(zipModelStream, shift);
	//Since we now have this
//	        skins = new byte[num_skins][skinw][skinh];//MDLSkinGroup[num_skins];
	//	pcFromEntries += percentagePerFile;
	//	percentageDone = pcFromEntries;
	//	showPercentage(percentageDone);
	//	cfile = zipModelStream.getNextEntry();
	//	boolean keepReading = true;
	//	if (cfile == null){
	//	    keepReading = false;
	//	}
    // Read the other gubbings
	//	while(keepReading){
	//	    if (readEntry(cfile, zipModelStream)){
	//		pcFromEntries += percentagePerFile;
	//		percentageDone = pcFromEntries;
	//		showPercentage(percentageDone);
	//	    }
	//	    cfile = zipModelStream.getNextEntry();
	    // Only read on if this was not last entry and don't have all the bits!
		//    keepReading = ( (cfile!=null));// && !( haveWeapon&&haveWepSkin ) );
		//}
		showStatus("MDLquake2Model: Reading model... done... Closing data stream");
		zipModelStream.closeEntry();
		zipModelStream.close();
		showStatus("MDLquake2Model: Data stream closed ok");
		zipModelStream = null;
	    }catch(IOException e){
		error("Error opening data Stream for model- <"+e+">");
	    }
	    return;
	}

	private void calculateRadius(){
	    radius = (float) Math.sqrt(radius);
	    radius *= 2;
	    showStatus("MDLquake2Model: Radius calculated as "+radius);
	}

	private void read3ds(InputStream zipModelStream, int shift) throws IOException{
	    showStatus("MDL3dsModel: Preparing to read 3ds file");
	    showStatus("MDL3dsModel: Seeking main chunk");
// Get filetype= 4D4D (= 77,77) for us
	    int superlength = seekChunk(zipModelStream,(byte)0x4D,(byte)0x4D,"Main",10000000)[0];
	    if (superlength == -1){
		error("MDL3dsModel: Primary chunk not found");
	    }
	    checkNeg(true,superlength,"Main chunk length");
// Find editor sub-chunk
	    showStatus("MDL3dsModel: Seeking editor sub-chunk");
	    superlength = seekChunk(zipModelStream,(byte)0x3D,(byte)0x3D,"Editor",superlength)[0];
	    if (superlength == -1){
		error("MDL3dsModel: Editor sub-chunk not found");
	    }
	    checkNeg(true,superlength,"Editor sub-chunk length");
// Set aside upto MAXFRAMES for objects
	    frames = new MDLSimpleFrame[100];
	    frame_tris = new MDLTrisList[100];
	    max_num_tris = 0;
// Find the object chunk
	    num_Objects = 0;
	    max_vertices = 0;
	    int edLength = superlength;
	    float bytesPerPc = edLength/100;
	    int startLength = edLength;
	    int[] rlength = new int[2];
	    int pc = 0;
	    
	    showStatus("MDL3dsModel: Seeking object sub-chunk");
	    rlength = seekChunk(zipModelStream,(byte)0x40,(byte)0x00,"Object",edLength);
	    boolean notDone = true;
	    if (rlength[0] != -1){
		edLength -= rlength[1];
	    }else{
		notDone = false;
	    }
	    while (notDone){
		readObjectChunk(zipModelStream, rlength[0], num_Objects);
		edLength -= rlength[0];
		showStatus("MDL3dsModel: Seeking object sub-chunk");
		rlength = seekChunk(zipModelStream,(byte)0x40,(byte)0x00,"Object",edLength);
		if (rlength[0] != -1){
		    edLength -= rlength[1];
		}else{
		    notDone = false;
		}
		pc = (int)( (float)(startLength-edLength)/bytesPerPc );
		System.out.println(edLength);
		showPercentage(pc);
//		if (num_Objects >= 20){
//		    notDone = false;
//		}
	    }
	    showStatus("MDL3dsModel: Compositing the "+num_Objects+" objects found together...");
	    compositeObjects();
	    showPercentage(100);
	}

	private void readObjectChunk(InputStream zipModelStream, int superlength, int objectNo) throws IOException{
// Read the object name
	    byte[] twoFiveSix = new byte[256];
	    int j = 0;
	    byte last = (byte)zipModelStream.read();
	    while (last != 0 && j < 256){
	        twoFiveSix[j]=last;
	        last = (byte)zipModelStream.read();
	        j++;
	    }
	    String objectName = new String(twoFiveSix,0,j);
	    showStatus("MDL3dsModel: ** Object "+objectNo+" name is '"+objectName+"' **");
	    System.out.println("MDL3dsModel: ** Object "+objectNo+" name is '"+objectName+"' **");
// Find the mesh chunk
	    showStatus("MDL3dsModel: Seeking mesh sub-chunk");
	    superlength = seekChunk(zipModelStream,(byte)0x41,(byte)0x00,"Mesh",superlength)[0];
	    if (superlength == -1){
		showStatus("MDL3dsModel: Object is not as mesh");
		return;
	    }else{
		for (int dg = 0; dg<num_disgards;dg++){
		    if (objectName.equals(disgards[dg])){
			showStatus("MDL3dsModel: Disgarding object");
			return;
		    }
		}
	    } 
	    num_Objects++;
	    if (num_Objects > 100){
		error("MDL3dsModel: The number of objects exceeded the current limit of 100");
	    }
	    checkNeg(true,superlength,"mesh sub-chunk length");
	    showStatus("MDL3dsModel: Mesh found, switching for subchunks");
// Prepare arrays for local axis mapping
	    float[] local = new float[12];
// Need to look at each chunk and switch
	    int bytesSeen = 6;
	    while (bytesSeen < superlength){
		byte upper = (byte)zipModelStream.read();
		byte lower = (byte)zipModelStream.read();
		int length = readInt(zipModelStream);
//		showStatus(""+lower+":"+upper);
		length -= 6;
		bytesSeen += 6;
		if (lower != 0x41){
		    error("MDL3dsModel: Bad id read in mesh (not 0x41)- this is probably a bug in this applet!");
		}
//4110     Vertex List
 //4111     Vertex Options
 //4120     Face List
// 4130     Face Material
// 4140     Mapping Coordinates
// 4150     Face smoothing group
// 4160     Translation Matrix
// 4165     Object visible/invisble
// 4170     Standard Mapping
		if (upper == 0x10){
		    showStatus("MDL3dsModel: Reading vertex list");
		    int readBytes = readVertexList(zipModelStream,objectNo);
		    dodgySkip((length-readBytes),zipModelStream);
		    frames[objectNo].name = objectName;
		    bytesSeen += length;
		}else if (upper == 0x11){
		    showStatus("MDL3dsModel: Skipping vertex options");
		    dodgySkip(length,zipModelStream);
		    bytesSeen += length;
		}else if (upper == 0x20){
		    showStatus("MDL3dsModel: Reading face list");	
		    int readBytes = readFaceList(zipModelStream,objectNo);
		    dodgySkip((length-readBytes),zipModelStream);
		    bytesSeen += length;
		}else if (upper == 0x30){
		    showStatus("MDL3dsModel: Skipping face material");
		    dodgySkip(length,zipModelStream);
		    bytesSeen += length;
		}else if (upper == 0x40){
		    showStatus("MDL3dsModel: Skipping mapping coords");		
		    dodgySkip(length,zipModelStream);
		    bytesSeen += length;
		}else if (upper == 0x50){
		    showStatus("MDL3dsModel: Skipping face smoothing group");	
		    dodgySkip(length,zipModelStream);
		    bytesSeen += length;
		}else if (upper == 0x60){
		    showStatus("MDL3dsModel: Reading translation matrix");
		    int readBytes = readLocalAxis(zipModelStream,local);
		    dodgySkip((length-readBytes),zipModelStream);
		    bytesSeen += length;
		}else if (upper == 0x65){
		    showStatus("MDL3dsModel: Skipping object visibity");
		    dodgySkip(length,zipModelStream);
		    bytesSeen += length;
		}else if (upper == 0x70){
		    showStatus("MDL3dsModel: Skipping standard mapping");		
		    dodgySkip(length,zipModelStream);
		    bytesSeen += length;
		}else{
		    showStatus("MDL3dsModel: Skipping unknown mesh-chunk id: "+lower+":"+upper);
		    dodgySkip(length,zipModelStream);
		    bytesSeen += length;
		}
	    }
	// Apply mapping to local axis
	    float oldX;
	    float oldY;
	    float oldZ;
	/*    for (i = 0; i < num_vertices; i++){
		oldX = frames[objectNo].frameVertsX[i];
		oldY = frames[objectNo].frameVertsY[i];
		oldZ = frames[objectNo].frameVertsZ[i];
		frames[objectNo].frameVertsX[i] = oldX*local[0] + oldY*local[1] + oldZ*local[2];
		frames[objectNo].frameVertsY[i] = oldX*local[3] + oldY*local[4] + oldZ*local[5];
		frames[objectNo].frameVertsZ[i] = oldX*local[6] + oldY*local[7] + oldZ*local[8];
		frames[objectNo].frameVertsX[i] += local[9];
		frames[objectNo].frameVertsX[i] += local[10];
		frames[objectNo].frameVertsX[i] += local[11];
	    }
	  */  
	}

	private int readVertexList(InputStream modelStream, int fnumber) throws IOException {
	    float temp = 0;
	    num_vertices = this.readShort(modelStream);
	    max_vertices += num_vertices;
	    checkNeg(true,num_vertices,"Number of vertices in object");
//	    frames = new MDLSimpleFrame[1];
	    frames[fnumber] = new MDLSimpleFrame(num_vertices);
	    for (int i = 0; i<num_vertices; i++){
		frames[fnumber].frameVertsX[i] = readFloat(modelStream);
		frames[fnumber].frameVertsY[i] = readFloat(modelStream)+shift;
		frames[fnumber].frameVertsZ[i] = readFloat(modelStream);
	    }
	    return(2+(12*num_vertices));
	}
	
	private int readLocalAxis(InputStream modelStream, float[] local) throws IOException {
	    for (int i = 0; i<12;i++){
		local[i] = readFloat(modelStream);
	    }
	    return 48;
	}
	
	private int readFaceList(InputStream modelStream, int oNum) throws IOException {
	    num_triangles = this.readShort(modelStream);
	    max_num_tris += num_triangles;
	    checkNeg(true,num_triangles,"Number of triangles in object");
	    checkShort(num_triangles,"Number of triangles in object");
	    frame_tris[oNum] = new MDLTrisList(num_triangles);
//	    int t = max_num_tris;
	    for (int i = 0; i<num_triangles; i++){
		frame_tris[oNum].tris[i][0] = (short)readShort(modelStream);
		frame_tris[oNum].tris[i][1] = (short)readShort(modelStream);
		frame_tris[oNum].tris[i][2] = (short)readShort(modelStream);
		dodgySkip(2,modelStream);
	    }
	    return(2+(8*num_triangles));
	}
	
	private void skipTill(int position, InputStream dataStream) throws IOException{
	    int i = position - filepos;
	    if (i < 0){
		error("Unable to skip- file has advanced beyond requested position");
	    }
	    if (i == 0){
		return;
	    }
	    while (filepos < position){
		dataStream.read();
		filepos++;
		yield();
	    }
	}
// DANGER: ignores filepos.. do not use unless advancing filepos elsewhere	
	private void dodgySkip(int nb, InputStream dataStream) throws IOException{
	    while (nb > 0){
		dataStream.read();
		nb--;
	    }
	}
	
	private void compositeObjects(){
	    compositeFrame = new MDLSimpleFrame(max_vertices);
	    tris = new short[max_num_tris][3];
//	    int currentV = 0;
	    int baseTris = 0;
	    int baseVert = 0;
	    float temp;
	    radius = 0;
	    for (i=0; i<num_Objects; i++){
		showStatus("MDL3dsModel: Adding "+frames[i].name);
		for (int v=0; v<frames[i].num_Verts;v++){
//		System.out.println("frames[i].frameVertsX.length= "+frames[i].frameVertsX.length);
		    compositeFrame.frameVertsX[baseVert+v] = frames[i].frameVertsX[v];
		    compositeFrame.frameVertsY[baseVert+v] = frames[i].frameVertsY[v];
		    compositeFrame.frameVertsZ[baseVert+v] = frames[i].frameVertsZ[v];
		    temp = compositeFrame.frameVertsX[baseVert+v]*compositeFrame.frameVertsX[baseVert+v];
		    temp += compositeFrame.frameVertsY[baseVert+v]*compositeFrame.frameVertsY[baseVert+v];
		    temp += compositeFrame.frameVertsZ[baseVert+v]*compositeFrame.frameVertsZ[baseVert+v];
		    radius = Math.max(temp,radius);
//		    currentV++;
		}
		for (int t = 0; t < frame_tris[i].num_tris; t++){
		    tris[baseTris+t][0] = (short)(frame_tris[i].tris[t][0] + baseVert);
		    tris[baseTris+t][1] = (short)(frame_tris[i].tris[t][1] + baseVert);
		    tris[baseTris+t][2] = (short)(frame_tris[i].tris[t][2] + baseVert);		
		}
		baseTris += frame_tris[i].num_tris;
		baseVert += frames[i].num_Verts;
		frames[i] = null;
		frame_tris[i] = null;
	    }
	    num_vertices = baseVert;
	    num_triangles = baseTris;
	    frames = null;
	    frame_tris = null;
	    System.gc();
	    System.gc();
	    System.gc();
	}
	
	private final short readShort(InputStream dataStream) throws IOException{

	    byte[] twoBytes = new byte[2];
	    twoBytes[1]=(byte)dataStream.read();
	    twoBytes[0]=(byte)dataStream.read();
	    short returnShort = 0;
	    returnShort = (short)(returnShort | ( (twoBytes[0] & 255) << 8) );
	    returnShort = (short)(returnShort | (twoBytes[1] & 255) );
	    return returnShort;
	}
	
	public java.awt.image.IndexColorModel getInternalPalette(){
	    return null;
	}
	
	private void error(String errorMsg){
	    showStatus("MDLquake2Model "+errorMsg);
	    System.out.println("MDLquake2Model "+errorMsg);
	    throw new RuntimeException("MDLquake2Model "+errorMsg);
	}

	private int[] seekChunk(InputStream is, byte u, byte l, String chunkName, int scope) throws IOException{
//	    showStatus("MDL3dsModel: Seeking "+chunkName+" subchunk");
	    byte lower = (byte)is.read();
	    byte upper = (byte)is.read();
	    int length = this.readInt(is);
//	    showStatus("ID: "+lower+""+upper+" length: "+length);
	    int[] rVals = new int[2];
	    filepos = 0;
	//    int seen = 0;
	    while (lower != l || upper != u){
		dodgySkip((length-6),is);
		filepos += length;
//	    System.out.println("filepos in seek: "+filepos+" scope: "+scope);
		if (filepos >= scope){
		    rVals[0] = -1;
		    rVals[1] = filepos;
		    return rVals;
		}
		lower = (byte)is.read();
		upper = (byte)is.read();
		length = this.readInt(is);
	//    showStatus("ID: "+lower+":"+upper+" length: "+length);
	    }
	    rVals[0] = length;
	    rVals[1] = filepos +6;
	    return rVals;
	}

}