//=============================================================================
// TZoneTrigger.
//
// OpenMod is licensed under the terms of the GNU Library General Public
// License.  More information on OpenMod and the terms of its license may
// be found in it's readme file, located in this game's "SYSTEM" directory.
//=============================================================================
class TZoneTrigger expands TTrigger;

//
// Called when something touches the trigger.
//
function Touch( actor Other )
{
	local ZoneInfo Z;
	local bool bTeamRelevant;
	
	bTeamRelevant = false;
	if ((Team == pawn(Other).PlayerReplicationInfo.team) || !(Level.Game.bTeamGame) || (pawn(other) == none))
	  bTeamRelevant = true;
	  
	if( IsRelevant( Other ) && bTeamRelevant )
	{	
		// Broadcast the Trigger message to all matching actors.
		if( Event != '' )
			foreach AllActors( class 'ZoneInfo', Z )
				if ( Z.ZoneTag == Event )
					Z.Trigger( Other, Other.Instigator );

		if( Message != "" )
			// Send a string message to the toucher.
			Other.Instigator.ClientMessage( Message );

		if( bTriggerOnceOnly )
			// Ignore future touches.
			SetCollision(False);
	}
}

//
// When something untouches the trigger.
//
function UnTouch( actor Other )
{
	local ZoneInfo Z;
	local bool bTeamRelevant;
	
	bTeamRelevant = false;
	if ((Team == pawn(Other).PlayerReplicationInfo.team) || (pawn(other) == none))
	  bTeamRelevant = true;
	  
	if( IsRelevant( Other ) && bTeamRelevant )
	{
		// Untrigger all matching actors.
		if( Event != '' )
			foreach AllActors( class 'ZoneInfo', Z )
				if ( Z.ZoneTag == Event )
					Z.UnTrigger( Other, Other.Instigator );
	}
}

defaultproperties
{
}
