//=============================================================================
// TTrigger.
//
// OpenMod is licensed under the terms of the GNU Library General Public
// License.  More information on OpenMod and the terms of its license may
// be found in it's readme file, located in this game's "SYSTEM" directory.
//=============================================================================
class TTrigger expands Trigger;

var(Team) int Team;


//
// Called when something touches the trigger.
//
function Touch( actor Other )
{
	local actor A;
	local bool bTeamRelevant;
	
	bTeamRelevant = false;
	if ( (Team == pawn(Other).PlayerReplicationInfo.team) || !(Level.Game.bTeamGame) || (pawn(other) == none))
	  bTeamRelevant = true;
	  
	if( IsRelevant( Other ) && bTeamRelevant )
	{
		if ( ReTriggerDelay > 0 )
		{
			if ( Level.TimeSeconds - TriggerTime < ReTriggerDelay )
				return;
			TriggerTime = Level.TimeSeconds;
		}
		// Broadcast the Trigger message to all matching actors.
		if( Event != '' )
			foreach AllActors( class 'Actor', A, Event )
				A.Trigger( Other, Other.Instigator );

		if ( Other.IsA('Pawn') && (Pawn(Other).SpecialGoal == self) )
			Pawn(Other).SpecialGoal = None;
				
		if( Message != "" )
			// Send a string message to the toucher.
			Other.Instigator.ClientMessage( Message );

		if( bTriggerOnceOnly )
			// Ignore future touches.
			SetCollision(False);
		else if ( RepeatTriggerTime > 0 )
			SetTimer(RepeatTriggerTime, false);
	}
}

function Timer()
{
	local bool bKeepTiming;
	local byte bTeamRelevant[4];
	local int i;
	
	for (i=0;i<4;i++)
		bTeamRelevant[i] = byte(false);
	
	// if the touching Actor is not a Pawn subclass
	// then it is relevent in that it can be
	// checked by the IsRelevent() function later
	for (i=0;i<4;i++)
	  if (Touching[i] != none)
		if ( (Team == pawn(Touching[i]).PlayerReplicationInfo.team) || (pawn(Touching[i]) == none) )
		  bTeamRelevant[i] = byte(true);
		else
		  bTeamRelevant[i] = byte(false);
	
	bKeepTiming = false;

	for (i=0;i<4;i++)
		if ( (Touching[i] != None) && IsRelevant(Touching[i]) && bool(bTeamRelevant[i]))
		{
			bKeepTiming = true;
			Touch(Touching[i]);
		}

	if ( bKeepTiming )
		SetTimer(RepeatTriggerTime, false);
}


//
// When something untouches the trigger.
//
function UnTouch( actor Other )
{
	local bool bTeamRelevant;
	local actor A;
	
	bTeamRelevant = false;	
	if ((Team == pawn(Other).PlayerReplicationInfo.team) || (pawn(other) == none))
	  bTeamRelevant = true;
	  
	if( IsRelevant( Other ) && bTeamRelevant )
	{
		// Untrigger all matching actors.
		if( Event != '' )
			foreach AllActors( class 'Actor', A, Event )
				A.UnTrigger( Other, Other.Instigator );
	}
}


//
//	Someone shoots the trigger
//
function TakeDamage( int Damage, Pawn instigatedBy, Vector hitlocation, 
						Vector momentum, name damageType)
{
	local actor A;

	if ( bInitiallyActive && (TriggerType == TT_Shoot) && (Damage >= DamageThreshold) && (instigatedBy != None) 
		&& (instigatedBy.PlayerReplicationInfo.Team == Team))
	{
		if ( ReTriggerDelay > 0 )
		{
			if ( Level.TimeSeconds - TriggerTime < ReTriggerDelay )
				return;
			TriggerTime = Level.TimeSeconds;
		}
		// Broadcast the Trigger message to all matching actors.
		if( Event != '' )
			foreach AllActors( class 'Actor', A, Event )
				A.Trigger( instigatedBy, instigatedBy );

		if( Message != "" )
			// Send a string message to the toucher.
			instigatedBy.Instigator.ClientMessage( Message );

		if( bTriggerOnceOnly )
			// Ignore future touches.
			SetCollision(False);
	}
}

defaultproperties
{
}
