//=============================================================================
// TElevatorTrigger.
//
// OpenMod is licensed under the terms of the GNU Library General Public
// License.  More information on OpenMod and the terms of its license may
// be found in it's readme file, located in this game's "SYSTEM" directory.
//=============================================================================
class TElevatorTrigger expands ElevatorTrigger;

var(Team) int Team;

//
// Called when something touches the trigger.
//
function Touch( actor Other )
{
	local ElevatorMover EM;
	local bool bTeamRelevant;
	
	bTeamRelevant = false;
	if ((Team == pawn(Other).PlayerReplicationInfo.team) || !(Level.Game.bTeamGame) || (pawn(other) == none))
	  bTeamRelevant = true;
	  
	if( IsRelevant( Other ) && bTeamRelevant )
	{
		// Call the ElevatorMover's Move function
		if( Event != '' )
			foreach AllActors( class 'ElevatorMover', EM, Event )
				EM.MoveKeyframe( GotoKeyFrame, MoveTime );

		if( bTriggerOnceOnly )
			// Ignore future touches.
			SetCollision(False);
	}
}

defaultproperties
{
}
