//=============================================================================
// WeaponSetInfo.
//
// OpenMod is licensed under the terms of the GNU Library General Public
// License.  More information on OpenMod and the terms of its license may
// be found in it's readme file, located in this game's "SYSTEM" directory.
//=============================================================================
class WeaponSetInfo expands Info;


replication
{
	reliable if( Role<ROLE_Authority )
		DoReplacement;
}


enum EWeaponSetItemType
{
	WEAP_None,
	WEAP_ReplaceAll,
	WEAP_ReplaceOne,
	WEAP_New
};


var() string				SetName;

const MAX_ITEMS = 25;
var() EWeaponSetItemType		Type[25];
var() class<Actor>				PrevItem[25];
var() class<Actor>				NewItem[25];
var() name						ItemName[25];
var() vector					ItemLocation[25];
var() rotator					ItemRotation[25];

// If 25 items is too small, simply attach another set to the end of this one
var() class<WeaponSetInfo>		NextSet;

var() class<weapon>				DefaultWeapon;
var() class						DefaultAmmo;
var() int						DefaultAmmoAmt;


function DoReplacement()
{
	local int i;
	local Actor A;
	local WeaponSetInfo WSI;
	
	log("Weapon Set DoReplacement() Activated: "$SetName);
	
	for(i=0;i<MAX_ITEMS;i++)
	{	
		switch (Type[i])
		{
			case WEAP_None:
				break;
			
			case WEAP_ReplaceAll:
				foreach AllActors(PrevItem[i], A)
				{
					Spawn(NewItem[i],,,A.Location,A.Rotation);
					A.Destroy();
				}
				break;
				
			case WEAP_ReplaceOne:
				foreach AllActors(PrevItem[i], A)
				{
					if (ItemName[i] == A.Name)
					{
						Spawn(NewItem[i],,,A.Location,A.Rotation);
						A.Destroy();
					}
				}
				break;
				
			case WEAP_New:
				Spawn(NewItem[i],,,ItemLocation[i],ItemRotation[i]);
				break;

		}
	}
	
	// Check if there is another weapon set.  If so, move onto it.
//	if (NextSet != None && NextSet != self.class)
//	{
//		WSI = spawn(NextSet);
//		WSI.DoReplacement();
//	}
}

defaultproperties
{
}
