//=============================================================================
// PlayerStartFinder.
//
// OpenMod is licensed under the terms of the GNU Library General Public
// License.  More information on OpenMod and the terms of its license may
// be found in it's readme file, located in this game's "SYSTEM" directory.
//=============================================================================
class PlayerStartFinder expands NavigationPoint;


function FindPoints(float Radius, name SetToName, byte SetToNum)
{
	local PlayerStart ps;
	
	foreach RadiusActors(class'PlayerStart', ps, Radius)
	{
		if (ps.ownerTeam != 'None') {
			ps.ownerTeam = 'None';
			ps.TeamNumber = 255; // std number for no team
			continue;
		}
		
		//log(class$": FindPoints(): "$SetToName$", "$SetToNum);
		
		ps.ownerTeam = SetToName;
		ps.TeamNumber = SetToNum;
	}
}

defaultproperties
{
     bStatic=False
}
