//=============================================================================
// PersistentItemSpawner.
//=============================================================================
class PersistentItemSpawner expands DynItemSetInfo;


var() class<DynItemSpawner>		ItemSpawnerClass;			// The class of the item spawner
var DynItemSpawner				ItemSpawner;				// This does the actual item spawning
var() float						TimeCheck;					// How much time in between each item check
var() bool						bDontInitiallySpawnItems;	// This will prevent items from being spawned
															// when Initialize() is initially called.
var() int						ItemSpawnAmt[25], ItemSpawnMax[25];


function bool PreInitialize()
{	
	if (!Super.PreInitialize())
		return false;
	
	ItemSpawner = DynItemSpawner( OpenModGameInfo(Owner).LoadSingleClass(ItemSpawnerClass) );
	
	if ( ItemSpawner == None )
	{
		log("OpenMod: PersistentItemSpawner: PreInitialize(): ERROR: ItemSpawner==None, function halting");
		return false;
	}
	
	return true;
}


function bool Initialize()
{
//	if (!Super.Initialize())
//		return false;
	
	if ( TimeCheck != 0.0 )
	{ 
		//log("OpenMod: PersistentItemSpawner: Initialize(): Setting Timer to: "$TimeCheck);
		SetTimer(TimeCheck, true);
		if ( !bDontInitiallySpawnItems )
			SpawnItems();
	}
		
}


function Timer()
{
	SpawnItems();
}


function SpawnItems()
{
	local int NumItems, i, j;
	local Actor A;
	
	for (i=0; i<MAX_ITEMS; i++)
	{
		if ( NewItem[i] != None )
		{
			NumItems = 0;
			foreach AllActors( NewItem[i], A )
			{
				if ( !Inventory(A).bHeldItem &&
				     !Inventory(A).bActive )
					NumItems++;
			}
			j = NumItems;
			while ( (NumItems+ItemSpawnAmt[i]) > j &&
			        ItemSpawnMax[i] > j )
			{
				//log("OpenMod: PersistentItemSpawner: Timer(): Spawning Item: "$i$", "$NewItem[i]);
				SpawnItem(i);			// DLL: SpawnItem() will call SpawnCustom()
				j++;
			}
		}
	}

}


function SpawnCustom( int index )
{
	ItemSpawner.ClassToSpawn = NewItem[index];
	ItemSpawner.SpawnType = ST_RandomPlayerStart;
	ItemSpawner.SpawnEffect = SE_PopOut;
	ItemSpawner.SpawnPhysics = PHYS_Falling;
	ItemSpawner.RandomSpawnRangeMin = vect(-200, -200, 200);
	ItemSpawner.RandomSpawnRangeMax = vect(200, 200, 200);
	ItemSpawner.bDontSetRespawnTime = false;
	ItemSpawner.RespawnTime = 0.0;
	ItemSpawner.SpawnItem();
}

defaultproperties
{
}
