//=============================================================================
// OpenModInfo.
//
// OpenMod is licensed under the terms of the GNU Library General Public
// License.  More information on OpenMod and the terms of its license may
// be found in it's readme file, located in this game's "SYSTEM" directory.
//=============================================================================
class OpenModInfo expands Info;


var() class<DynInfo>		AvailableInfo[32];		


// Finds the distance between two vectors
function float FindDistance(vector v1, vector v2)
{
	//log("FindDistance(): v1  : "$v1);
	//log("FindDistance(): v2  : "$v2);
	//log("FindDistance(): diff: "$v1-v2);
	
	return vsize(v1 - v2);
}

// Determines if the byte is a digit
function bool IsDigit(byte ch)
{
	//log("IsDigit(): "$ch);
	//log("IsDigit(): IK_0: "$EInputKey.IK_0);
	
	if (ch >= EInputKey.IK_0 && ch <= EInputKey.IK_9)
		return true;
	
	return false;
}

defaultproperties
{
}
