//=============================================================================
// ObjectLoader.
//
// OpenMod is licensed under the terms of the GNU Library General Public
// License.  More information on OpenMod and the terms of its license may
// be found in it's readme file, located in this game's "SYSTEM" directory.
//=============================================================================
class ObjectLoader expands Info;


// Will figure out the actual package name from the given base name.
// Ex: Passed:   "Really Funky Level"
//     Returned: "ReallLevel"
function string GetPackageName(string strBaseName)
{
	local string			strTmp;
	
	// Remember that DynamicLoadObject() will only accept up to 32 character object names!
	// It will cut the level's title up to 10 chars with no spaces before loading
	// If the Title is bigger than 10 chars, it will take the first and last 5

	strTmp = Super(ObjectLoader).StrStripBadChars(strBaseName);
	
	log(class$": GetPackageName(): passed="$strBaseName);
	log(class$": GetPackageName(): processed1="$strTmp);
	
	if ( Len(strTmp) > 10 ) {
		// DLL: The use of 'Super' is explained in LoadObject()
		//strTmp = Super(ObjectLoader).StrStripBadChars(strBaseName);
		strTmp = Left(strTmp, 5) $ Right(strTmp, 5);
	} else {
		//strTmp = Left( Super(ObjectLoader).StrStripBadChars(strBaseName), 10);
	}

	log(class$": GetPackageName(): processed2="$strTmp);
	
	// Class names cannot begin with a number.  Therefore, if the level's name begins with
	// a number, the first character is replaced with an "X" (and, if necessary, the last
	// character is chopped off.
	//if ( Super(OpenModInfo).IsDigit( asc(mid(strTmp, 0, 1)) ) )
	//	strTmp = "X" $ Right(strTmp,9);

	return strTmp;
}


function OpenModInfo LoadObject(string strBaseName)
{
	local string			strTmp;
	local string			ObjectName;
	local class<OpenModInfo>	InfoClass;
	local OpenModInfo			Databot;

	log("OpenMod: ObjectLoader: LoadObject(): Loading from base name: "$strBaseName);
	
	// DLL: This function must be called using 'Super' else Unreal will assume the
	//   function resides in the originating caller.  (Ie, if an object of type
	//   BlahGame calls OpenModGameInfo.LoadLevelData, that function will call this
	//   function which, now, wants to call GetPackageName.  Unreal will then get
	//   confused and think that GetPackageName() is in BlahGame.  This is probably
	//   because an object of type 'ObjectLoader' was never actually created.)
	strTmp = Super(ObjectLoader).GetPackageName(strBaseName);
	
	//ObjectName = strTmp$"Data."$strTmp$"Info";
	ObjectName = "Data"$strTmp$".Info"$strTmp;
	
	InfoClass = class<OpenModInfo>( DynamicLoadObject( ObjectName, class'Class' ) );
	if ( InfoClass == None ) {
		log("OpenMod: DynInfo: LoadObject(): ERROR: InfoClass==None");
		return None;
	}
	
	Databot = spawn(InfoClass);
	if ( Databot == None ) {
		log("OpenMod: DynInfo: LoadObject(): ERROR: Databot==None");
		return None;
	}
	
	return Databot;
}


// Strips a string of all bad characters ("Hello World" and "Hello-World"
// become "HelloWorld".)
function string StrStripBadChars( string str )
{
	local byte ch;
	local string outstr;
	local int pos, length;
	
	length = len(str);			// Get the string's length
	
	for (pos=0; pos<length; pos++)
	{
		ch = asc( mid(str, pos, 1) );
		
		if ( !Super(ObjectLoader).IsBadChar(ch) )
		{
			outstr = outstr $ chr(ch);
			//log("SSBC: outstr="$outstr$"  ch="$chr(ch));
		} else {
			//log("SSBC: skipping");
		}	
	}
	
	return outstr;
}


function bool IsBadChar( byte TestMe )
{
	//log("IsBadChar(): Testing="$chr(TestMe)$", "$TestMe);
	
	if ( TestMe == EInputKey.IK_Space ||
	     TestMe == EInputKey.IK_Minus ||
	     TestMe == asc(".") )
		return true;
	else
		return false;
}

defaultproperties
{
}
