//=============================================================================
// LinkedList.
//=============================================================================
class LinkedList expands Info;


var Actor				DataActor;
var LinkedList			PrevInfo, NextInfo;


function Timer()
{
	//log(class$": Name="$self.Name$": Timer()");
	
	Destroy();
}

function Destroyed()
{
	//log(class$": Name="$self.Name$": Destroyed()");
	
	if ( PrevInfo != None )
		PrevInfo.NextInfo = NextInfo;
	if ( NextInfo != None )
		NextInfo.PrevInfo = PrevInfo;
	
	NextInfo = None;
	PrevInfo = None;
	DataActor = None;
		
	Super.Destroyed();
}

function DestroyAll()
{
	//log(class$": Name="$self.Name$": DestroyAll()");
	
	if ( PrevInfo != None )
		PrevInfo.DestroyAll();
	if ( NextInfo != None )
		NextInfo.DestroyAll();
	
	Destroy();
}

function DestroyAllForward()
{
	//log(class$": DestroyAllForward(), DataActor.name="$DataActor.name);
	
	if ( NextInfo != None )
		NextInfo.DestroyAllForward();
	
	Destroy();
}

function Add( LinkedList AddMe )
{
	//log(class$": Name="$self.Name$": Add(): AddMe.Name="$AddMe.Name);

	if ( AddMe.DataActor == DataActor )
		return;
	
	if ( NextInfo == None )
		NextInfo = AddMe;
	else
		NextInfo.Add(AddMe);
}

function LinkedList Create( Actor CreateMe )
{
	local LinkedList AddMe;
	
	//log(class$": Create(): CreateMe.Name="$CreateMe.Name);
	
	AddMe = spawn(class'LinkedList');
	AddMe.DataActor = CreateMe;
	
	self.Add(AddMe);
	
	return AddMe;
}

function Actor SearchByActor( Actor SearchActor )
{
	//log(class$": Name="$self$": SearchByActor(): SearchName="$SearchActor);

	if ( DataActor == SearchActor )
		return DataActor;
	else if ( NextInfo != None )
		return NextInfo.SearchByActor(SearchActor);
	else
		return None;
}


function Actor SearchByActorName( name SearchName )
{
	//log(class$": Name="$self.Name$": SearchByActorName(): SearchName="$SearchName);

	if ( DataActor.Name == SearchName )
		return DataActor;
	else if ( NextInfo != None )
		return NextInfo.SearchByActorName(SearchName);
	else
		return None;
}



function Update( Actor OldActor, Actor NewActor )
{
	//log(class$": Name="$self.Name$": Update(): OldActor="$OldActor$", NewActor="$NewActor);
	
	if ( DataActor == OldActor )
		DataActor = NewActor;

	if ( NextInfo != None )
		NextInfo.Update(OldActor, NewActor);
}

defaultproperties
{
}
