//=============================================================================
// DynMusicInfo.
//
// OpenMod is licensed under the terms of the GNU Library General Public
// License.  More information on OpenMod and the terms of its license may
// be found in it's readme file, located in this game's "SYSTEM" directory.
//=============================================================================
class DynMusicInfo expands DynInfo;

// DLL: UnrealEd doesn't allow these things to be changed without hard-coding
//   them.
/*
struct SMusicInfo
{
	var music Music;
	var byte Section;
	var EMusicTransition Transition;
};

var() SMusicInfo		DefaultMusic;
var() SMusicInfo		SuspenseMusic;
var() SMusicInfo		ActionMusic;
*/


var() string			DefaultMusic_MusicStr;
var music				DefaultMusic_Music;
var() byte				DefaultMusic_Section;
var() EMusicTransition	DefaultMusic_Transition;

var() string			SuspenseMusic_MusicStr;
var music				SuspenseMusic_Music;
var() byte				SuspenseMusic_Section;
var() EMusicTransition	SuspenseMusic_Transition;

var() string			ActionMusic_MusicStr;
var music				ActionMusic_Music;
var() byte				ActionMusic_Section;
var() EMusicTransition	ActionMusic_Transition;



function bool PreInitialize()
{
	if (!Super.PreInitialize())
		return false;
		
	log(class$": PreInitialize(): Music Loaded="$InfoName);
	
	DefaultMusic_Music = music( DynamicLoadObject(DefaultMusic_MusicStr, class'music') );
	SuspenseMusic_Music = music( DynamicLoadObject(SuspenseMusic_MusicStr, class'music') );
	ActionMusic_Music = music( DynamicLoadObject(ActionMusic_MusicStr, class'music') );
	
	OpenModGameInfo(Owner).MusicInfo = self;
}

defaultproperties
{
}
