//=============================================================================
// DynLevelInfo.
//
// OpenMod is licensed under the terms of the GNU Library General Public
// License.  More information on OpenMod and the terms of its license may
// be found in it's readme file, located in this game's "SYSTEM" directory.
//=============================================================================
class DynLevelInfo expands DynZoneInfo;

function bool Initialize()
{
	return InitializeLevel();
}

function bool InitializeLevel()
{
	log(class$": InitializeLevel(): WARNING: This function should not be called directly.");
	return true;
}

// Makes all PlayerStart points viewable
function ViewPoints()
{
	local PlayerStart ps;
	local ViewablePoint vp;
	
	foreach AllActors(class'PlayerStart', ps)
	{
		vp = spawn(class'ViewablePoint',,,ps.Location);
		if (ps.ownerTeam != 'None') {
			vp.Sprite = texture( DynamicLoadObject("UnrealShare."$string(ps.ownerTeam)$"Skull",class'texture') );
			log(class$": ViewPoints(): Setting To: "$ps.ownerTeam);
		}
		vp.bHidden = false;
	}
}

function bool IsValid()
{
	log(class$": IsValid(): WARNING: This function should not be called directly.");
	return false;
}

defaultproperties
{
}
