//=============================================================================
// DynItemSpawner.
//=============================================================================
class DynItemSpawner expands DynInfo;

var enum EDIS_SpawnType
{
	ST_Location,
	ST_NamedPlayerStart,
	ST_RandomPlayerStart,
	ST_TeamPlayerStart
} SpawnType;

var enum EDIS_SpawnEffect
{
	SE_Normal,
	SE_PopOut
} SpawnEffect;

var() class<actor>			ClassToSpawn;
var() name					PlayerStartName;
var() byte					PlayerStartTeam;
var() vector				SpawnLocation;
var() rotator				SpawnRotation;
var() vector				SpawnVelocity;
var vector					CurrentSpawnVelocity;
var() EPhysics				SpawnPhysics;
var() bool					bDontSetRespawnTime;
var() float					RespawnTime;

var() vector				RandomSpawnRangeMin;
var() vector				RandomSpawnRangeMax;


function bool Initialize()
{
	return Super.Initialize();
}

function PreSpawnItem();

function SpawnItem()
{
	local Actor A, tmp;
	
	switch ( SpawnEffect )
	{
		case SE_Normal:
			CurrentSpawnVelocity = SpawnVelocity;
		case SE_Popout:
			CurrentSpawnVelocity.X = RandRange(RandomSpawnRangeMin.X, RandomSpawnRangeMax.X);
			CurrentSpawnVelocity.Y = RandRange(RandomSpawnRangeMin.Y, RandomSpawnRangeMax.Y);
			CurrentSpawnVelocity.Z = RandRange(RandomSpawnRangeMin.Z, RandomSpawnRangeMax.Z);
			break;
	}
	
	switch ( SpawnType )
	{
		case ST_Location:
			A = Spawn(ClassToSpawn,,,SpawnLocation,SpawnRotation);
			break;
		case ST_NamedPlayerStart:
		case ST_RandomPlayerStart:
		case ST_TeamPlayerStart:
			tmp = FindPlayerStart();
			A = Spawn(ClassToSpawn,,,tmp.Location,SpawnRotation);
	}
	
	if ( A.IsA('Inventory') && !bDontSetRespawnTime)
		Inventory(A).RespawnTime = RespawnTime;
	A.SetPhysics(SpawnPhysics);
	A.Velocity = CurrentSpawnVelocity;

}

function PlayerStart FindPlayerStart()
{
	local byte tmpTeam;
	local PlayerStart tmpPS;
	
	switch( SpawnType )
	{
		case ST_NamedPlayerStart:
			foreach AllActors( class'PlayerStart', tmpPS )
			{
				if ( tmpPS.name == PlayerStartName )
					return tmpPS;
			}
			log("OpenMod: DynItemSpawner: FindPlayerStart(): ERROR: Could not find PlayerStart with name="$PlayerStartName);
			return None;
		case ST_RandomPlayerStart:
			tmpTeam = 255;
			break;
		case ST_TeamPlayerStart:
			tmpTeam = PlayerStartTeam;
			break;
	}
	
	if ( tmpTeam == 255 )
		return PlayerStart(OpenModGameInfo(Owner).FindPlayerStartSimple());
	else
		return PlayerStart(Level.Game.FindPlayerStart(tmpTeam));
}

defaultproperties
{
}
