//=============================================================================
// DynItemSetInfo.
//=============================================================================
class DynItemSetInfo expands DynInfo;

enum EDynItemSetInfo_ItemType
{
	ITEM_None,
	ITEM_ReplaceAll,
	ITEM_ReplaceOne,
	ITEM_New,
	ITEM_Custom,
};


var() string					SetName;

const MAX_ITEMS = 25;
var() EDynItemSetInfo_ItemType	Type[25];
var() class<Actor>				PrevItem[25];
var() class<Actor>				NewItem[25];
var() name						ItemName[25];
var() vector					ItemLocation[25];
var() rotator					ItemRotation[25];

// If 25 items is too small, simply attach another set to the end of this one
var() class<DynItemSetInfo>		NextSet;

/*
var() class<Actor>				DefaultWeapon;
var() class						DefaultAmmo;
var() int						DefaultAmmoAmt;
*/

function bool Initialize()
{
	local int i;
	//local Actor A;
	local DynItemSetInfo DISI;
	
	//log("OpenMod: DynItemSetInfo: Initialize(): Activated Set="$SetName);
	
	for(i=0;i<MAX_ITEMS;i++)
	{	
		SpawnItem( i );
	}
	
	// Check if there is another item set.  If so, move onto it.
//	if (NextSet != None && NextSet != self.class)
//	{
//		DISI = spawn(NextSet);
//		DISI.Initializez();
//	}
}


function SpawnItem( int i )
{
	local Actor A;
	
	switch (Type[i])
	{
		case ITEM_None:
			break;
		
		case ITEM_ReplaceAll:
			foreach AllActors(PrevItem[i], A)
			{
				Spawn(NewItem[i],,,A.Location,A.Rotation);
				A.Destroy();
			}
			break;
			
		case ITEM_ReplaceOne:
			foreach AllActors(PrevItem[i], A)
			{
				if (ItemName[i] == A.Name)
				{
					Spawn(NewItem[i],,,A.Location,A.Rotation);
					A.Destroy();
				}
			}
			break;
			
		case ITEM_New:
			Spawn(NewItem[i],,,ItemLocation[i],ItemRotation[i]);
			break;

		case ITEM_Custom:
			SpawnCustom(i);
			break;
			
	}

}


// This function is meant to be overridden
function SpawnCustom( int index );

defaultproperties
{
}
