//=============================================================================
// DynInfo.
//
// OpenMod is licensed under the terms of the GNU Library General Public
// License.  More information on OpenMod and the terms of its license may
// be found in it's readme file, located in this game's "SYSTEM" directory.
//=============================================================================
class DynInfo expands Info
	abstract;


var() string InfoName;

function bool PreInitialize()
{
	if (Owner == None)
	{
		log("OpenMod: DynInfo: InitializeDynInfo(): ERROR: Owner == None, Flag classes not set!");
		return false;
	}
	
	if (OpenModGameInfo(Owner) == None)
	{
		log("OpenMod: DynInfo: InitializeDynInfo(): ERROR: Owner is not an OpenModGameInfo class!");
		return false;
	}

	return true;
}

function bool Initialize()
{
	return true;
}

function DestroyAll(class<Actor> DeleteMe)
{
	local Actor A;
	
	foreach AllActors(DeleteMe, A)
	{
		A.Destroy();
	}
}

defaultproperties
{
}
