//=============================================================================
// Strength.
//=============================================================================
class Strength expands Runes;

/*
#exec MESH IMPORT MESH=rune4 ANIVFILE=MODELS\rune4_a.3d DATAFILE=MODELS\rune4_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=rune4 X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=rune4 SEQ=All   STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=rune4 SEQ=rune4 STARTFRAME=0 NUMFRAMES=1

//#exec TEXTURE IMPORT NAME=Jrune41 FILE=MODELS\rune41.PCX GROUP=Skins FLAGS=2 // TempMaterial

#exec MESHMAP NEW   MESHMAP=rune4 MESH=rune4
#exec MESHMAP SCALE MESHMAP=rune4 X=0.1 Y=0.1 Z=0.2

#exec MESHMAP SETTEXTURE MESHMAP=rune4 NUM=1 TEXTURE=Jrune

#exec AUDIO IMPORT FILE="Sounds\Runes\Strength.wav" NAME="Strength" GROUP="Runes"
*/

// FIXME: no longer using *= and /=, but just =.  
// Not a problem unless there is a collision with something else...
// Needed to do this for the new rune model or else do some big hack..
function Destroyed()
{
	if (Pawn(Owner) != None)
	{
		Log(class$": Destroyed(): Resetting Owner's DamageScaling to: "$Pawn(Owner).Default.DamageScaling);
		Pawn(Owner).DamageScaling = Pawn(Owner).Default.DamageScaling;
	}
	
	Super.Destroyed();
}

function SetPRIAmt( int SetTo )
{
	NnPlayerReplicationInfo(Pawn(Owner).PlayerReplicationInfo).StrengthAmt = SetTo;
}

function int GetPRIAmt()
{
	return NnPlayerReplicationInfo(Pawn(Owner).PlayerReplicationInfo).StrengthAmt;
}

function PickupFunction(Pawn Other)
{
	//log(class$": PickupFunction(): PlayerName="$Other.PlayerReplicationInfo.PlayerName);
	Super.PickupFunction(Other);
	Other.DamageScaling = (1 + GetMultiplier());
	//log(class$": PickupFunction(): New DamageScaling="$Other.DamageScaling);
}

function Fire( float F )
{
	//Owner.PlaySound(ActivateSound, SLOT_Interact, 4.0);
	//log(class$": Fire()");
	Owner.PlaySound(ActivateSound,,6.0);
	Super.Fire(F);
}

function AltFire( float F )
{
	//log(class$": AltFire()");
	Owner.PlaySound(ActivateSound,,6.0);
	Super.AltFire(F);
}

defaultproperties
{
     ItemName="Strength"
     PickupViewMesh=LodMesh'NnCTFMedia.rune4'
     ActivateSound=Sound'NnCTFMedia.Runes.Strength'
     Icon=Texture'UnrealShare.Icons.I_Amp'
     Physics=PHYS_Falling
     Mesh=LodMesh'NnCTFMedia.rune4'
}
