//=============================================================================
// Runes.
//=============================================================================
class Runes expands Pickup config(NnCTF)
	abstract;

/*
// The texture
#exec TEXTURE IMPORT NAME=Jrune FILE=TEXTURES\Skins\rune.PCX GROUP=Skins FLAGS=2 // TempMaterial

// The pickup sound
#exec AUDIO IMPORT FILE="Sounds\Runes\RunePickup.WAV" NAME="RunePickup" GROUP="Runes"
*/


// FIXME: implement this or something
var() float			Multiplier;				// Should the runes be amplified, decreased, or default (1.0)
var() int			MaxCharge;				// The maximum charge allowed

var() float			InvalidTime;			// How much time should a rune be invalidated (0 = infinite)

var bool			bInvalidDestroy;
var bool			bChargeAlreadySet;

var bool			bRespawnOnDestroy;		// Should this rune be respawned after being destroyed?
        			                  		// (Instead of just being tossed.)

// Moves the rune to a random point (it might not be a playerstart anymore) and sets it up to fall
function MoveToPlayerStart()
{
	local vector tmpVec;
	
	tmpVec.X = RandRange(-200, 200);
	tmpVec.Y = RandRange(-200, 200);
	tmpVec.Z = 200;
	
	SetLocation(NnCTFGame(Level.Game).FindRandomPoint().Location);
	SetPhysics(default.Physics/*PHYS_Falling*/);		// make it fall
	Velocity = tmpVec;
}

// DLL: This is currently only here for testing
function Fire( float F )
{
	//log(class$": Fire()");
	Super.Fire(F);
}

function AltFire( float F )
{
	//log(class$": AltFire()");
	Super.AltFire(F);
}

// gets the RuneCharge of the given player
function int GetPlayerRuneCharge(pawn P)
{
	local int RuneCharge;
	local Runes R;

	// DLL: Does this check really need to be made?
	//if (CTFPlayer(P) == None)
	//	return (0);
	
	RuneCharge = 0;	
	foreach P.ChildActors(class'Runes', R)
	{
		RuneCharge += R.Charge;
	}
	return (RuneCharge);
}	

// Adjusts the player's replicated charge info.
function AdjustPRI( int AdjustBy )
{
	local NnPlayerReplicationInfo NnPRI;
	
	//log(class$": AdjustPRI(): AdjustBy="$AdjustBy);
	
	if ( Pawn(Owner) != None )
	{
		NnPRI = NnPlayerReplicationInfo(Pawn(Owner).PlayerReplicationInfo);
		if ( NnPRI != None )
		{
			SetPRIAmt( Max(0, GetPRIAmt() + AdjustBy) );
		} else {
			log(class$": AdjustPRI(): ERROR: Pawn(Owner).PRI isn't an NnPRI");
		}
	} else {
		log(class$": AdjustPRI(): ERROR: Pawn(Owner)==None");
	}
}

// Used to directly get and set the player's replicated charge info.
// Must be implemented in each subclass.
function SetPRIAmt(int SetTo);
function int GetPRIAmt();


// Runes in a person's inventory are "destroyed" when he/she dies
// Make new ones to replace the old...
function Destroyed()
{
	local Runes copy;
	local LinkedList newInvalidation;
	local vector X, Y, Z;

	if (Pawn(Owner) != None)
	{
		AdjustPRI( -1 * Charge );
		InvalidateRune(Pawn(Owner));
		
		GetAxes(Pawn(Owner).ViewRotation,X,Y,Z);
		do
		{
			if ( !bRespawnOnDestroy )
			{
				copy = spawn(self.class,,,Pawn(Owner).Location + 10*Y - 20*Z);
				copy.InvalidTime = InvalidTime;
				copy.Velocity = Owner.Velocity + vector(Owner.Rotation) * 150.0;
				copy.Velocity.Z += 240;
			} else {
				copy = spawn(self.class);
				copy.InvalidTime = InvalidTime;
				copy.MoveToPlayerStart();
			}

			if ( NnPlayerReplicationInfo(Pawn(Owner).PlayerReplicationInfo) != None )
			{
				if ( NnPlayerReplicationInfo(Pawn(Owner).PlayerReplicationInfo).InvalidRunes != None )
					NnPlayerReplicationInfo(Pawn(Owner).PlayerReplicationInfo).InvalidRunes.Update(self, copy);
				else
					log(class$": Destroyed(): ERROR: InvalidRunes==None");
			}
			else
				log(class$": Destroyed(): ERROR: PRI==None");
			
		} until (NumCopies-- <= 0);
	}
	
	Super.Destroyed();
}

// Checks to see if the rune is an invalid pickup (due to it previously
// being held.
function bool IsRuneInvalid( Pawn isInvalidWith )
{
	local Actor tmpActor;

	if ( isInvalidWith == None )
		return false;

	if ( NnPlayerReplicationInfo(isInvalidWith.PlayerReplicationInfo) == None )
		return false;
		
	if ( NnPlayerReplicationInfo(isInvalidWith.PlayerReplicationInfo).InvalidRunes == None )
		return false;

	if ( NnPlayerReplicationInfo(isInvalidWith.PlayerReplicationInfo).InvalidRunes.SearchByActor(self) != None )
		return true;
	
	return false;
}

// Invalidate this rune to a given player
function InvalidateRune( Pawn InvalidateMe )
{
	local LinkedList newInvalidation;

	if ( InvalidateMe.IsA('CTFPlayer') )
	{
		newInvalidation = NnPlayerReplicationInfo(InvalidateMe.PlayerReplicationInfo).InvalidRunes.Create(self);
		if ( InvalidTime != 0 && newInvalidation != None )
		{
			newInvalidation.SetTimer(InvalidTime, false);
		}
	}
}

// Set the rune's charge (this information is retrieved from the server)
// TODO: look into changing this so its not dependant on NnCTFGame
//		 maybe use random numbers over a range?
function int GetNewCharge()
{
	//log(class$": GetNewCharge()");
	return(NnCTFGame(Level.Game).GetNewCharge(class));
}

// Finds the current amount that rune power should be adjusted by
function float GetMultiplier()
{
	// TODO: try fooling with this ... maybe (Charge / 100.0) squared...
	return (Charge / 100.0);
}

// Makes sure everything is still ok after a pickup and then
// reports the power of the current rune
function PickupFunction(Pawn Other)
{
	local int TotalCharge;

	Super.PickupFunction(Other);
	
	// adjust to make sure we didn't go over the MaxRuneCharge limit
	TotalCharge = GetPlayerRuneCharge(Other);
	if ( TotalCharge > NnPlayerReplicationInfo(Other.PlayerReplicationInfo).MaxRuneCharge )
		Charge -= (TotalCharge - NnPlayerReplicationInfo(Other.PlayerReplicationInfo).MaxRuneCharge);
	
	AdjustPRI(Charge);

	Other.ClientMessage(ItemName$" rune now at "$Charge$"% power.");
	//log("NnCTF: Picked up the Rune");
}


function bool HandlePickupQuery(Inventory Item)
{
	local CTFPlayer CP;
	local int TotalCharge;
	
	//CP = CTFPlayer(Owner);
	
	// Should the player pick it up?
	if (Item.IsA('Runes'))
	{
		//log("NnCTF: Touched a Rune with a Rune in Inventory ");
		// if we are full on rune charge then dont pick it up
		if ( GetPlayerRuneCharge(Pawn(Owner)) >= NnPlayerReplicationInfo(Pawn(Owner).PlayerReplicationInfo).MaxRuneCharge )
			return true;	// inhibit pickup
		if ( self.class == Item.class )
		{
			//log("NnCTF: Touched a Rune with the same type of Rune in Inventory");
			// we are full on charge for this particular rune then dont pick it up
			if ( Charge >= MaxCharge )
				return true;	// inhibit pickup
			
			//log("NnCTF: Picking up the rune");
			// pick it up
			// add to Charge, making sure not to exceed MaxCharge
			Charge = Min(Charge + Item.Charge, MaxCharge);
			
			NumCopies++;
			
			// print message
			Item.PlaySound (Item.PickupSound,,2.0);
			Pawn(Owner).ClientMessage(Item.PickupMessage);	// print message				
			PickupFunction(Pawn(Owner));		// this could be a problem, but we need it 
												// for Strength and ValidatePickup()
			
			Item.Destroy();		
			return true;		// we handled the pickup ourself
		}
	}
	
	if ( Inventory == None )
		return false;

	return Inventory.HandlePickupQuery(Item);
}


// Reflect off Wall w/damping
simulated function HitWall( vector HitNormal, actor Wall )
{
	Velocity = 0.6*(( Velocity dot HitNormal ) * HitNormal * (-2.0) + Velocity);

	If (VSize(Velocity) < 5)
	{
		bBounce = False;
		SetPhysics(PHYS_Rotating);
	}
}


event FellOutOfWorld()
{
	SetPhysics(PHYS_None);
	bRespawnOnDestroy = true;
	Destroy();
}


auto state Pickup
{
	function BeginState()
	{		
		PickupMessage = "You got the "$ ItemName $" Rune";	// JMA
		
		Super.BeginState();

		Charge = GetNewCharge();

		SetTimer(45, true);
		SetPhysics(PHYS_Falling);
	}
	
	// Modified from Engine.Inventory.Pickup.Landed()
	// Landed on ground.
	function Landed(Vector HitNormal)
	{
		local rotator newRot;
		newRot = Rotation;
		newRot.pitch = 0;
		SetRotation(newRot);
		SetPhysics(PHYS_Rotating);
		//SetTimer(2.0, false);
	}
	
	function Touch( actor Other )
	{
		if ( ValidTouch(Other) )
			if ( !IsRuneInvalid(Pawn(Other)) )
				Super.Touch(Other);
	}

	
	function Timer()
	{
		MoveToPlayerStart();
	}
}

defaultproperties
{
     Multiplier=1.000000
     MaxCharge=100
     bRotatingPickup=True
     MaxDesireability=2.000000
     PickupSound=Sound'NnCTFMedia.Runes.RunePickup'
     Texture=Texture'Engine.DefaultTexture'
     Skin=Texture'Engine.DefaultTexture'
     bBounce=True
}
