//=============================================================================
// RuneInvalidInfo.
//=============================================================================
class RuneInvalidInfo expands Info;

var name				TargetName;
var RuneInvalidInfo		PrevInfo, NextInfo;

function Timer()
{
	//log(class$": Name="$self.Name$": Timer()");
	
	Destroy();
}

function Destroyed()
{
	//log(class$": Name="$self.Name$": Destroyed()");
	
	if ( PrevInfo != None )
		PrevInfo.NextInfo = NextInfo;
	if ( NextInfo != None )
		NextInfo.PrevInfo = PrevInfo;
		
	Super.Destroyed();
}

function DestroyAll()
{
	//log(class$": Name="$self.Name$": DestroyAll()");
	
	if ( PrevInfo != None )
		PrevInfo.DestroyAll();
	if ( NextInfo != None )
		NextInfo.DestroyAll();
	
	Destroy();
}

function Add( RuneInvalidInfo AddMe )
{
	//log(class$": Name="$self.Name$": Add(): AddMe.Name="$AddMe.Name);

	if ( AddMe.TargetName == TargetName )
		return;
	
	if ( NextInfo == None )
		NextInfo = AddMe;
	else
		NextInfo.Add(AddMe);
}

function RuneInvalidInfo Search( name SearchName )
{
	//log(class$": Name="$self.Name$": Search(): SearchName="$SearchName);

	if ( TargetName == SearchName )
		return self;
	else if ( NextInfo != None )
		return NextInfo.Search(SearchName);
	else
		return None;
}

function Update( name OldName, name NewName )
{
	//log(class$": Name="$self.Name$": Update(): OldName="$OldName$", NewName="$NewName);
	
	if ( TargetName == OldName )
		TargetName = NewName;

	if ( NextInfo != None )
		NextInfo.Update(OldName, NewName);
}

defaultproperties
{
}
