//=============================================================================
// Resist.
//=============================================================================
class Resist expands Runes;

/*
#exec MESH IMPORT MESH=rune2 ANIVFILE=MODELS\rune2_a.3d DATAFILE=MODELS\rune2_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=rune2 X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=rune2 SEQ=All   STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=rune2 SEQ=rune2 STARTFRAME=0 NUMFRAMES=1

//#exec TEXTURE IMPORT NAME=Jrune21 FILE=MODELS\rune21.PCX GROUP=Skins FLAGS=2 // TempMaterial

#exec MESHMAP NEW   MESHMAP=rune2 MESH=rune2
#exec MESHMAP SCALE MESHMAP=rune2 X=0.1 Y=0.1 Z=0.2

#exec MESHMAP SETTEXTURE MESHMAP=rune2 NUM=1 TEXTURE=Jrune

#exec AUDIO IMPORT FILE="Sounds\Runes\Resist.wav" NAME="Resist" GROUP="Runes"
*/

function PickupFunction(Pawn Other)
{
	//log("NnCTF: Resist: PickupFunction()");
	Super.PickupFunction(Other);
}

function SetPRIAmt( int SetTo )
{
	NnPlayerReplicationInfo(Pawn(Owner).PlayerReplicationInfo).ResistAmt = SetTo;
}

function int GetPRIAmt()
{
	return NnPlayerReplicationInfo(Pawn(Owner).PlayerReplicationInfo).ResistAmt;
}

function int ArmorAbsorbDamage(int Damage, name DamageType, vector HitLocation)
{
	//log(class$": ArmorAbsorbDamage(): damage="$Damage);
	//Owner.PlaySound(ActivateSound, SLOT_Ambient, 4.0);
	Owner.PlaySound(ActivateSound,,4.0);
	return(Damage - ( Damage * (ArmorAbsorption / 100.0) * GetMultiplier()));
}

defaultproperties
{
     ItemName="Resist"
     PickupViewMesh=LodMesh'NnCTFMedia.rune2'
     bIsAnArmor=True
     ActivateSound=Sound'NnCTFMedia.Runes.Resist'
     Icon=Texture'UnrealShare.Icons.I_Armor'
     Physics=PHYS_Falling
     Mesh=LodMesh'NnCTFMedia.rune2'
}
