//=============================================================================
// Regen.
//=============================================================================
class Regen expands Runes;

/*
#exec MESH IMPORT MESH=rune3 ANIVFILE=MODELS\rune3_a.3d DATAFILE=MODELS\rune3_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=rune3 X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=rune3 SEQ=All   STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=rune3 SEQ=rune3 STARTFRAME=0 NUMFRAMES=1

//#exec TEXTURE IMPORT NAME=Jrune31 FILE=MODELS\rune31.PCX GROUP=Skins FLAGS=2 // TempMaterial

#exec MESHMAP NEW   MESHMAP=rune3 MESH=rune3
#exec MESHMAP SCALE MESHMAP=rune3 X=0.1 Y=0.1 Z=0.2

#exec MESHMAP SETTEXTURE MESHMAP=rune3 NUM=1 TEXTURE=Jrune

#exec AUDIO IMPORT FILE="Sounds\Runes\Regen.wav" NAME="Regen" GROUP="Runes"
*/

var() int			HealingAmount;			// How much health is given to the player each time

function PickupFunction(Pawn Other)
{
	//log("NnCTF: Regen: PickupFunction()");
	GotoState('Regenning');
	Super.PickupFunction(Other);
}

function SetPRIAmt( int SetTo )
{
	NnPlayerReplicationInfo(Pawn(Owner).PlayerReplicationInfo).RegenAmt = SetTo;
}

function int GetPRIAmt()
{
	return NnPlayerReplicationInfo(Pawn(Owner).PlayerReplicationInfo).RegenAmt;
}

state Regenning
{
	function Timer()
	{
		local Inventory A;
		local int AdjustedHeal;
		
		AdjustedHeal = HealingAmount * GetMultiplier();

		if (Pawn(Owner) != None)
		{
			// FIXME: do shields and stuff??
			A = Pawn(Owner).FindInventoryType(class'Armor');
			if (A != None)
			{
				AdjustedHeal /= 2;		// if healing both armor and health, go at half rate
				A.Charge = Min( A.Charge + AdjustedHeal, 150 );
			}
			if (Pawn(Owner).Health < 150) // fix the superhealth bug.
			{
				Pawn(Owner).Health = Min(Pawn(Owner).Health + AdjustedHeal, 150);
				Owner.PlaySound(ActivateSound, SLOT_Pain, 2.0);
			}
/*
			if (Pawn(Owner).Health < 150)
				Pawn(Owner).Health += 5;
			if (Pawn(Owner).Health > 150)
				Pawn(Owner).Health = 150;
*/
		}
	}
	function BeginState()
	{
		SetTimer(1, true);
	}
}

defaultproperties
{
     HealingAmount=5
     ItemName="Regen"
     PickupViewMesh=LodMesh'NnCTFMedia.rune3'
     ActivateSound=Sound'NnCTFMedia.Runes.Regen'
     Icon=Texture'UnrealShare.Icons.I_Health'
     Physics=PHYS_Falling
     Mesh=LodMesh'NnCTFMedia.rune3'
}
