//=============================================================================
// NnUnrealScoreBoard.
//=============================================================================
class NnUnrealScoreBoard expands UnrealScoreBoard;

var() texture	TeamIcons[5];

var() int		NameSpacingXLimit;
var() int		NameSpacingYLimit;

struct TeamColumn
{
	var float X, Y;
};

function ShowScores( canvas canvas )
{
	local NnGameReplicationInfo NnGRI;
	local GameReplicationInfo tmpGRI;
	local PlayerReplicationInfo PRI;
	local NnCTFTeamInfo NnTI;
	local byte TeamIndexes[8];
	local int PlayerCount, Heights[8], CurrentHeight, i, j;
	local float ColumnWidth, SpacingX, NameSpacingY, CurX, CurY, OrigY, XL, YL;
	local texture TeamIcon;
	local TeamColumn Columns[8];
	
	Canvas.Font = Font'WhiteFont';
	
	DrawHeader(Canvas);
	DrawTrailer(Canvas);
	
	foreach AllActors(class'GameReplicationInfo', tmpGRI)
	{
		//log("GRI found!");
		if (tmpGRI.IsA('NnGameReplicationInfo'))
		{
			NnGRI = NnGameReplicationInfo(tmpGRI);
		}
	}
	
	if (NnGRI == None)
		log("Error: NnGRI == None");
	
	if (Canvas.ClipX >= 640)
	{
		ColumnWidth = (Canvas.ClipX/11)*4;
		SpacingX = (Canvas.ClipX/11);
	} else {
		ColumnWidth = (Canvas.ClipX/13)*5;
		SpacingX = (Canvas.ClipX/13);
	}
		
	if (Canvas.ClipX > 500)
	{
		Canvas.StrLen("TEST", XL, YL);
		OrigY = (32 + 6*YL)+16;
	} else {
		OrigY = 16;
	}
	
	//i = 0;
	CurX = SpacingX;
	foreach AllActors(class'NnCTFTeamInfo', NnTI)
	{
		if (!(NnTI.TeamIndex >= NnGRI.TC_First && NnTI.TeamIndex <= NnGRI.TC_Last))
			continue;
		
		switch (NnTI.TeamIndex)
		{
			case NnGRI.TC_Red: i=0; break;
			case NnGRI.TC_Blue: i=1; break;
			case NnGRI.TC_Green: i=2; break;
			case NnGRI.TC_Yellow: i=3; break;
		}
		
		CurX = ((ColumnWidth + SpacingX) * i) + SpacingX;
		if ( i < 2 )
		{
			CurY = OrigY;
		} else {
			CurX -= (ColumnWidth + SpacingX) * 2;
			CurY = ((Canvas.ClipY - OrigY) / 2) + OrigY;
		}
		
		Columns[i].X = CurX;
		Columns[i].Y = CurY;
		TeamIndexes[i] = NnTI.TeamIndex;
		
		//log("TeamIndex: "$NnTI.TeamIndex$", "$NnTI.TeamName);
		
		Canvas.Style = 3;	// STY_Translucent
		Canvas.DrawColor.R = max(NnTI.TeamColorR/4, 0);
		Canvas.DrawColor.G = max(NnTI.TeamColorG/4, 0);
		Canvas.DrawColor.B = max(NnTI.TeamColorB/4, 0);
		
		//CurX = ((NnTI.TeamIndex-1) * ColumnWidth) + (ColumnWidth/2);
		Canvas.SetPos(CurX+34, CurY+1);
		Canvas.DrawRect(texture'DW_Pen', (ColumnWidth-36), 12);
		
		if (TeamIcons[NnTI.TeamIndex] == None)
		{
			TeamIcons[NnTI.TeamIndex] = texture(DynamicLoadObject("UnrealShare."$NnTI.TeamName$"Skull", class'texture'));
		}

		// DLL: We're assuming that the icon is 32x32 in size
		Canvas.Reset();
		Canvas.Style = 1;
		Canvas.SetPos(CurX+2, CurY+2);
		Canvas.DrawIcon(TeamIcons[NnTI.TeamIndex], 1);
		
		Canvas.Font = Font'WhiteFont';
		Canvas.SetPos(CurX+38, CurY+2);
		Canvas.DrawColor.R = NnTI.TeamColorR;
		Canvas.DrawColor.G = NnTI.TeamColorG;
		Canvas.DrawColor.B = NnTI.TeamColorB;
		Canvas.DrawText(NnTI.TeamName, false);

		Canvas.Font = Font'SmallFont';
		Canvas.DrawColor.R = max(NnTI.TeamColorR-32,0);
		Canvas.DrawColor.G = max(NnTI.TeamColorG-32,0);
		Canvas.DrawColor.B = max(NnTI.TeamColorB-32,0);
		Canvas.SetPos(CurX+36, CurY+14);
		Canvas.DrawText("Score: "$int(NnTI.Score), false);
		Canvas.SetPos(CurX+36, CurY+20);
		Canvas.DrawText("Captures: "$NnTI.Captures, false);
		Canvas.SetPos(CurX+36, CurY+26);

		//Canvas.DrawColor.R = 128;
		//Canvas.DrawColor.G = 128;
		//Canvas.DrawColor.B = 128;
		if (Canvas.ClipX >= 512)
			Canvas.DrawText("Flag State: "$NnTI.FlagStateText);
		else
			Canvas.DrawText("Flag: "$NnTI.FlagStateText);
		
		// Set up for the next one
		//CurX += (ColumnWidth + SpacingX);
		//i++;
	}
	
	// DLL: The following was modified from UnrealTeamScoreBoard
	//for (i=0; i<32; i++)
	//	Scores[i] = -500;
	
	
	foreach AllActors (class'PlayerReplicationInfo', PRI)
	{
		if (PlayerCount < 32 && ( PRI.Team >= NnGRI.TC_First && PRI.Team <= NnGRI.TC_Last ))
		{
			PlayerNames[PlayerCount] = PRI.PlayerName;
			TeamNames[PlayerCount] = PRI.TeamName;
			Scores[PlayerCount] = PRI.Score;
			Teams[PlayerCount] = PRI.Team;
			Pings[PlayerCount] = PRI.Ping;

			PlayerCount++;
		}
	}
	
	SortScores(PlayerCount);


	if ( Canvas.ClipY >= NameSpacingYLimit )
		NameSpacingY = 14;
	else
		NameSpacingY = 20;
	
	for (i=0; i<PlayerCount; i++)
	{
		for (j=0; j<NnGRI.NumTeams; j++)
		{
			if ( Teams[i] == TeamIndexes[j] )
			{
				CurX = Columns[j].X;
				CurY = Columns[j].Y + 24;
			}
		}
		
		// If the canvas is small, don't justify the names to the right of the icon.
		if (Canvas.ClipX >= 512)
			CurX += 34;
		
		NnTI = NnGRI.Teams[Teams[i]];
		
		Heights[Teams[i]]++;
		CurrentHeight = Heights[Teams[i]] * NameSpacingY;
		
		Canvas.DrawColor.R = max(NnTI.TeamColorR-32,0);
		Canvas.DrawColor.G = max(NnTI.TeamColorG-32,0);
		Canvas.DrawColor.B = max(NnTI.TeamColorB-32,0);
		// Player name
		if ( Canvas.ClipX >= NameSpacingXLimit )
			Canvas.Font = Font'WhiteFont';
		else
			Canvas.Font = Canvas.SmallFont;		// DLL: For some reason, TinyWhiteFont doesn't work here
		Canvas.SetPos(CurX+12/*+18*/, CurY+CurrentHeight);
		Canvas.DrawText(PlayerNames[i], false);

		Canvas.DrawColor.R = 255;
		Canvas.DrawColor.G = 255;
		Canvas.DrawColor.B = 255;
		// Player ping
		/*if (Level.NetMode != NM_Standalone)
		{
			Canvas.SetPos(CurX+2, CurY+CurrentHeight);
			Canvas.Font = Font'TinyWhiteFont';
			Canvas.DrawText(Pings[i], false);
		}*/		
		DrawPingOffset(Canvas, i, CurX+2, CurY+CurrentHeight);

		Canvas.DrawColor.R = NnTI.TeamColorR;
		Canvas.DrawColor.G = NnTI.TeamColorG;
		Canvas.DrawColor.B = NnTI.TeamColorB;
		// Player score
		//Canvas.Font = Font'WhiteFont';
		if (Canvas.ClipX >= NameSpacingXLimit) {
			Canvas.Font = Font'WhiteFont';
			//Canvas.SetPos(CurX+( (ColumnWidth-36)*0.85 ), CurY+CurrentHeight);
			DrawScoreOffset(Canvas, i, CurX+( (ColumnWidth-36)*0.85 ), CurY+CurrentHeight);
		} else {
			Canvas.Font = Font'TinyWhiteFont';
			//Canvas.SetPos(CurX+( (ColumnWidth-2)*0.85 ), CurY+CurrentHeight);
			DrawScoreOffset(Canvas, i, CurX+( (ColumnWidth-2)*0.85 ), CurY+CurrentHeight);
		}
		//Canvas.DrawText(int(Scores[i]));	

	}
	
	//Canvas.Reset();
	Canvas.DrawColor.R = 255;
	Canvas.DrawColor.G = 255;
	Canvas.DrawColor.B = 255;
}


// Modified from UnrealShare.UnrealScoreBoard
// DLL: For some reason, NnCTF always has more than one GameReplicationInfo
//   object laying around, each having slightly different values.  This
//   results in a skewed header.  Therefore, we'll simply look for an
//   NnGameReplicationInfo object, of which there is only one.
function DrawHeader( canvas Canvas )
{
	local NnGameReplicationInfo GRI;
	local float XL, YL;

	if (Canvas.ClipX > 500)
	{
		foreach AllActors(class'NnGameReplicationInfo', GRI)
		{
			Canvas.bCenter = true;

			Canvas.SetPos(0.0, 32);
			Canvas.StrLen("TEST", XL, YL);
			if (Level.Netmode != NM_StandAlone)
				Canvas.DrawText(GRI.ServerName);
			Canvas.SetPos(0.0, 32 + YL);
			Canvas.DrawText("Game Type: "$GRI.GameName, true);
			Canvas.SetPos(0.0, 32 + 2*YL);
			Canvas.DrawText("Map Title: "$Level.Title, true);
			Canvas.SetPos(0.0, 32 + 3*YL);
			Canvas.DrawText("Author: "$Level.Author, true);
			Canvas.SetPos(0.0, 32 + 4*YL);
			if (Level.IdealPlayerCount != "")
				Canvas.DrawText("Ideal Player Load:"$Level.IdealPlayerCount, true);

			Canvas.SetPos(0, 32 + 6*YL);
			Canvas.DrawText(Level.LevelEnterText, true);

			Canvas.bCenter = false;
		}
	}
}

function DrawPingOffset( canvas Canvas, int I, float XOffset, float YOffset)
{
	local float XL, YL;

	if (Level.Netmode == NM_Standalone)
		return;

	Canvas.StrLen(Pings[I], XL, YL);
	Canvas.SetPos(XOffset - XL /*- 8*/, YOffset);
	Canvas.Font = Font'TinyWhiteFont';
	Canvas.DrawColor.R = 192;
	Canvas.DrawColor.G = 192;
	Canvas.DrawColor.B = 192;
	Canvas.DrawText(Pings[I], false);
	Canvas.Font = RegFont;
}

function DrawScoreOffset( canvas Canvas, int I, float XOffset, float YOffset )
{
	local float XL, YL;

	//Canvas.StrLen(Scores[I], XL, YL);
	//XOffset -= XL;
	Canvas.SetPos(XOffset, YOffset);

	if(Scores[I] >= 100.0)
		Canvas.CurX -= 6.0;
	if(Scores[I] >= 10.0)
		Canvas.CurX -= 6.0;
	if(Scores[I] < 0.0)
		Canvas.CurX -= 6.0;
	Canvas.DrawText(int(Scores[I]), false);
}

defaultproperties
{
     TeamIcons(0)=Texture'UnrealShare.Icons.RedSkull'
     TeamIcons(1)=Texture'UnrealShare.Icons.BlueSkull'
     TeamIcons(2)=Texture'UnrealShare.Icons.GreenSkull'
     TeamIcons(3)=Texture'UnrealShare.Icons.YellowSkull'
     TeamIcons(4)=Texture'UnrealShare.Icons.IconSkull'
     NameSpacingXLimit=512
     NameSpacingYLimit=384
}
