//=============================================================================
// NnUnrealBotConfigMenu.
//=============================================================================
class NnUnrealBotConfigMenu expands UnrealBotConfigMenu;

function bool ProcessYes()
{
	if ( Selection == 7 )
		NnCTFGame(GameType).bBotsCanCarryFlags = true;
	else
		return Super.ProcessYes();
	
	return true;
}

function bool ProcessNo()
{
	if ( Selection == 7 )
		NnCTFGame(GameType).bBotsCanCarryFlags = false;
	else
		return Super.ProcessYes();
	
	return true;
}

function bool ProcessLeft()
{
	if ( Selection == 7 )
		NnCTFGame(GameType).bBotsCanCarryFlags = !NnCTFGame(GameType).bBotsCanCarryFlags;
	else
		return Super.ProcessLeft();
	
	return true;
}

function bool ProcessRight()
{
	if ( Selection == 7 )
		NnCTFGame(GameType).bBotsCanCarryFlags = !NnCTFGame(GameType).bBotsCanCarryFlags;
	else
		return Super.ProcessRight();
	
	return true;
}

function DrawMenu(canvas Canvas)
{
	local NnCTFGame DMGame;
	local int StartX, StartY, Spacing, i;
	local bool bFoundValue;

	DMGame = NnCTFGame(GameType);

	DrawBackGround(Canvas, (Canvas.ClipY < 250) );

	// Draw Title
	DrawTitle(Canvas);
		
	Spacing = Clamp(0.04 * Canvas.ClipY, 11, 32);
	StartX = Max(40, 0.5 * Canvas.ClipX - 120);
	StartY = Max(36, 0.5 * (Canvas.ClipY - MenuLength * Spacing - 128));

	// draw text
	DrawList(Canvas, false, Spacing, StartX, StartY);  

	MenuValues[1] = string(bAdjustSkill);
	MenuValues[2] = string(Level.Game.Difficulty);
	MenuValues[3] = string(bRandomOrder);
	MenuValues[5] = string(DMGame.InitialBots);
	MenuValues[6] = string(DMGame.bMultiPlayerBots);
	MenuValues[7] = string(DMGame.bBotsCanCarryFlags);
	
	DrawValues(Canvas, Canvas.MedFont, Spacing, StartX+160, StartY);

	// Draw help panel
	DrawHelpPanel(Canvas, StartY + MenuLength * Spacing, 228);
}

defaultproperties
{
}
