//=============================================================================
// NnTeamSelectMenu.
//=============================================================================
class NnTeamSelectMenu expands NnMenu;


var NnCTFTeamInfo				Teams[8];
var NnGameReplicationInfo		NnGRI;

var() class<Menu>				AdminMenuClass;
var() class<Menu>				MainMenuClass;
var() color						MainMenuTextColor;
var() color						DisabledMenuTextColor;
var() color						WaitingColor;

function PostBeginPlay()
{
	//log(class$": PostBeginPlay()");
	SetTimer(0.25, false);
	Timer();
}


simulated function Timer()
{
	local GameReplicationInfo tmpGRI;
	local NnCTFTeamInfo tmpTI;
	local int i, j, num;
	
	//log(class$": Timer(): Starting");
	
	//log(class$": Timer(): Console Info: state="$PlayerOwner.Player.Console.GetStateName());
	if ( PlayerOwner != None )
	{
		if ( PlayerOwner.Player != None )
		{
			if ( PlayerOwner.Player.Console != None )
			{
				//log(class$": Timer(): Console.State="$PlayerOwner.Player.Console.GetStateName());
				if ( !PlayerOwner.Player.Console.IsInState('Menuing') )
					PlayerOwner.Player.Console.GotoState('Menuing');
			}
		}
	}
	
	// Set up MenuLength's initial value
	MenuLength = 1;
	
	foreach AllActors( class'GameReplicationInfo', tmpGRI )
	{
		//log(class$": Timer(): tmpGRI.class="$tmpGRI.class);
		//log(class$": Timer(): tmpGRI.name="$tmpGRI.name);
		if ( tmpGRI == None )
		{
			continue;
		} else
		if ( tmpGRI.IsA('NnGameReplicationInfo') )
		{
			//log(class$": Timer(): NnGRI found.");
			NnGRI = NnGameReplicationInfo(tmpGRI);
		} else
		{
			//log(class$": Timer(): Skipping Current tmpGRI");
			continue;
		}
		//log(class$": Timer(): Mid-NnGRI AllActors");
	
		// Make sure that teams actually exist
		if ( NnGRI.NumTeams <= 0 )
		{
			log(class$": Timer(): ERROR, CRITICAL: NumTeams <= 0");
			return;
		}
		
		// Add the teams to the menu
		foreach AllActors( class'NnCTFTeamInfo', tmpTI )
		{
			if ( tmpTI.TeamIndex >= NnGRI.TC_First &&
			     tmpTI.TeamIndex <= NnGRI.TC_Last )
			{
				MenuLength++;
				switch (tmpTI.TeamIndex)
				{
					case NnGRI.TC_Red: num=2; break; 
					case NnGRI.TC_Blue: num=3; break;
					case NnGRI.TC_Green: num=4; break;
					case NnGRI.TC_Yellow: num=5; break;
				}
				Teams[num] = tmpTI;
			}
		}
		
		//MenuLength++;
		//log("NnCTF: NnTeamSelectMenu: Timer(): NnGRI setup: MenuLength="$MenuLength);
		
		return;
	}
	
	if ( NnGRI == None )
		MenuLength++;
	
	SetTimer(0.25, false);
}


function DrawMenu( canvas Canvas )
{
	local NnCTFTeamInfo NnTI;
	local int StartX, StartY, i;
	local color OldColor;
	local byte OldStyle;
	
	if ( PlayerOwner != None )
	{
		if ( PlayerOwner.Player != None )
		{
			if ( PlayerOwner.Player.Console != None )
			{
				if ( !PlayerOwner.Player.Console.IsInState('Menuing') )
					PlayerOwner.Player.Console.GotoState('Menuing');
			}
		}
	}
	
	StartX = 0;
	StartY = (Canvas.ClipY / 4)-32;

	// Debugging Stuff
	//Canvas.SetPos(40, 40);
	//Canvas.Font = Canvas.SmallFont;
	//Canvas.DrawText("MenuLength: "$MenuLength);

	// NnCTF Title
	Canvas.bCenter = true;
	Canvas.SetPos(StartX, StartY);

	Canvas.Font = Font'MedFont';
	Canvas.DrawText("Welcome to NoName CTF");
	
	// Title Part 2
	StartY += 20;
	Canvas.SetPos(StartX, StartY);
	Canvas.Font = Font'LargeFont';
	Canvas.DrawText("SELECT YOUR TEAM");

	// Set up for the Team Entries
	Canvas.Font = Font'WhiteFont';
	Canvas.bCenter = false;
	StartY += 40;
	
	// Draw the column headers
	OldColor = Canvas.DrawColor;
	Canvas.DrawColor = ColumnHeaderTextColor;
	
	StartX = (Canvas.ClipX/2) - 100;
	Canvas.SetPos(StartX, StartY);
	Canvas.DrawText("Team");
	
	StartX += 108;
	Canvas.SetPos(StartX, StartY);
	Canvas.DrawText("Size");
	
	StartX += 48;
	Canvas.SetPos(StartX, StartY);
	Canvas.DrawText("Score");
	
	StartX = (Canvas.ClipX/2) - 100;
	StartY += 14;
	OldStyle = Canvas.Style;
	Canvas.Style = ColumnHeaderBackRenderStyle;
	Canvas.DrawColor = ColumnHeaderBackColor;
	Canvas.SetPos(StartX-4, StartY);
	Canvas.DrawRect(texture'DW_Pen', 208, 1);
	
	Canvas.Style = OldStyle;
	Canvas.DrawColor = OldColor;

	StartY += 12;
	
	//for (i = 0; i < NnGRI.NumTeams; i++)
	for (i=1; i<=MenuLength; i++)
	{
		//log(i);
		StartX = (Canvas.ClipX/2) - 100;

		// See if this item should be selected
		if ( (Selection) == i )
		{
			OldStyle = Canvas.Style;
			OldColor = Canvas.DrawColor;
			Canvas.Style = SelectedItemRenderStyle;
			Canvas.DrawColor = SelectedItemColor;
			Canvas.SetPos(StartX-5, StartY-1);
			Canvas.DrawRect(texture'DW_Pen', 210, 14);
			Canvas.Style = OldStyle;
			Canvas.DrawColor = OldColor;
		}

		// Check to se if we're drawing a team or a pointer to the main menu
		if ( i == 1 )
		{
			OldColor = Canvas.DrawColor;
			Canvas.bCenter = true;
			Canvas.SetPos(0, StartY);
			Canvas.DrawColor = MainMenuTextColor;
			Canvas.DrawText("Go To The Unreal Main Menu");
			Canvas.bCenter = false;
			Canvas.DrawColor = OldColor;
/*		} else if ( i == MenuLength )
		{
			OldColor = Canvas.DrawColor;
			Canvas.bCenter = true;
			Canvas.SetPos(0, StartY);
			if ( PlayerPawn(Owner).bAdmin )
			{
				Canvas.DrawColor = MainMenuTextColor;
			} else {
				Canvas.DrawColor = DisabledMenuTextColor;
			}
			Canvas.DrawText("Go To The NnCTF Admin Menu");
			Canvas.bCenter = false;
			Canvas.DrawColor = OldColor;
*/
		} else if ( NnGRI == None )
		{
			OldColor = Canvas.DrawColor;
			Canvas.bCenter = true;
			Canvas.SetPos(0, StartY);
			Canvas.DrawColor = WaitingColor;
			Canvas.DrawText("*** Looking for Team Info ***");
			Canvas.bCenter = false;
			Canvas.DrawColor = OldColor;
			
			log("NnCTF: NnTeamSelectMenu: DrawMenu(): ERROR: NnGRI == None");
			continue;
		} else if ( Teams[i] == None )
		{
			continue;
		} else
		{
			NnTI = Teams[i];
			if ( NnTI == None )
				continue;
			
			// Make sure the team is a legitimately numbered one. (not the spectator team)
			if ( NnTI.TeamIndex < NnGRI.TC_First || NnTI.TeamIndex > NnGRI.TC_Last )
				continue;
			
			// Team Name
			Canvas.SetPos(StartX, StartY);
			OldColor = Canvas.DrawColor;
			Canvas.DrawColor.R = NnTI.TeamColorR;
			Canvas.DrawColor.G = NnTI.TeamColorG;
			Canvas.DrawColor.B = NnTI.TeamColorB;
			Canvas.DrawText(NnTI.TeamName);
			Canvas.DrawColor = OldColor;
			
			// Team Size
			StartX += 110;
			Canvas.SetPos(StartX, StartY);
			Canvas.DrawText(NnTI.Size);
			
			// Team Score
			StartX += 48;
			Canvas.SetPos(StartX, StartY);
			Canvas.DrawText(int(NnTI.Score));
		}
			
		// Set up for the next team
		StartY += 18;
		
	}
	
	Canvas.Reset();
}


function bool ProcessSelection()
{
	local Menu ChildMenu;
	
	// First, check if the user requested to go to the main menu
	if ( Selection == 1 )
	{
		ChildMenu = spawn(MainMenuClass, Owner);
		if ( ChildMenu != None )
		{
			HUD(Owner).MainMenu = ChildMenu;
			ChildMenu.ParentMenu = self;
			ChildMenu.PlayerOwner = PlayerOwner;	
		} else {
			log("NnCTF: NnTeamSelectMenu: ProcessSelection(): ERROR: ChildMenu==None");
		}
		return true;
	}
/*	
	} else if ( Selection == MenuLength && PlayerPawn(Owner).bAdmin )
	{
		ChildMenu = spawn(AdminMenuClass, Owner);
		if ( ChildMenu != None )
		{
			HUD(Owner).MainMenu = ChildMenu;
			ChildMenu.ParentMenu = self;
			ChildMenu.PlayerOwner = PlayerOwner;	
		} else {
			log("NnCTF: NnTeamSelectMenu: ProcessSelection(): ERROR: ChildMenu==None");
		}
		return true;
	}		
*/	
	//log("NnCTF: NnTeamSelectMenu: ProcessSelection(): Selected="$Selection$", "$Teams[TeamIndex].TeamName);
	
	if ( PlayerOwner == None )
	{
		log("NnCTF: NnTeamSelectMenu: ProcessSelection(): ERROR: PlayerOwner == None");
		return false;
	}

	CTFPlayer(PlayerOwner).SetTeam(Teams[Selection].TeamName);
	ExitAllMenus();
	return true;
}

defaultproperties
{
     AdminMenuClass=Class'NnCTF.NnGameOptionsMenu'
     MainMenuClass=Class'UnrealShare.UnrealMainMenu'
     MainMenuTextColor=(R=128,G=255)
     DisabledMenuTextColor=(R=128,G=128,B=128)
     WaitingColor=(R=255,G=255,B=255)
     ColumnHeaderBackColor=(R=192,G=192,B=192)
     ColumnHeaderBackRenderStyle=STY_Normal
     ColumnHeaderTextColor=(R=255,G=255,B=128)
     SelectedItemColor=(B=64)
     SelectedItemRenderStyle=STY_Translucent
}
