//=============================================================================
// NnTeamGameOptionsMenu.
//=============================================================================
class NnTeamGameOptionsMenu expands UnrealTeamGameOptionsMenu;


function bool ProcessSelection()
{
	local Menu ChildMenu;
	
	if ( Selection == 11 )
	{
		ChildMenu = spawn(class'NnGameOptionsMenu', owner);
		NnGameOptionsMenu(ChildMenu).InitConfig(GameType);
	}
	else
		return Super.ProcessSelection();

	if ( ChildMenu != None )
	{
		HUD(Owner).MainMenu = ChildMenu;
		ChildMenu.ParentMenu = self;
		ChildMenu.PlayerOwner = PlayerOwner;
	}
	return true;
}

function DrawValues(canvas Canvas, int StartX, int StartY, int Spacing)
{
	MenuList[11] = "";
	
	Super.DrawValues(Canvas, StartX, StartY, Spacing);
}

function DrawOptions(canvas Canvas, int StartX, int StartY, int Spacing)
{
	MenuList[11] = Default.MenuList[11];

	Super.DrawOptions(Canvas, StartX, StartY, Spacing);
}

defaultproperties
{
     GameClass=Class'NnCTF.NnCTFGame'
     MenuLength=11
     HelpMessage(11)="Options Specific To NoName CTF"
     MenuList(11)="NoName CTF Options"
}
