//=============================================================================
// NnTargetingComputer.
//=============================================================================
class NnTargetingComputer expands Pickup
	config(NnCTF);

var() texture			BarMeasure;
var() texture			HealthBar;
var() color				TextColor;
var() color				RuneTextColor;
var() float				ValueColumn;

var() config bool		bNoTargetName;
var() config bool		bNoTargetHealth;
var() config bool		bNoTargetDistance;
var() config bool		bNoTargetWeapon;
var() config bool		bNoTargetScore;
var() config bool		bNoTargetRunes;

var() bool				bViewSelf;			// If set, the owner will be the target.  Used for debugging.



simulated function DrawTC(Canvas Canvas, Pawn Target)
{
	if ( bActive )
	{
		DrawPlayerInfo(Canvas, Target, 4, Canvas.SizeY/2);
	}
}

simulated function DrawPlayerInfo(Canvas Canvas, Pawn Target, float X, float Y)
{
	local color PlayerColor, OldColor;
	local float CurX, CurY, HealthLen, RangeToTarget;
	local NnPlayerReplicationInfo NnPRI;
	local byte OldStyle;
	local string tmpStr;
	local Inventory Inv;
	local string RuneNames[8];
	local int RuneValues[8], MaxRunes, i;
	local bool bIsOnTeam;
	
	if ( bViewSelf )
		Target = Pawn(Owner);
	
	// Set up vars
	NnPRI = NnPlayerReplicationInfo(Target.PlayerReplicationInfo);
	
	if ( NnPRI == None )
	{
		log (class$": DrawPlayerInfo(): ERROR: NnPRI == None, function aborting");
		return;
	} else if ( Target == None )
	{
		log (class$": DrawPlayerInfo(): ERROR: Target == None, function aborting");
		return;
	} else if ( Owner == None )
	{
		log (class$": DrawPlayerInfo(): ERROR: Owner == None, function aborting");
		return;
	}
	
	if ( Target.PlayerReplicationInfo.IsA('NnPlayerReplicationInfo') )
	{
		PlayerColor.R = NnPRI.TeamColorR;
		PlayerColor.G = NnPRI.TeamColorG;
		PlayerColor.B = NnPRI.TeamColorB;
	} else {
		PlayerColor.R = 255;
		PlayerColor.G = 255;
		PlayerColor.B = 255;
	}
	CurX = X;
	CurY = Y;

	bIsOnTeam = (Target.PlayerReplicationInfo.Team == Pawn(Owner).PlayerReplicationInfo.Team);

	// Player Name
	if ( !bNoTargetName )
	{
		OldColor = Canvas.DrawColor;
		Canvas.DrawColor = PlayerColor;
		Canvas.SetPos(CurX, CurY);
		Canvas.Font = Font'WhiteFont';
		Canvas.DrawText(Target.PlayerReplicationInfo.PlayerName);
		Canvas.DrawColor = OldColor;
		
		CurY += 12;
	}
	
	Canvas.Font = Canvas.SmallFont;
	
	// Health Bar
	if ( !bNoTargetHealth && bIsOnTeam )
	{
		// Bar Measure
		OldStyle = Canvas.Style;
		Canvas.Style = ERenderStyle.STY_Masked;
		Canvas.SetPos(CurX+ValueColumn, CurY);
		Canvas.DrawIcon(BarMeasure, 1.0);
		Canvas.Style = OldStyle;
		
		CurY += 6;
		
		// Health
		OldStyle = Canvas.Style;
		Canvas.Style = ERenderStyle.STY_Translucent;
		HealthLen = GetBarLength(HealthBar.USize, 100, Target.Health);
		Canvas.SetPos(CurX, CurY);
		Canvas.DrawColor = TextColor;
		Canvas.DrawText("Health:");
		Canvas.SetPos(CurX+ValueColumn, CurY+4);
		Canvas.DrawTile(HealthBar, HealthLen, HealthBar.VSize, 0, 0, HealthLen, HealthBar.VSize);
		Canvas.Style = OldStyle;
		
		CurY += 10;
	}
	
	// Distance
	if ( !bNoTargetDistance )
	{
		RangeToTarget = VSize(Target.Location - Owner.Location);
		Canvas.SetPos(CurX, CurY);
		Canvas.DrawText("DST: ");
		Canvas.SetPos(CurX+ValueColumn, CurY);
		Canvas.DrawText(RangeToTarget);
		
		CurY += 10;
	}
	
	// Weapon
	if ( !bNoTargetWeapon && (Target.Weapon != None) )
	{
		tmpStr = GetItemName(string(Target.Weapon.Class));
		Canvas.SetPos(CurX, CurY);
		Canvas.DrawText("WEAP: ");
		Canvas.SetPos(CurX+ValueColumn, CurY);
		Canvas.DrawText(tmpStr);
		
		CurY += 10;
	}

	// Score
	if ( !bNoTargetScore )
	{
		Canvas.SetPos(CurX, CurY);
		Canvas.DrawText("SCORE:");
		Canvas.SetPos(CurX+ValueColumn, CurY);
		Canvas.DrawText(int(Target.PlayerReplicationInfo.Score));
		
		CurY += 10;
	}
	
	// Runes
	if ( !bNoTargetRunes && bIsOnTeam )
	{
		RuneNames[0] = "HASTE";
		RuneNames[1] = "REGEN";
		RuneNames[2] = "RESIST";
		RuneNames[3] = "STRENGTH";
		RuneValues[0] = NnPRI.HasteAmt;
		RuneValues[1] = NnPRI.RegenAmt;
		RuneValues[2] = NnPRI.ResistAmt;
		RuneValues[3] = NnPRI.StrengthAmt;
		MaxRunes = 4;
		
		OldColor = Canvas.DrawColor;
		Canvas.SetPos(CurX, CurY);
		for (i=0; i<MaxRunes; i++)
		{
			if ( RuneValues[i] > 0 )
			{
				Canvas.DrawColor = RuneTextColor;
				Canvas.SetPos(CurX, CurY);
				Canvas.DrawText(RuneNames[i]$":");
				Canvas.SetPos(CurX+ValueColumn, CurY);
				Canvas.DrawColor = TextColor;
				Canvas.DrawText(RuneValues[i]);
				
				CurY += 10;
			}
		}
		Canvas.DrawColor = OldColor;
	}
}

simulated function float GetBarLength(float TotalBarLength, float MaxValue, float UseValue)
{
	if ( UseValue > MaxValue )
		UseValue = MaxValue;
	
	return ((TotalBarLength / MaxValue) * UseValue);
}

function Activate()
{
	if ( bActive )
		return;
	
	if ( CTFPlayer(Owner) != None )
	{
		CTFPlayer(Owner).TargetingComputer = self;
	}
	
	Super.Activate();
}

function Destroyed()
{
	if ( CTFPlayer(Owner) != None )
	{
		CTFPlayer(Owner).TargetingComputer = None;
	}
	
	Super.Destroyed();
}

state DeActivated {}

defaultproperties
{
     BarMeasure=Texture'NnCTFMedia.Misc.HUDBarMeasure'
     HealthBar=Texture'NnCTFMedia.Misc.HUDBar'
     TextColor=(R=255,G=255,B=255)
     RuneTextColor=(R=255,G=255,B=128)
     ValueColumn=60.000000
     bCanActivate=True
     bActivatable=True
     bDisplayableInv=True
     Icon=Texture'UnrealShare.Icons.I_Tran'
}
