//=============================================================================
// NnScoringLimitsMenu.
//=============================================================================
class NnScoringLimitsMenu expands NnGameOptionsMenu;

// 1 - CaptureLimit
// 2 - GoalTeamScore
// 3 - FragLimit
// 4 - TimeLimit
// 5 - BeenCapturedLimit

function bool ProcessLeft()
{
	if (Selection == 1)
		NnCTFGame(GameType).CaptureLimit = Max(0, NnCTFGame(GameType).CaptureLimit - 1.0);
	else if (Selection == 2)
		NnCTFGame(GameType).GoalTeamScore = FMax(0, NnCTFGame(GameType).GoalTeamScore - 10.0);
	else if (Selection == 3)
		NnCTFGame(GameType).FragLimit = Max(0, NnCTFGame(GameType).FragLimit - 5.0);
	else if (Selection == 4)
		NnCTFGame(GameType).TimeLimit = Max(0, NnCTFGame(GameType).TimeLimit - 1.0);
	else if (Selection == 5)
		NnCTFGame(GameType).BeenCapturedLimit = Max(0, NnCTFGame(GameType).BeenCapturedLimit - 1.0);
	else
		return false;
	
	return true;
}


function bool ProcessRight()
{
	if (Selection == 1)
		NnCTFGame(GameType).CaptureLimit += 1.0;
	else if (Selection == 2)
		NnCTFGame(GameType).GoalTeamScore += 10.0;
	else if (Selection == 3)
		NnCTFGame(GameType).FragLimit += 5.0;
	else if (Selection == 4)
		NnCTFGame(GameType).TimeLimit += 1.0;
	else if (Selection == 5)
		NnCTFGame(GameType).BeenCapturedLimit += 1.0;
	else
		return false;
	
	return true;
}


function DrawValues(canvas Canvas, int StartX, int StartY, int Spacing)
{
	local NnCTFGame NNGame;

	NNGame = NnCTFGame(GameType);

	// set up values
	MenuList[1] = string(NNGame.CaptureLimit);
	MenuList[2] = string(int(NNGame.GoalTeamScore));
	MenuList[3] = string(NNGame.FragLimit);
	MenuList[4] = string(NNGame.TimeLimit);
	MenuList[5] = string(NNGame.BeenCapturedLimit);

	DrawList(Canvas, false, Spacing, StartX + 160, StartY);  
}

defaultproperties
{
     MenuList(1)="Capture Limit"
     MenuList(2)="Team Score Limit"
     MenuList(3)="Frag Limit"
     MenuList(4)="Time Limit"
     MenuList(5)="Lost Capture Limit"
     MenuTitle="SCORING"
}
