//=============================================================================
// NnRuneConfigMenu.
//=============================================================================
class NnRuneConfigMenu expands NnGameOptionsMenu;

// 1 - bRunes
// 2 - MaxRuneCharge
// 3 - bDropRunesOnCapture
// 4 - Classic, Expanded, and Incremental
// 5 - Custom Config

function bool ProcessLeft()
{
	if ( Selection == 1 )
		NnCTFGame(GameType).bRunes = !NnCTFGame(GameType).bRunes;
	else if ( Selection == 2 )
		NnCTFGame(GameType).MaxRuneCharge = Max(0, NnCTFGame(GameType).MaxRuneCharge - 5);
	else if ( Selection == 3 )
		NnCTFGame(GameType).bDropRunesOnCapture = !NnCTFGame(GameType).bDropRunesOnCapture;
	else if ( Selection == 4 ) {
		NnCTFGame(GameType).PresetRuneConfig = Max(0, NnCTFGame(GameType).PresetRuneConfig - 1);
		NnCTFGame(GameType).SetupRuneConfig();
	}
	else if ( Selection == 5 );
	else
		return false;
}

function bool ProcessRight()
{
	local int MaxPRC;
	
	if ( Selection == 1 )
		NnCTFGame(GameType).bRunes = !NnCTFGame(GameType).bRunes;
	else if ( Selection == 2 )
		NnCTFGame(GameType).MaxRuneCharge += 5;
	else if ( Selection == 3 )
		NnCTFGame(GameType).bDropRunesOnCapture = !NnCTFGame(GameType).bDropRunesOnCapture;
	else if ( Selection == 4 ) {
		MaxPRC = NnCTFGame(GameType).MAX_PRESET_RUNE_CONFIG;
		NnCTFGame(GameType).PresetRuneConfig = Min(MaxPRC, NnCTFGame(GameType).PresetRuneConfig + 1);
		NnCTFGame(GameType).SetupRuneConfig();
	}
	else if ( Selection == 5 );
	else
		return false;
}

function bool ProcessSelection()
{
	local Menu ChildMenu;
	
	if ( Selection == 1 );
	else if ( Selection == 2 );
	else if ( Selection == 3 );
	else if ( Selection == 4 );
	else if ( Selection == 5 )
		ChildMenu = spawn(class'NnRuneCustomConfigMenu', owner);
	else
		return false;
	
	if ( ChildMenu != None )
	{
		NnGameOptionsMenu(ChildMenu).InitConfig(GameType);
		HUD(Owner).MainMenu = ChildMenu;
		ChildMenu.ParentMenu = self;
		ChildMenu.PlayerOwner = PlayerOwner;
	} else
		log(class$": ProcessSelection(): ERROR: ChildMenu == None");
	
	return true;
}

function DrawValues(canvas Canvas, int StartX, int StartY, int Spacing)
{
	local NnCTFGame NNGame;
	local string RCStr;
	local string HelpStr;

	NNGame = NnCTFGame(GameType);

	// set up values
	MenuList[1] = string(NNGame.bRunes);
	MenuList[2] = string(NNGame.MaxRuneCharge);
	MenuList[3] = string(NNGame.bDropRunesOnCapture);
	//MenuList[4] = string(NNGame.PresetRuneConfig);
	MenuList[5] = "";
	
	switch( NNGame.PresetRuneConfig )
	{
		case 0:
			RCStr = "Classic";
			HelpStr = "Four Runes, each at 100% power.";
			break;
		case 1:
			RCStr = "Expanded";
			HelpStr = "Eight Runes, each at 50% power (two of each rune type.)";
			break;
		case 2:
			RCSTR = "Incremental";
			HelpStr = "Twelve Runes, each at 10% power (three of each rune type.)";
		default:
			RCStr = "Custom Config";
			break;
	}
	MenuList[4] = RCStr;
	HelpMessage[4] = HelpStr;
	
	DrawList(Canvas, false, Spacing, StartX + 160, StartY);
}	

defaultproperties
{
     HelpMessage(1)="Should runes be enabled?"
     HelpMessage(2)="What is the maximum rune charge each player can have?"
     HelpMessage(3)="Should a team's runes be dropped and respawned after they capture a flag?"
     HelpMessage(5)="Create a custom set of rune amounts, types, and charges."
     MenuList(1)="Enable Runes"
     MenuList(2)="Max Rune Charge"
     MenuList(3)="Respawn After Capture"
     MenuList(4)="Preset Rune Config"
     MenuList(5)="Setup Custom Config"
     MenuTitle="RUNE CONFIG"
}
