//=============================================================================
// NnMiscGameplayOptionsMenu.
//=============================================================================
class NnMiscGameplayOptionsMenu expands NnGameOptionsMenu;

// 1 - bAutoFlagReturn
// 2 - bCaptureWithFlag
// 3 - bSpawnInTeamArea
// 4 - bNoTeamChanges
// 5 - bAutoAssignTeams
// 6 - bAllowSpectating
// 7 - bDisableGrenades
// 8 - MaxTeams
// 9 - bUseTargetingComputer
// 10 - bInvisibleBases


function bool ProcessLeft()
{
	if (Selection == 1)
		NnCTFGame(GameType).bAutoFlagReturn = !NnCTFGame(GameType).bAutoFlagReturn;
	else if (Selection == 2)
		NnCTFGame(GameType).bCaptureWithFlag = !NnCTFGame(GameType).bCaptureWithFlag;
	else if (Selection == 3)
		NnCTFGame(GameType).bSpawnInTeamArea = !NnCTFGame(GameType).bSpawnInTeamArea;
	else if (Selection == 4)
		NnCTFGame(GameType).bNoTeamChanges = !NnCTFGame(GameType).bNoTeamChanges;
	else if (Selection == 5)
		NnCTFGame(GameType).bAutoAssignTeams = !NnCTFGame(GameType).bAutoAssignTeams;
	else if (Selection == 6)
		NnCTFGame(GameType).bAllowSpectating = !NnCTFGame(GameType).bAllowSpectating;
	else if (Selection == 7)
		NnCTFGame(GameType).bDisableGrenades = !NnCTFGame(GameType).bDisableGrenades;
	else if (Selection == 8)
		NnCTFGame(GameType).MaxTeams = Max(2, NnCTFGame(GameType).MaxTeams - 1);
	else if (Selection == 9)
		NnCTFGame(GameType).bUseTargetingComputer = !NnCTFGame(GameType).bUseTargetingComputer;
	else if (Selection == 10)
		NnCTFGame(GameType).bInvisibleBases = !NnCTFGame(GameType).bInvisibleBases;
	else
		return false;
	
	return true;
}


function bool ProcessRight()
{
	// DLL: Since all the values here are boolean, the code would be the same
	//   as in ProcessLeft()
	if ( (Selection >= 1 && Selection <= 7) || (Selection >= 9 && Selection <= 10) )
		return ProcessLeft();
	else if ( Selection == 8 )
		NnCTFGame(GameType).MaxTeams = Min(4, NnCTFGame(GameType).MaxTeams + 1);
	else
		return false;
}


function bool ProcessYes()
{
	if (Selection == 1)
		NnCTFGame(GameType).bAutoFlagReturn = true;
	else if (Selection == 2)
		NnCTFGame(GameType).bCaptureWithFlag = true;
	else if (Selection == 3)
		NnCTFGame(GameType).bSpawnInTeamArea = true;
	else if (Selection == 4)
		NnCTFGame(GameType).bNoTeamChanges = true;
	else if (Selection == 5)
		NnCTFGame(GameType).bAutoAssignTeams = true;
	else if (Selection == 6)
		NnCTFGame(GameType).bAllowSpectating = true;
	else if (Selection == 7)
		NnCTFGame(GameType).bDisableGrenades = true;
	else if (Selection == 8);
	else if (Selection == 9)
		NnCTFGame(GameType).bUseTargetingComputer = true;
	else if (Selection == 10)
		NnCTFGame(GameType).bInvisibleBases = true;
	else
		return false;
	
	return true;
}


function bool ProcessNo()
{
	if (Selection == 1)
		NnCTFGame(GameType).bAutoFlagReturn = false;
	else if (Selection == 2)
		NnCTFGame(GameType).bCaptureWithFlag = false;
	else if (Selection == 3)
		NnCTFGame(GameType).bSpawnInTeamArea = false;
	else if (Selection == 4)
		NnCTFGame(GameType).bNoTeamChanges = false;
	else if (Selection == 5)
		NnCTFGame(GameType).bAutoAssignTeams = false;
	else if (Selection == 6)
		NnCTFGame(GameType).bAllowSpectating = false;
	else if (Selection == 7)
		NnCTFGame(GameType).bDisableGrenades = false;
	else if (Selection == 8);
	else if (Selection == 9)
		NnCTFGame(GameType).bUseTargetingComputer = false;
	else if (Selection == 10)
		NnCTFGame(GameType).bInvisibleBases = false;
	else
		return false;
	
	return true;
}


function DrawValues(canvas Canvas, int StartX, int StartY, int Spacing)
{
	local NnCTFGame NNGame;

	NNGame = NnCTFGame(GameType);

	// set up values
	MenuList[1] = string(NNGame.bAutoFlagReturn);
	MenuList[2] = string(NNGame.bCaptureWithFlag);
	MenuList[3] = string(NNGame.bSpawnInTeamArea);
	MenuList[4] = string(NNGame.bNoTeamChanges);
	MenuList[5] = string(NNGame.bAutoAssignTeams);
	MenuList[6] = string(NNGame.bAllowSpectating);
	MenuList[7] = string(NNGame.bDisableGrenades);
	MenuList[8] = string(NNGame.MaxTeams);
	MenuList[9] = string(NNGame.bUseTargetingComputer);
	MenuList[10] = string(NNGame.bInvisibleBases);
	
	DrawList(Canvas, false, Spacing, StartX + 160, StartY);
}	

defaultproperties
{
     MenuLength=10
     MenuList(1)="Auto Flag Return"
     MenuList(2)="Capture With Flag"
     MenuList(3)="Spawn In Team Area"
     MenuList(4)="No Team Changes"
     MenuList(5)="Auto Assign Teams"
     MenuList(6)="Allow Spectating"
     MenuList(7)="Disable Grenades"
     MenuList(8)="Max Teams"
     MenuList(9)="Targeting Computer"
     MenuList(10)="Invisible Bases"
     MenuTitle="MISC OPTIONS"
}
